/* *
 * @file RVCSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from RVCSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 * */

#include "RVCSm.h"

/*! \file Implementation of the state machine 'RVCSm'
*/




RVCSm::RVCSm()  :
ifaceTraceObserver(0),
stateConfVectorPosition(0),
ifaceAgVolCtrlUpdate(this),
ifaceAudioManagerVolCtrlUpdate(this),
ifaceAudioManagerVolCtrlIf(this),
ifaceAudioManagerVolCtrlIf_OCB(sc_null),
ifaceAgVolCtrlIf(this),
ifaceAgVolCtrlIf_OCB(sc_null),
ifaceVolCtrlTimerUpdate(this),
ifaceVolCtrlTimerIf(this),
ifaceVolCtrlTimerIf_OCB(sc_null),
ifaceUserActionVolCtrl(this),
ifaceVolCtrlSmHandlerIf(this),
ifaceVolCtrlSmHandlerIf_OCB(sc_null),
isRunningCycle(false)
{
}

RVCSm::~RVCSm()
{
}


using namespace rvcsm_events;

SctEvent* RVCSm::getNextEvent()
{
	SctEvent* nextEvent = 0;
	
	if(!inEventQueue.empty()) {
		nextEvent = inEventQueue.front();
		inEventQueue.pop_front();
	}
	
	return nextEvent;
}

void RVCSm::dispatch_event(SctEvent * event)
{
	if(event == 0) {
		return;
	}
	switch(event->name)
	{
		case SCI_AgVolCtrlUpdate_VOLUME_CHANGED:
		{
			ifaceAgVolCtrlUpdate.dispatch_event(event);
			break;
		}
		case SCI_AudioManagerVolCtrlUpdate_VOLUME_CHANGED:
		{
			ifaceAudioManagerVolCtrlUpdate.dispatch_event(event);
			break;
		}
		case SCI_VolCtrlTimerUpdate_TIMER_CALLBACK:
		{
			ifaceVolCtrlTimerUpdate.dispatch_event(event);
			break;
		}
		default:
			break;
	}
}

void RVCSm::SCI_AgVolCtrlUpdate::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AgVolCtrlUpdate_VOLUME_CHANGED:
		{
			internal_raise_vOLUME_CHANGED();
			break;
		}
		default:
			break;
	}
}
void RVCSm::SCI_AudioManagerVolCtrlUpdate::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AudioManagerVolCtrlUpdate_VOLUME_CHANGED:
		{
			internal_raise_vOLUME_CHANGED();
			break;
		}
		default:
			break;
	}
}
void RVCSm::SCI_AudioManagerVolCtrlIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void RVCSm::SCI_AgVolCtrlIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void RVCSm::SCI_VolCtrlTimerUpdate::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_VolCtrlTimerUpdate_TIMER_CALLBACK:
		{
			internal_raise_tIMER_CALLBACK();
			break;
		}
		default:
			break;
	}
}
void RVCSm::SCI_VolCtrlTimerIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void RVCSm::SCI_UserActionVolCtrl::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void RVCSm::SCI_VolCtrlSmHandlerIf::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}


void RVCSm::init()
{
	for (sc_ushort i = 0; i < maxOrthogonalStates; ++i)
		stateConfVector[i] = RVCSm_last_state;
	
	stateConfVectorPosition = 0;

	clearInEvents();
	clearOutEvents();
	
}

void RVCSm::enter()
{
	/* Default enter sequence for statechart RVCSm */
	enseq_Main_region_default();
}

void RVCSm::exit()
{
	/* Default exit sequence for statechart RVCSm */
	exseq_Main_region();
}

sc_boolean RVCSm::isActive() const
{
	return stateConfVector[0] != RVCSm_last_state;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean RVCSm::isFinal() const
{
   return false;}

void RVCSm::runCycle()
{
	if (isRunningCycle == false)
	{
		isRunningCycle = true;
		clearOutEvents();
						
		SctEvent * currentEvent = getNextEvent();
		
		do
		{
			/* Set event flags as usual */
			dispatch_event(currentEvent);
			
			for (stateConfVectorPosition = 0;
				stateConfVectorPosition < maxOrthogonalStates;
				stateConfVectorPosition++)
				{
					
				switch (stateConfVector[stateConfVectorPosition])
				{
				case Main_region_RVCHandler_RVCHandler_region_Idle :
				{
					Main_region_RVCHandler_RVCHandler_region_Idle_react(true);
					break;
				}
				case Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg :
				{
					Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg_react(true);
					break;
				}
				case Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio :
				{
					Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio_react(true);
					break;
				}
				case Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse :
				{
					Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse_react(true);
					break;
				}
				case Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse :
				{
					Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse_react(true);
					break;
				}
				default:
					break;
				}
			}
			
			/* Delete event from memory */
			delete currentEvent;
			clearInEvents();
		} while((currentEvent = getNextEvent()));
		
		isRunningCycle = false;
	}
}

void RVCSm::clearInEvents()
{
	ifaceAgVolCtrlUpdate.VOLUME_CHANGED_raised = false;
	ifaceAudioManagerVolCtrlUpdate.VOLUME_CHANGED_raised = false;
	ifaceVolCtrlTimerUpdate.TIMER_CALLBACK_raised = false;
}

void RVCSm::clearOutEvents()
{
}


sc_boolean RVCSm::isStateActive(RVCSmStates state) const
{
	switch (state)
	{
		case Main_region_RVCHandler : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RVCHANDLER] >= Main_region_RVCHandler
				&& stateConfVector[SCVI_MAIN_REGION_RVCHANDLER] <= Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse);
		case Main_region_RVCHandler_RVCHandler_region_Idle : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_IDLE] == Main_region_RVCHandler_RVCHandler_region_Idle
			);
		case Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_SETINPROGRESSTOAG] == Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg
			);
		case Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_SETINPROGRESSTOAUDIO] == Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio
			);
		case Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_WAITFORAGRESPONSE] == Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse
			);
		case Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_RVCHANDLER_RVCHANDLER_REGION_WAITFORAUDIORESPONSE] == Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse
			);
		default: return false;
	}
}

RVCSm::SCI_AgVolCtrlUpdate* RVCSm::getSCI_AgVolCtrlUpdate()
{
	return &ifaceAgVolCtrlUpdate;
}
/* Functions for event VOLUME_CHANGED in interface SCI_AgVolCtrlUpdate */
void RVCSm::SCI_AgVolCtrlUpdate::raise_vOLUME_CHANGED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgVolCtrlUpdate_VOLUME_CHANGED(SCI_AgVolCtrlUpdate_VOLUME_CHANGED));
	parent->runCycle();
}
void RVCSm::SCI_AgVolCtrlUpdate::internal_raise_vOLUME_CHANGED()
{
	VOLUME_CHANGED_raised = true;
}
RVCSm::SCI_AudioManagerVolCtrlUpdate* RVCSm::getSCI_AudioManagerVolCtrlUpdate()
{
	return &ifaceAudioManagerVolCtrlUpdate;
}
/* Functions for event VOLUME_CHANGED in interface SCI_AudioManagerVolCtrlUpdate */
void RVCSm::SCI_AudioManagerVolCtrlUpdate::raise_vOLUME_CHANGED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerVolCtrlUpdate_VOLUME_CHANGED(SCI_AudioManagerVolCtrlUpdate_VOLUME_CHANGED));
	parent->runCycle();
}
void RVCSm::SCI_AudioManagerVolCtrlUpdate::internal_raise_vOLUME_CHANGED()
{
	VOLUME_CHANGED_raised = true;
}
RVCSm::SCI_AudioManagerVolCtrlIf* RVCSm::getSCI_AudioManagerVolCtrlIf()
{
	return &ifaceAudioManagerVolCtrlIf;
}
void RVCSm::setSCI_AudioManagerVolCtrlIf_OCB(SCI_AudioManagerVolCtrlIf_OCB* operationCallback)
{
	ifaceAudioManagerVolCtrlIf_OCB = operationCallback;
}
RVCSm::SCI_AgVolCtrlIf* RVCSm::getSCI_AgVolCtrlIf()
{
	return &ifaceAgVolCtrlIf;
}
void RVCSm::setSCI_AgVolCtrlIf_OCB(SCI_AgVolCtrlIf_OCB* operationCallback)
{
	ifaceAgVolCtrlIf_OCB = operationCallback;
}
RVCSm::SCI_VolCtrlTimerUpdate* RVCSm::getSCI_VolCtrlTimerUpdate()
{
	return &ifaceVolCtrlTimerUpdate;
}
/* Functions for event TIMER_CALLBACK in interface SCI_VolCtrlTimerUpdate */
void RVCSm::SCI_VolCtrlTimerUpdate::raise_tIMER_CALLBACK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_VolCtrlTimerUpdate_TIMER_CALLBACK(SCI_VolCtrlTimerUpdate_TIMER_CALLBACK));
	parent->runCycle();
}
void RVCSm::SCI_VolCtrlTimerUpdate::internal_raise_tIMER_CALLBACK()
{
	TIMER_CALLBACK_raised = true;
}
RVCSm::SCI_VolCtrlTimerIf* RVCSm::getSCI_VolCtrlTimerIf()
{
	return &ifaceVolCtrlTimerIf;
}
void RVCSm::setSCI_VolCtrlTimerIf_OCB(SCI_VolCtrlTimerIf_OCB* operationCallback)
{
	ifaceVolCtrlTimerIf_OCB = operationCallback;
}
RVCSm::SCI_UserActionVolCtrl* RVCSm::getSCI_UserActionVolCtrl()
{
	return &ifaceUserActionVolCtrl;
}
RVCSm::SCI_VolCtrlSmHandlerIf* RVCSm::getSCI_VolCtrlSmHandlerIf()
{
	return &ifaceVolCtrlSmHandlerIf;
}
void RVCSm::setSCI_VolCtrlSmHandlerIf_OCB(SCI_VolCtrlSmHandlerIf_OCB* operationCallback)
{
	ifaceVolCtrlSmHandlerIf_OCB = operationCallback;
}

void RVCSm::setTraceObserver(ysc::TraceObserver<RVCSmStates>* tracingcallback) {
	ifaceTraceObserver = tracingcallback;
}

ysc::TraceObserver<RVCSm::RVCSmStates>* RVCSm::getTraceObserver() {
	return ifaceTraceObserver;
}

// implementations of all internal functions

/* Entry action for state 'Idle'. */
void RVCSm::enact_Main_region_RVCHandler_RVCHandler_region_Idle()
{
	/* Entry action for state 'Idle'. */
	ifaceVolCtrlSmHandlerIf_OCB->handleIdle();
}

/* Entry action for state 'SetInProgressToAg'. */
void RVCSm::enact_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg()
{
	/* Entry action for state 'SetInProgressToAg'. */
	ifaceAgVolCtrlIf_OCB->setAgSpeakerVolume();
	ifaceVolCtrlTimerIf_OCB->startTimer();
}

/* Entry action for state 'SetInProgressToAudio'. */
void RVCSm::enact_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio()
{
	/* Entry action for state 'SetInProgressToAudio'. */
	ifaceAudioManagerVolCtrlIf_OCB->setAmSpeakerVolume();
	ifaceVolCtrlTimerIf_OCB->startTimer();
}

/* Exit action for state 'WaitForAgResponse'. */
void RVCSm::exact_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse()
{
	/* Exit action for state 'WaitForAgResponse'. */
	ifaceVolCtrlTimerIf_OCB->stopTimer();
}

/* Exit action for state 'WaitForAudioResponse'. */
void RVCSm::exact_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse()
{
	/* Exit action for state 'WaitForAudioResponse'. */
	ifaceVolCtrlTimerIf_OCB->stopTimer();
}

/* 'default' enter sequence for state RVCHandler */
void RVCSm::enseq_Main_region_RVCHandler_default()
{
	/* 'default' enter sequence for state RVCHandler */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(RVCSm::Main_region_RVCHandler);
	}
	enseq_Main_region_RVCHandler_RVCHandler_region_default();
}

/* 'default' enter sequence for state Idle */
void RVCSm::enseq_Main_region_RVCHandler_RVCHandler_region_Idle_default()
{
	/* 'default' enter sequence for state Idle */
	enact_Main_region_RVCHandler_RVCHandler_region_Idle();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(RVCSm::Main_region_RVCHandler_RVCHandler_region_Idle);
	}
	stateConfVector[0] = Main_region_RVCHandler_RVCHandler_region_Idle;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state SetInProgressToAg */
void RVCSm::enseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg_default()
{
	/* 'default' enter sequence for state SetInProgressToAg */
	enact_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(RVCSm::Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg);
	}
	stateConfVector[0] = Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state SetInProgressToAudio */
void RVCSm::enseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio_default()
{
	/* 'default' enter sequence for state SetInProgressToAudio */
	enact_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(RVCSm::Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio);
	}
	stateConfVector[0] = Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForAgResponse */
void RVCSm::enseq_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse_default()
{
	/* 'default' enter sequence for state WaitForAgResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(RVCSm::Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse);
	}
	stateConfVector[0] = Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForAudioResponse */
void RVCSm::enseq_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse_default()
{
	/* 'default' enter sequence for state WaitForAudioResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(RVCSm::Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse);
	}
	stateConfVector[0] = Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for region Main_region */
void RVCSm::enseq_Main_region_default()
{
	/* 'default' enter sequence for region Main_region */
	react_Main_region__entry_Default();
}

/* 'default' enter sequence for region RVCHandler_region */
void RVCSm::enseq_Main_region_RVCHandler_RVCHandler_region_default()
{
	/* 'default' enter sequence for region RVCHandler_region */
	react_Main_region_RVCHandler_RVCHandler_region__entry_Default();
}

/* Default exit sequence for state RVCHandler */
void RVCSm::exseq_Main_region_RVCHandler()
{
	/* Default exit sequence for state RVCHandler */
	exseq_Main_region_RVCHandler_RVCHandler_region();
}

/* Default exit sequence for state Idle */
void RVCSm::exseq_Main_region_RVCHandler_RVCHandler_region_Idle()
{
	/* Default exit sequence for state Idle */
	stateConfVector[0] = RVCSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state SetInProgressToAg */
void RVCSm::exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg()
{
	/* Default exit sequence for state SetInProgressToAg */
	stateConfVector[0] = RVCSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state SetInProgressToAudio */
void RVCSm::exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio()
{
	/* Default exit sequence for state SetInProgressToAudio */
	stateConfVector[0] = RVCSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForAgResponse */
void RVCSm::exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse()
{
	/* Default exit sequence for state WaitForAgResponse */
	stateConfVector[0] = RVCSm_last_state;
	stateConfVectorPosition = 0;
	exact_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse();
}

/* Default exit sequence for state WaitForAudioResponse */
void RVCSm::exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse()
{
	/* Default exit sequence for state WaitForAudioResponse */
	stateConfVector[0] = RVCSm_last_state;
	stateConfVectorPosition = 0;
	exact_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse();
}

/* Default exit sequence for region Main_region */
void RVCSm::exseq_Main_region()
{
	/* Default exit sequence for region Main_region */
	/* Handle exit of all possible states (of RVCSm.Main_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_RVCHandler_RVCHandler_region_Idle :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_Idle();
			break;
		}
		case Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg();
			break;
		}
		case Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio();
			break;
		}
		case Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse();
			break;
		}
		case Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region RVCHandler_region */
void RVCSm::exseq_Main_region_RVCHandler_RVCHandler_region()
{
	/* Default exit sequence for region RVCHandler_region */
	/* Handle exit of all possible states (of RVCSm.Main_region.RVCHandler.RVCHandler_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_RVCHandler_RVCHandler_region_Idle :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_Idle();
			break;
		}
		case Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg();
			break;
		}
		case Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio();
			break;
		}
		case Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse();
			break;
		}
		case Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse :
		{
			exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse();
			break;
		}
		default: break;
	}
}

/* Default react sequence for initial entry  */
void RVCSm::react_Main_region_RVCHandler_RVCHandler_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_RVCHandler_RVCHandler_region_Idle_default();
}

/* Default react sequence for initial entry  */
void RVCSm::react_Main_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_RVCHandler_default();
}

sc_boolean RVCSm::react() {
	/* State machine reactions. */
	return false;
}

sc_boolean RVCSm::Main_region_RVCHandler_react(const sc_boolean try_transition) {
	/* The reactions of state RVCHandler. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceVolCtrlTimerUpdate.TIMER_CALLBACK_raised)
		{ 
			exseq_Main_region_RVCHandler();
			if(ifaceTraceObserver != sc_null) {
				ifaceTraceObserver->stateEntered(RVCSm::Main_region_RVCHandler);
			}
			enseq_Main_region_RVCHandler_RVCHandler_region_Idle_default();
			react();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean RVCSm::Main_region_RVCHandler_RVCHandler_region_Idle_react(const sc_boolean try_transition) {
	/* The reactions of state Idle. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerVolCtrlUpdate.VOLUME_CHANGED_raised)
		{ 
			exseq_Main_region_RVCHandler_RVCHandler_region_Idle();
			enseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg_default();
			Main_region_RVCHandler_react(false);
		}  else
		{
			if (ifaceAgVolCtrlUpdate.VOLUME_CHANGED_raised)
			{ 
				exseq_Main_region_RVCHandler_RVCHandler_region_Idle();
				enseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio_default();
				Main_region_RVCHandler_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RVCHandler_react(try_transition);
	} 
	return did_transition;
}

sc_boolean RVCSm::Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg_react(const sc_boolean try_transition) {
	/* The reactions of state SetInProgressToAg. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgVolCtrlUpdate.VOLUME_CHANGED_raised)
		{ 
			exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg();
			enseq_Main_region_RVCHandler_RVCHandler_region_Idle_default();
			Main_region_RVCHandler_react(false);
		}  else
		{
			if (ifaceAudioManagerVolCtrlUpdate.VOLUME_CHANGED_raised)
			{ 
				exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg();
				enseq_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse_default();
				Main_region_RVCHandler_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RVCHandler_react(try_transition);
	} 
	return did_transition;
}

sc_boolean RVCSm::Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio_react(const sc_boolean try_transition) {
	/* The reactions of state SetInProgressToAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerVolCtrlUpdate.VOLUME_CHANGED_raised)
		{ 
			exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio();
			enseq_Main_region_RVCHandler_RVCHandler_region_Idle_default();
			Main_region_RVCHandler_react(false);
		}  else
		{
			if (ifaceAgVolCtrlUpdate.VOLUME_CHANGED_raised)
			{ 
				exseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio();
				enseq_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse_default();
				Main_region_RVCHandler_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RVCHandler_react(try_transition);
	} 
	return did_transition;
}

sc_boolean RVCSm::Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAgResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAgVolCtrlUpdate.VOLUME_CHANGED_raised) || (ifaceVolCtrlTimerUpdate.TIMER_CALLBACK_raised))
		{ 
			exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAgResponse();
			enseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAg_default();
			Main_region_RVCHandler_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RVCHandler_react(try_transition);
	} 
	return did_transition;
}

sc_boolean RVCSm::Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAudioManagerVolCtrlUpdate.VOLUME_CHANGED_raised) || (ifaceVolCtrlTimerUpdate.TIMER_CALLBACK_raised))
		{ 
			exseq_Main_region_RVCHandler_RVCHandler_region_WaitForAudioResponse();
			enseq_Main_region_RVCHandler_RVCHandler_region_SetInProgressToAudio_default();
			Main_region_RVCHandler_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_RVCHandler_react(try_transition);
	} 
	return did_transition;
}



