/**
 * @file ISmVolumeControlIf.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the interface definition of the SmRemoteVolumeIf class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This file provides the state machine interfaces of voice call
 *
 * @ingroup PmCore
 */

#ifndef ISmVolumeControlIf_h
#define ISmVolumeControlIf_h

#include "PmCoreIfTypes.h"
#include "BtStackWrapperTypes.h"

namespace pmcore
{
   class ISmVolumeControlIf
   {
   public:

      /**
       * Destructor of ISmVolumeControlIf class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      virtual ~ISmVolumeControlIf(){}

      // Request calls
      /**
       * This method is used to post the volume update from Audio to the Remote volume state machine

       * @param[in] deviceAddress - Address of BT device
       * @param[in] volume - volume level
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      virtual void onVolumeUpdateFromAm(IN const BdAddress& deviceAddress, IN const VolumeLevel& volume) = 0;

      /**
       * This method is used to post the volume update from AG to the Remote volume state machine
       *
       * @param[in] deviceAddress - Address of BT device
       * @param[in] volume - volume level
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      virtual void onVolumeUpdateFromAg(IN const BdAddress& deviceAddress, IN const VolumeLevel& volume) = 0;

      /**
       * This method is used to post the timer update to the Remote volume state machine
       *
       * @param[in] deviceAddress - Address of BT device
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      virtual void onTimerEventUpdate(IN const BdAddress& deviceAddress) = 0;
   };
}

#endif //ISmVolumeControlIf_h
