/**
 * @file PropertyUpdateHandler.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PropertyUpdateHandler class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef PropertyUpdateHandler_h
#define PropertyUpdateHandler_h

#include "PmCoreIfTypes.h"

namespace pmcore
{
   class PropertyUpdateHandler
   {
   public:

      /**
       * Destructor of PropertyUpdateHandler class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      virtual ~PropertyUpdateHandler() {};

      /**
       * This method is used to notify property changes to all controllers
       * This should be override by controllers to receive property updates
       *
       * @param[in] propertyId - Id of the property or event
       * @param[in] propertyDetails - Details of the property or event
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      virtual void onPropertyUpdate(IN const PmCorePropertyAndEventId propertyId,
            IN std::shared_ptr<void> propertyDetails ) = 0;

   private:

   };

   typedef std::vector<PropertyUpdateHandler*> ControllerList;                   /**< controllers list */
   typedef std::map<PmCorePropertyAndEventId, ControllerList> PropertyToControllersMap; /**< property to controllers map */
}

#endif // PropertyUpdateHandler_h
