/**
 * @file PropertyDetails.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PropertyDetails class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details This class is used as a template for sending different property messages from BtSatck layer
 * to PropertyUpdateNotifierToCore class. Here "DetailsType" act as a template parameter which holds different
 * types of property. So effectively reusing the properties defined in "core/Interface/inc/Types"
 *
 * @ingroup PmCore
 */

#ifndef PropertyDetails_h
#define PropertyDetails_h

#include "PmCoreIfTypes.h"

namespace pmcore
{
   template <class DetailsType>
   class PropertyDetails
   {
   public:
      /**
       * Constructor of PropertyDetails class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      PropertyDetails(IN const BdAddress& bdAddress, IN const DetailsType& PropertyDetails) :
         _bdAddress(bdAddress),
         _propertyDetails(PropertyDetails)
      {
      }


      /**
       * Copy Constructor of PropertyDetails class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      PropertyDetails(const PropertyDetails& other) :
         _bdAddress(other._bdAddress),
         _propertyDetails(other._propertyDetails)
      {
      }

      /**
       * Destructor of PropertyDetails class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      ~PropertyDetails(){}

      /**
       * This method is used to get the BdAddress of the message
       *
       * @param[in]
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return BdAddress - deviceAddress
       */
      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      /**
       * This method is used to get the MessageType of the message
       *
       * @param[in]
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return DetailsType - Type of the message
       */
      inline const DetailsType& getMessage(void) const
      {
         return _propertyDetails;
      }

   private:
      BdAddress         _bdAddress;           /**< BT address of the device*/
      DetailsType       _propertyDetails;     /**< Type of the message*/
   };
}

#endif // PropertyDetails_h
