/**
 * @file PmCoreIfMessageResult.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the PmCoreIfMessageResult
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @detailss
 *
 * @ingroup PmCore
 */

#ifndef PmCoreIfMessageResult_h
#define PmCoreIfMessageResult_h

#include "PmCoreIfMessage.h"
#include "PmCoreIfTypes.h"
#include "PmAudioManagerIfTypes.h"

/* Note:
 * Function headers are not added to avoid large file length */

// TODO: all result message's parameters needs to be revisited once
// BtStack call back methods are defined.
namespace pmcore
{
   class PmCoreIfMessageResult : public PmCoreIfMessage
   {
   public:

      friend void swap(PmCoreIfMessageResult& first, PmCoreIfMessageResult& second);

      explicit PmCoreIfMessageResult(IN const PmCoreIfMsgId messageId, IN const BTSResult& btsResult,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT);

      PmCoreIfMessageResult(IN const PmCoreIfMessageResult& other);

      virtual ~PmCoreIfMessageResult();

      PmCoreIfMessageResult& operator=(PmCoreIfMessageResult other);

      bool operator==(const PmCoreIfMessageResult& rhs) const;


      inline void setBTSResult(IN const BTSResult& btsResult)
      {
         _btsResult = btsResult;
      }

      inline const BTSResult getBTSResult(void) const
      {
         return _btsResult;
      }

      virtual void traceMessage(void) const override;

   private:
      BTSResult          _btsResult;        /**< Instance of BTSResult */
   };

   class PmCoreIfMessage_RequestPhoneNumberResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_RequestPhoneNumberResult& first,
            PmCoreIfMessage_RequestPhoneNumberResult& second);

      explicit PmCoreIfMessage_RequestPhoneNumberResult();

      explicit PmCoreIfMessage_RequestPhoneNumberResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const TelephoneNumber& telephoneNumber, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_RequestPhoneNumberResult(IN const PmCoreIfMessage_RequestPhoneNumberResult& other);

      virtual ~PmCoreIfMessage_RequestPhoneNumberResult();

      PmCoreIfMessage_RequestPhoneNumberResult& operator=(PmCoreIfMessage_RequestPhoneNumberResult other);

      bool operator==(const PmCoreIfMessage_RequestPhoneNumberResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setTelephoneNumber(IN const TelephoneNumber& telephoneNumber)
      {
         _telephoneNumber = telephoneNumber;
      }

      inline const TelephoneNumber& getTelephoneNumber(void) const
      {
         return _telephoneNumber;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      TelephoneNumber    _telephoneNumber;  /**< Instance of TelephoneNumber */
   };

   class PmCoreIfMessage_GetSubscriberResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_GetSubscriberResult& first, PmCoreIfMessage_GetSubscriberResult& second);

      explicit PmCoreIfMessage_GetSubscriberResult();

      explicit PmCoreIfMessage_GetSubscriberResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const NumberType numberType, IN const TelephoneNumber& telephoneNumber, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_GetSubscriberResult(IN const PmCoreIfMessage_GetSubscriberResult& other);

      virtual ~PmCoreIfMessage_GetSubscriberResult();

      PmCoreIfMessage_GetSubscriberResult& operator=(PmCoreIfMessage_GetSubscriberResult other);

      bool operator==(const PmCoreIfMessage_GetSubscriberResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setNumberType(IN const NumberType numberType)
      {
         _numberType = numberType;
      }

      inline NumberType getNumberType(void) const
      {
         return _numberType;
      }

      inline void setTelephoneNumber(IN const TelephoneNumber& telephoneNumber)
      {
         _telephoneNumber = telephoneNumber;
      }

      inline const TelephoneNumber& getTelephoneNumber(void) const
      {
         return _telephoneNumber;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      NumberType         _numberType;       /**< Type of the Number */
      TelephoneNumber    _telephoneNumber;  /**< Instance of TelephoneNumber */
   };

   class PmCoreIfMessage_SendCustomATCommandResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_SendCustomATCommandResult& first,
            PmCoreIfMessage_SendCustomATCommandResult& second);

      explicit PmCoreIfMessage_SendCustomATCommandResult();

      explicit PmCoreIfMessage_SendCustomATCommandResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_SendCustomATCommandResult(IN const PmCoreIfMessage_SendCustomATCommandResult& other);

      virtual ~PmCoreIfMessage_SendCustomATCommandResult();

      PmCoreIfMessage_SendCustomATCommandResult& operator=(PmCoreIfMessage_SendCustomATCommandResult other);

      bool operator==(const PmCoreIfMessage_SendCustomATCommandResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_HFUpdateIndicatorsValueResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_HFUpdateIndicatorsValueResult& first,
            PmCoreIfMessage_HFUpdateIndicatorsValueResult& second);

      explicit PmCoreIfMessage_HFUpdateIndicatorsValueResult();

      explicit PmCoreIfMessage_HFUpdateIndicatorsValueResult(IN const BTSResult& btsResult,
            IN const BdAddress& bdAddress, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_HFUpdateIndicatorsValueResult(IN const PmCoreIfMessage_HFUpdateIndicatorsValueResult& other);

      virtual ~PmCoreIfMessage_HFUpdateIndicatorsValueResult();

      PmCoreIfMessage_HFUpdateIndicatorsValueResult& operator=(PmCoreIfMessage_HFUpdateIndicatorsValueResult other);

      bool operator==(const PmCoreIfMessage_HFUpdateIndicatorsValueResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   //TODO: parameters needs to be checked
   class PmCoreIfMessage_GetModemsResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_GetModemsResult& first, PmCoreIfMessage_GetModemsResult& second);

      explicit PmCoreIfMessage_GetModemsResult();

      explicit PmCoreIfMessage_GetModemsResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_GetModemsResult(IN const PmCoreIfMessage_GetModemsResult& other);

      virtual ~PmCoreIfMessage_GetModemsResult();

      PmCoreIfMessage_GetModemsResult& operator=(PmCoreIfMessage_GetModemsResult other);

      bool operator==(const PmCoreIfMessage_GetModemsResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_AcceptSCOConnectResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_AcceptSCOConnectResult& first, PmCoreIfMessage_AcceptSCOConnectResult& second);

      explicit PmCoreIfMessage_AcceptSCOConnectResult();

      explicit PmCoreIfMessage_AcceptSCOConnectResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_AcceptSCOConnectResult(IN const PmCoreIfMessage_AcceptSCOConnectResult& other);

      virtual ~PmCoreIfMessage_AcceptSCOConnectResult();

      PmCoreIfMessage_AcceptSCOConnectResult& operator=(PmCoreIfMessage_AcceptSCOConnectResult other);

      bool operator==(const PmCoreIfMessage_AcceptSCOConnectResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_SiriEnableResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_SiriEnableResult& first, PmCoreIfMessage_SiriEnableResult& second);

      explicit PmCoreIfMessage_SiriEnableResult();

      explicit PmCoreIfMessage_SiriEnableResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_SiriEnableResult(IN const PmCoreIfMessage_SiriEnableResult& other);

      virtual ~PmCoreIfMessage_SiriEnableResult();

      PmCoreIfMessage_SiriEnableResult& operator=(PmCoreIfMessage_SiriEnableResult other);

      bool operator==(const PmCoreIfMessage_SiriEnableResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_SiriSetNRResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_SiriSetNRResult& first, PmCoreIfMessage_SiriSetNRResult& second);

      explicit PmCoreIfMessage_SiriSetNRResult();

      explicit PmCoreIfMessage_SiriSetNRResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_SiriSetNRResult(IN const PmCoreIfMessage_SiriSetNRResult& other);

      virtual ~PmCoreIfMessage_SiriSetNRResult();

      PmCoreIfMessage_SiriSetNRResult& operator=(PmCoreIfMessage_SiriSetNRResult other);

      bool operator==(const PmCoreIfMessage_SiriSetNRResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_GetCallsResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_GetCallsResult& first, PmCoreIfMessage_GetCallsResult& second);

      explicit PmCoreIfMessage_GetCallsResult();

      explicit PmCoreIfMessage_GetCallsResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const BTSVoiceCallInfoList& btsVoiceCallInfoList, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_GetCallsResult(IN const PmCoreIfMessage_GetCallsResult& other);

      virtual ~PmCoreIfMessage_GetCallsResult();

      PmCoreIfMessage_GetCallsResult& operator=(PmCoreIfMessage_GetCallsResult other);

      bool operator==(const PmCoreIfMessage_GetCallsResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setBTSVoiceCallInfoList(IN const BTSVoiceCallInfoList& btsVoiceCallInfoList)
      {
         _btsVoiceCallInfoList = btsVoiceCallInfoList;
      }

      inline const BTSVoiceCallInfoList& getBTSVoiceCallInfoList(void) const
      {
         return _btsVoiceCallInfoList;
      }

   private:
      BdAddress            _bdAddress;            /**< Instance of BdAddress */
      BTSVoiceCallInfoList _btsVoiceCallInfoList; /**< List of BTSVoiceCallInfo */
   };

   class PmCoreIfMessage_DialResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_DialResult& first, PmCoreIfMessage_DialResult& second);

      explicit PmCoreIfMessage_DialResult();

      explicit PmCoreIfMessage_DialResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const CallInstance callInstance, IN const TelephoneNumber telephoneNumber,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_DialResult(IN const PmCoreIfMessage_DialResult& other);

      virtual ~PmCoreIfMessage_DialResult();

      PmCoreIfMessage_DialResult& operator=(PmCoreIfMessage_DialResult other);

      bool operator==(const PmCoreIfMessage_DialResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setCallInstance(IN const CallInstance callInstance)
      {
         _callInstance = callInstance;
      }

      inline CallInstance getCallInstance(void) const
      {
         return _callInstance;
      }

      inline void setTelephoneNumber(IN const TelephoneNumber telephoneNumber)
      {
         _telephoneNumber = telephoneNumber;
      }

      inline TelephoneNumber getTelephoneNumber(void) const
      {
         return _telephoneNumber;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      CallInstance       _callInstance;     /**< Instance of CallInstance */
      TelephoneNumber    _telephoneNumber;  /**< Telephone number used for dial request for Error handling */
   };

   class PmCoreIfMessage_SpeedDialResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_SpeedDialResult& first, PmCoreIfMessage_SpeedDialResult& second);

      explicit PmCoreIfMessage_SpeedDialResult();

      explicit PmCoreIfMessage_SpeedDialResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const CallInstance callInstance, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_SpeedDialResult(IN const PmCoreIfMessage_SpeedDialResult& other);

      virtual ~PmCoreIfMessage_SpeedDialResult();

      PmCoreIfMessage_SpeedDialResult& operator=(PmCoreIfMessage_SpeedDialResult other);

      bool operator==(const PmCoreIfMessage_SpeedDialResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setCallInstance(IN const CallInstance callInstance)
      {
         _callInstance = callInstance;
      }

      inline CallInstance getCallInstance(void) const
      {
         return _callInstance;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      CallInstance       _callInstance;     /**< Instance of CallInstance */
   };

   class PmCoreIfMessage_RedialResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_RedialResult& first, PmCoreIfMessage_RedialResult& second);

      explicit PmCoreIfMessage_RedialResult();

      explicit PmCoreIfMessage_RedialResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const CallInstance callInstance, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_RedialResult(IN const PmCoreIfMessage_RedialResult& other);

      virtual ~PmCoreIfMessage_RedialResult();

      PmCoreIfMessage_RedialResult& operator=(PmCoreIfMessage_RedialResult other);

      bool operator==(const PmCoreIfMessage_RedialResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setCallInstance(IN const CallInstance callInstance)
      {
         _callInstance = callInstance;
      }

      inline CallInstance getCallInstance(void) const
      {
         return _callInstance;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      CallInstance       _callInstance;     /**< Instance of CallInstance */
   };

   class PmCoreIfMessage_SwapCallResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_SwapCallResult& first, PmCoreIfMessage_SwapCallResult& second);

      explicit PmCoreIfMessage_SwapCallResult();

      explicit PmCoreIfMessage_SwapCallResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_SwapCallResult(IN const PmCoreIfMessage_SwapCallResult& other);

      virtual ~PmCoreIfMessage_SwapCallResult();

      PmCoreIfMessage_SwapCallResult& operator=(PmCoreIfMessage_SwapCallResult other);

      bool operator==(const PmCoreIfMessage_SwapCallResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_ReleaseAndAcceptResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_ReleaseAndAcceptResult& first, PmCoreIfMessage_ReleaseAndAcceptResult& second);

      explicit PmCoreIfMessage_ReleaseAndAcceptResult();

      explicit PmCoreIfMessage_ReleaseAndAcceptResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_ReleaseAndAcceptResult(IN const PmCoreIfMessage_ReleaseAndAcceptResult& other);

      virtual ~PmCoreIfMessage_ReleaseAndAcceptResult();

      PmCoreIfMessage_ReleaseAndAcceptResult& operator=(PmCoreIfMessage_ReleaseAndAcceptResult other);

      bool operator==(const PmCoreIfMessage_ReleaseAndAcceptResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_ReleaseAndSwapResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_ReleaseAndSwapResult& first, PmCoreIfMessage_ReleaseAndSwapResult& second);

      explicit PmCoreIfMessage_ReleaseAndSwapResult();

      explicit PmCoreIfMessage_ReleaseAndSwapResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_ReleaseAndSwapResult(IN const PmCoreIfMessage_ReleaseAndSwapResult& other);

      virtual ~PmCoreIfMessage_ReleaseAndSwapResult();

      PmCoreIfMessage_ReleaseAndSwapResult& operator=(PmCoreIfMessage_ReleaseAndSwapResult other);

      bool operator==(const PmCoreIfMessage_ReleaseAndSwapResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_HoldAndAcceptResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_HoldAndAcceptResult& first, PmCoreIfMessage_HoldAndAcceptResult& second);

      explicit PmCoreIfMessage_HoldAndAcceptResult();

      explicit PmCoreIfMessage_HoldAndAcceptResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_HoldAndAcceptResult(IN const PmCoreIfMessage_HoldAndAcceptResult& other);

      virtual ~PmCoreIfMessage_HoldAndAcceptResult();

      PmCoreIfMessage_HoldAndAcceptResult& operator=(PmCoreIfMessage_HoldAndAcceptResult other);

      bool operator==(const PmCoreIfMessage_HoldAndAcceptResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_HangupAllResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_HangupAllResult& first, PmCoreIfMessage_HangupAllResult& second);

      explicit PmCoreIfMessage_HangupAllResult();

      explicit PmCoreIfMessage_HangupAllResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_HangupAllResult(IN const PmCoreIfMessage_HangupAllResult& other);

      virtual ~PmCoreIfMessage_HangupAllResult();

      PmCoreIfMessage_HangupAllResult& operator=(PmCoreIfMessage_HangupAllResult other);

      bool operator==(const PmCoreIfMessage_HangupAllResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_SplitCallsResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_SplitCallsResult& first, PmCoreIfMessage_SplitCallsResult& second);

      explicit PmCoreIfMessage_SplitCallsResult();

      explicit PmCoreIfMessage_SplitCallsResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const CallInstanceList& callInstanceList, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_SplitCallsResult(IN const PmCoreIfMessage_SplitCallsResult& other);

      virtual ~PmCoreIfMessage_SplitCallsResult();

      PmCoreIfMessage_SplitCallsResult& operator=(PmCoreIfMessage_SplitCallsResult other);

      bool operator==(const PmCoreIfMessage_SplitCallsResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setCallInstanceList(IN const CallInstanceList& callInstanceList)
      {
         _callInstanceList = callInstanceList;
      }

      inline const CallInstanceList& getCallInstanceList(void) const
      {
         return _callInstanceList;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      CallInstanceList   _callInstanceList; /**< List of CallInstance */
   };

   class PmCoreIfMessage_MergeCallsResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_MergeCallsResult& first, PmCoreIfMessage_MergeCallsResult& second);

      explicit PmCoreIfMessage_MergeCallsResult();

      explicit PmCoreIfMessage_MergeCallsResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const CallInstanceList& callInstanceList, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_MergeCallsResult(IN const PmCoreIfMessage_MergeCallsResult& other);

      virtual ~PmCoreIfMessage_MergeCallsResult();

      PmCoreIfMessage_MergeCallsResult& operator=(PmCoreIfMessage_MergeCallsResult other);

      bool operator==(const PmCoreIfMessage_MergeCallsResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setCallInstanceList(IN const CallInstanceList& callInstanceList)
      {
         _callInstanceList = callInstanceList;
      }

      inline const CallInstanceList& getCallInstanceList(void) const
      {
         return _callInstanceList;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      CallInstanceList   _callInstanceList; /**< List of CallInstance */
   };

   class PmCoreIfMessage_HangupMultipartyResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_HangupMultipartyResult& first, PmCoreIfMessage_HangupMultipartyResult& second);

      explicit PmCoreIfMessage_HangupMultipartyResult();

      explicit PmCoreIfMessage_HangupMultipartyResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_HangupMultipartyResult(IN const PmCoreIfMessage_HangupMultipartyResult& other);

      virtual ~PmCoreIfMessage_HangupMultipartyResult();

      PmCoreIfMessage_HangupMultipartyResult& operator=(PmCoreIfMessage_HangupMultipartyResult other);

      bool operator==(const PmCoreIfMessage_HangupMultipartyResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_SendDTMFResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_SendDTMFResult& first, PmCoreIfMessage_SendDTMFResult& second);

      explicit PmCoreIfMessage_SendDTMFResult();

      explicit PmCoreIfMessage_SendDTMFResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_SendDTMFResult(IN const PmCoreIfMessage_SendDTMFResult& other);

      virtual ~PmCoreIfMessage_SendDTMFResult();

      PmCoreIfMessage_SendDTMFResult& operator=(PmCoreIfMessage_SendDTMFResult other);

      bool operator==(const PmCoreIfMessage_SendDTMFResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
   };

   class PmCoreIfMessage_HangupCallResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_HangupCallResult& first, PmCoreIfMessage_HangupCallResult& second);

      explicit PmCoreIfMessage_HangupCallResult();

      explicit PmCoreIfMessage_HangupCallResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const CallInstance callInstance, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_HangupCallResult(IN const PmCoreIfMessage_HangupCallResult& other);

      virtual ~PmCoreIfMessage_HangupCallResult();

      PmCoreIfMessage_HangupCallResult& operator=(PmCoreIfMessage_HangupCallResult other);

      bool operator==(const PmCoreIfMessage_HangupCallResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setCallInstance(IN const CallInstance callInstance)
      {
         _callInstance = callInstance;
      }

      inline CallInstance getCallInstance(void) const
      {
         return _callInstance;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      CallInstance       _callInstance;     /**< Instance of CallInstance */
   };

   class PmCoreIfMessage_AcceptCallResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_AcceptCallResult& first, PmCoreIfMessage_AcceptCallResult& second);

      explicit PmCoreIfMessage_AcceptCallResult();

      explicit PmCoreIfMessage_AcceptCallResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const CallInstance callInstance, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_AcceptCallResult(IN const PmCoreIfMessage_AcceptCallResult& other);

      virtual ~PmCoreIfMessage_AcceptCallResult();

      PmCoreIfMessage_AcceptCallResult& operator=(PmCoreIfMessage_AcceptCallResult other);

      bool operator==(const PmCoreIfMessage_AcceptCallResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setCallInstance(IN const CallInstance callInstance)
      {
         _callInstance = callInstance;
      }

      inline CallInstance getCallInstance(void) const
      {
         return _callInstance;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      CallInstance       _callInstance;     /**< Instance of CallInstance */
   };

   class PmCoreIfMessage_HoldIncomingCallResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_HoldIncomingCallResult& first, PmCoreIfMessage_HoldIncomingCallResult& second);

      explicit PmCoreIfMessage_HoldIncomingCallResult();

      explicit PmCoreIfMessage_HoldIncomingCallResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const CallInstance callInstance, IN const ActType act,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_HoldIncomingCallResult(IN const PmCoreIfMessage_HoldIncomingCallResult& other);

      virtual ~PmCoreIfMessage_HoldIncomingCallResult();

      PmCoreIfMessage_HoldIncomingCallResult& operator=(PmCoreIfMessage_HoldIncomingCallResult other);

      bool operator==(const PmCoreIfMessage_HoldIncomingCallResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setCallInstance(IN const CallInstance callInstance)
      {
         _callInstance = callInstance;
      }

      inline CallInstance getCallInstance(void) const
      {
         return _callInstance;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      CallInstance       _callInstance;     /**< Instance of CallInstance */
   };
   
   class PmCoreIfMessage_TransferAudioResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_TransferAudioResult& first, PmCoreIfMessage_TransferAudioResult& second);

      explicit PmCoreIfMessage_TransferAudioResult();

      explicit PmCoreIfMessage_TransferAudioResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const AudioDirectionEnumType audioDirection,
            IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_TransferAudioResult(IN const PmCoreIfMessage_TransferAudioResult& other);

      virtual ~PmCoreIfMessage_TransferAudioResult();

      PmCoreIfMessage_TransferAudioResult& operator=(PmCoreIfMessage_TransferAudioResult other);

      bool operator==(const PmCoreIfMessage_TransferAudioResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setAudioDirection(IN const AudioDirectionEnumType audioDirection)
      {
         _audioDirection = audioDirection;
      }

      inline AudioDirectionEnumType getAudioDirection(void) const
      {
         return _audioDirection;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      AudioDirectionEnumType _audioDirection;
   };

   class PmCoreIfMessage_StartStopVoiceRecognitionResult final : public PmCoreIfMessageResult
   {
   public:

      friend void swap(PmCoreIfMessage_StartStopVoiceRecognitionResult& first, PmCoreIfMessage_StartStopVoiceRecognitionResult& second);

      explicit PmCoreIfMessage_StartStopVoiceRecognitionResult();

      explicit PmCoreIfMessage_StartStopVoiceRecognitionResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
            IN const StartStop vrStatus, IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

      PmCoreIfMessage_StartStopVoiceRecognitionResult(IN const PmCoreIfMessage_StartStopVoiceRecognitionResult& other);

      virtual ~PmCoreIfMessage_StartStopVoiceRecognitionResult();

      PmCoreIfMessage_StartStopVoiceRecognitionResult& operator=(PmCoreIfMessage_StartStopVoiceRecognitionResult other);

      bool operator==(const PmCoreIfMessage_StartStopVoiceRecognitionResult& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setVrValue(IN const StartStop vrValue)
      {
         _vrValue = vrValue;
      }

      inline const StartStop getVrValue(void) const
      {
         return _vrValue;
      }

   private:
      BdAddress          _bdAddress;        /**< Instance of BdAddress */
      StartStop          _vrValue;         /**<Value passed in VR set Property */
   };

   class PmCoreIfMessageAmResult : public PmCoreIfMessage
   {
   public:

      friend void swap(PmCoreIfMessageAmResult& first, PmCoreIfMessageAmResult& second);

      explicit PmCoreIfMessageAmResult(IN const PmCoreIfMsgId messageId, IN const pmaudiomanager::AmResult& amResult,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF);

      PmCoreIfMessageAmResult(IN const PmCoreIfMessageAmResult& other);

      virtual ~PmCoreIfMessageAmResult();

      PmCoreIfMessageAmResult& operator=(PmCoreIfMessageAmResult other);

      bool operator==(const PmCoreIfMessageAmResult& rhs) const;


      inline void setAmResult(IN const pmaudiomanager::AmResult& amResult)
      {
         _amResult = amResult;
      }

      inline const pmaudiomanager::AmResult getAmResult(void) const
      {
         return _amResult;
      }

      virtual void traceMessage(void) const override;

   private:
      pmaudiomanager::AmResult _amResult;        /**< Instance of AmResult */
   };
   
   class PmCoreIfMessage_PrepareAudioRouteResponse final : public PmCoreIfMessageAmResult
   {
   public:

      friend void swap(PmCoreIfMessage_PrepareAudioRouteResponse& first,
            PmCoreIfMessage_PrepareAudioRouteResponse& second);

      explicit PmCoreIfMessage_PrepareAudioRouteResponse();

      explicit PmCoreIfMessage_PrepareAudioRouteResponse(IN const pmaudiomanager::AmResult& amResult, 
            IN const BdAddress& bdAddress,
            IN const ControllerOriginEnum controllerOriginEnumType,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF);

      PmCoreIfMessage_PrepareAudioRouteResponse(IN const PmCoreIfMessage_PrepareAudioRouteResponse& other);

      virtual ~PmCoreIfMessage_PrepareAudioRouteResponse();

      PmCoreIfMessage_PrepareAudioRouteResponse& operator=(PmCoreIfMessage_PrepareAudioRouteResponse other);

      bool operator==(const PmCoreIfMessage_PrepareAudioRouteResponse& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setControllerOrigin(IN const ControllerOriginEnum controllerOriginEnumType)
      {
         _controllerOriginEnumType = controllerOriginEnumType;
      }

      inline ControllerOriginEnum getControllerOrigin(void) const
      {
         return _controllerOriginEnumType;
      }

   private:
      BdAddress                  _bdAddress;                 /**< Instance of BdAddress */
      ControllerOriginEnum       _controllerOriginEnumType;  /**< Origin of the controller */
   };

   class PmCoreIfMessage_PlayAudioResponse final : public PmCoreIfMessageAmResult
   {
   public:

      friend void swap(PmCoreIfMessage_PlayAudioResponse& first, PmCoreIfMessage_PlayAudioResponse& second);

      explicit PmCoreIfMessage_PlayAudioResponse();

      explicit PmCoreIfMessage_PlayAudioResponse(IN const pmaudiomanager::AmResult& amResult, 
            IN const BdAddress& bdAddress,
            IN const ControllerOriginEnum controllerOriginEnumType,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF);

      PmCoreIfMessage_PlayAudioResponse(IN const PmCoreIfMessage_PlayAudioResponse& other);

      virtual ~PmCoreIfMessage_PlayAudioResponse();

      PmCoreIfMessage_PlayAudioResponse& operator=(PmCoreIfMessage_PlayAudioResponse other);

      bool operator==(const PmCoreIfMessage_PlayAudioResponse& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setControllerOrigin(IN const ControllerOriginEnum controllerOriginEnumType)
      {
         _controllerOriginEnumType = controllerOriginEnumType;
      }

      inline ControllerOriginEnum getControllerOrigin(void) const
      {
         return _controllerOriginEnumType;
      }

   private:
      BdAddress                  _bdAddress;                 /**< Instance of BdAddress */
      ControllerOriginEnum       _controllerOriginEnumType;  /**< Origin of the controller */
   };

   class PmCoreIfMessage_StopAudioResponse final : public PmCoreIfMessageAmResult
   {
   public:

      friend void swap(PmCoreIfMessage_StopAudioResponse& first, PmCoreIfMessage_StopAudioResponse& second);

      explicit PmCoreIfMessage_StopAudioResponse();

      explicit PmCoreIfMessage_StopAudioResponse(IN const pmaudiomanager::AmResult& amResult, 
            IN const BdAddress& bdAddress,
            IN const ControllerOriginEnum controllerOriginEnumType,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF);

      PmCoreIfMessage_StopAudioResponse(IN const PmCoreIfMessage_StopAudioResponse& other);

      virtual ~PmCoreIfMessage_StopAudioResponse();

      PmCoreIfMessage_StopAudioResponse& operator=(PmCoreIfMessage_StopAudioResponse other);

      bool operator==(const PmCoreIfMessage_StopAudioResponse& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setControllerOrigin(IN const ControllerOriginEnum controllerOriginEnumType)
      {
         _controllerOriginEnumType = controllerOriginEnumType;
      }

      inline ControllerOriginEnum getControllerOrigin(void) const
      {
         return _controllerOriginEnumType;
      }

   private:
      BdAddress                  _bdAddress;                 /**< Instance of BdAddress */
      ControllerOriginEnum       _controllerOriginEnumType;  /**< Origin of the controller */
   };

   class PmCoreIfMessage_SetMicMuteStateResponse final : public PmCoreIfMessageAmResult
   {
   public:

      friend void swap(PmCoreIfMessage_SetMicMuteStateResponse& first, PmCoreIfMessage_SetMicMuteStateResponse& second);

      explicit PmCoreIfMessage_SetMicMuteStateResponse();

      explicit PmCoreIfMessage_SetMicMuteStateResponse(IN const pmaudiomanager::AmResult& amResult, 
            IN const BdAddress& bdAddress,
            IN const ControllerOriginEnum controllerOriginEnumType,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF);

      PmCoreIfMessage_SetMicMuteStateResponse(IN const PmCoreIfMessage_SetMicMuteStateResponse& other);

      virtual ~PmCoreIfMessage_SetMicMuteStateResponse();

      PmCoreIfMessage_SetMicMuteStateResponse& operator=(PmCoreIfMessage_SetMicMuteStateResponse other);

      bool operator==(const PmCoreIfMessage_SetMicMuteStateResponse& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setControllerOrigin(IN const ControllerOriginEnum controllerOriginEnumType)
      {
         _controllerOriginEnumType = controllerOriginEnumType;
      }

      inline ControllerOriginEnum getControllerOrigin(void) const
      {
         return _controllerOriginEnumType;
      }

   private:
      BdAddress                  _bdAddress;                 /**< Instance of BdAddress */
      ControllerOriginEnum       _controllerOriginEnumType;  /**< Origin of the controller */
   };

   class PmCoreIfMessage_PauseAudioResponse final : public PmCoreIfMessageAmResult
   {
   public:

      friend void swap(PmCoreIfMessage_PauseAudioResponse& first, PmCoreIfMessage_PauseAudioResponse& second);

      explicit PmCoreIfMessage_PauseAudioResponse();

      explicit PmCoreIfMessage_PauseAudioResponse(IN const pmaudiomanager::AmResult& amResult,
            IN const BdAddress& bdAddress,
            IN const ControllerOriginEnum controllerOriginEnumType,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF);

      PmCoreIfMessage_PauseAudioResponse(IN const PmCoreIfMessage_PauseAudioResponse& other);

      virtual ~PmCoreIfMessage_PauseAudioResponse();

      PmCoreIfMessage_PauseAudioResponse& operator=(PmCoreIfMessage_PauseAudioResponse other);

      bool operator==(const PmCoreIfMessage_PauseAudioResponse& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
      {
         _bdAddress = bdAddress;
      }

      inline const BdAddress& getBdAddress(void) const
      {
         return _bdAddress;
      }

      inline void setControllerOrigin(IN const ControllerOriginEnum controllerOriginEnumType)
      {
         _controllerOriginEnumType = controllerOriginEnumType;
      }

      inline ControllerOriginEnum getControllerOrigin(void) const
      {
         return _controllerOriginEnumType;
      }

   private:
      BdAddress                  _bdAddress;                 /**< Instance of BdAddress */
      ControllerOriginEnum       _controllerOriginEnumType;  /**< Origin of the controller */
   };

   class PmCoreIfMessage_GetAudioSinkVolumeResponse final : public PmCoreIfMessageAmResult
   {
   public:

      friend void swap(PmCoreIfMessage_GetAudioSinkVolumeResponse& first, PmCoreIfMessage_GetAudioSinkVolumeResponse& second);

      explicit PmCoreIfMessage_GetAudioSinkVolumeResponse();

      explicit PmCoreIfMessage_GetAudioSinkVolumeResponse(IN const pmaudiomanager::AmResult& amResult,
            IN const BdAddress& bdAddress,
            IN const ControllerOriginEnum controllerOriginEnumType,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF);

      PmCoreIfMessage_GetAudioSinkVolumeResponse(IN const PmCoreIfMessage_GetAudioSinkVolumeResponse& other);

      virtual ~PmCoreIfMessage_GetAudioSinkVolumeResponse();

      PmCoreIfMessage_GetAudioSinkVolumeResponse& operator=(PmCoreIfMessage_GetAudioSinkVolumeResponse other);

      bool operator==(const PmCoreIfMessage_GetAudioSinkVolumeResponse& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
       {
          _bdAddress = bdAddress;
       }

       inline const BdAddress& getBdAddress(void) const
       {
          return _bdAddress;
       }

       inline void setControllerOrigin(IN const ControllerOriginEnum controllerOriginEnumType)
       {
          _controllerOriginEnumType = controllerOriginEnumType;
       }

       inline ControllerOriginEnum getControllerOrigin(void) const
       {
          return _controllerOriginEnumType;
       }

   private:
      BdAddress                  _bdAddress;                 /**< Instance of BdAddress */
      ControllerOriginEnum       _controllerOriginEnumType;  /**< Origin of the controller */
   };

   class PmCoreIfMessage_SetAudioSinkVolumeResponse final : public PmCoreIfMessageAmResult
   {
   public:

      friend void swap(PmCoreIfMessage_SetAudioSinkVolumeResponse& first, PmCoreIfMessage_SetAudioSinkVolumeResponse& second);

      explicit PmCoreIfMessage_SetAudioSinkVolumeResponse();

      explicit PmCoreIfMessage_SetAudioSinkVolumeResponse(IN const pmaudiomanager::AmResult& amResult,
            IN const BdAddress& bdAddress,
            IN const ControllerOriginEnum controllerOriginEnumType,
            IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF);

      PmCoreIfMessage_SetAudioSinkVolumeResponse(IN const PmCoreIfMessage_SetAudioSinkVolumeResponse& other);

      virtual ~PmCoreIfMessage_SetAudioSinkVolumeResponse();

      PmCoreIfMessage_SetAudioSinkVolumeResponse& operator=(PmCoreIfMessage_SetAudioSinkVolumeResponse other);

      bool operator==(const PmCoreIfMessage_SetAudioSinkVolumeResponse& rhs) const;

      virtual void traceMessage(void) const override;

      inline void setBdAddress(IN const BdAddress& bdAddress)
       {
          _bdAddress = bdAddress;
       }

       inline const BdAddress& getBdAddress(void) const
       {
          return _bdAddress;
       }

       inline void setControllerOrigin(IN const ControllerOriginEnum controllerOriginEnumType)
       {
          _controllerOriginEnumType = controllerOriginEnumType;
       }

       inline ControllerOriginEnum getControllerOrigin(void) const
       {
          return _controllerOriginEnumType;
       }

   private:
      BdAddress                           _bdAddress;                 /**< Instance of BdAddress */
      ControllerOriginEnum                _controllerOriginEnumType;  /**< Origin of the controller */
   };

} // namespace pmcore

#endif // PmCoreIfMessageResult_h
