/**
 * @file PmCoreIfMessageCreator.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file creates instance of PmCoreIfMessages
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef PmCoreIfMessageCreator_h
#define PmCoreIfMessageCreator_h

#include "PmCoreIfMessageRequest.h"
#include "PmCoreIfMessageResult.h"

namespace pmcore
{
   //Request messages
   inline std::shared_ptr<PmCoreIfMessage_SetSystemState> getNewPmCoreIfMessage_SetSystemState(
         IN const SystemState systemState, IN const ActType act = PM_DEFAULT_ACT,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SetSystemState>(systemState, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SetVehicleConfiguration> getNewPmCoreIfMessage_SetVehicleConfiguration(
         IN const VehicleConfiguration& vehicleConfig, IN const ActType act = PM_DEFAULT_ACT,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SetVehicleConfiguration>(vehicleConfig, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_OnDevicePaired> getNewPmCoreIfMessage_OnDevicePaired(
         IN const BasicDeviceDetails& pairedDeviceInfo, IN const ActType act = PM_DEFAULT_ACT,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_OnDevicePaired>(pairedDeviceInfo, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_OnDeviceConnected> getNewPmCoreIfMessage_OnDeviceConnected(
         IN const BasicDeviceDetails& connectedDeviceInfo, IN const ActType act = PM_DEFAULT_ACT,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_OnDeviceConnected>(connectedDeviceInfo, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_OnDeviceDisconnected> getNewPmCoreIfMessage_OnDeviceDisconnected(
         IN const BdAddress& bdAddress, IN const ActType act = PM_DEFAULT_ACT,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_OnDeviceDisconnected>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_OnDeviceDeleted> getNewPmCoreIfMessage_OnDeviceDeleted(
         IN const BdAddress& bdAddress, IN const ActType act = PM_DEFAULT_ACT,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_OnDeviceDeleted>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetSystemWideRingtoneListRequest> getNewPmCoreIfMessage_GetSystemWideRingtoneListRequest(
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetSystemWideRingtoneListRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetDeviceRingtoneListRequest> getNewPmCoreIfMessage_GetDeviceRingtoneListRequest(
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetDeviceRingtoneListRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SetRingtoneRequest> getNewPmCoreIfMessage_SetRingtoneRequest(
         IN const BdAddress& bdAddress, IN const RingtoneId& ringtoneId, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SetRingtoneRequest>(bdAddress, ringtoneId, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_PlayRingtoneRequest> getNewPmCoreIfMessage_PlayRingtoneRequest(
         IN const BdAddress& bdAddress, IN const RingtoneId& ringtoneId, IN const PlayCount playCount,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_PlayRingtoneRequest>(bdAddress, ringtoneId, playCount, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_StopRingtoneRequest> getNewPmCoreIfMessage_StopRingtoneRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_StopRingtoneRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetSuppressRingtoneOnOffListRequest> getNewPmCoreIfMessage_GetSuppressRingtoneOnOffListRequest(
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetSuppressRingtoneOnOffListRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SuppressRingtoneOnOffRequest> getNewPmCoreIfMessage_SuppressRingtoneOnOffRequest(
         IN const BdAddress& bdAddress, IN const SuppressRingtoneState suppressRingtoneState,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SuppressRingtoneOnOffRequest>(bdAddress, suppressRingtoneState, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetAutoWaitingModeOnOffListRequest> getNewPmCoreIfMessage_GetAutoWaitingModeOnOffListRequest(
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetAutoWaitingModeOnOffListRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_AutoWaitingModeOnOffRequest> getNewPmCoreIfMessage_AutoWaitingModeOnOffRequest(
         IN const BdAddress& bdAddress,IN const AutoWaitingModeState autoWaitingModeState,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_AutoWaitingModeOnOffRequest>(bdAddress, autoWaitingModeState, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SetWaitingModeFilePathRequest> getNewPmCoreIfMessage_SetWaitingModeFilePathRequest(
         IN const WaitingModeFilePath& waitingModeFilePath, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SetWaitingModeFilePathRequest>(waitingModeFilePath, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetWaitingModeFilePathRequest> getNewPmCoreIfMessage_GetWaitingModeFilePathRequest(
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetWaitingModeFilePathRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetPhoneCallAudioActiveRequest> getNewPmCoreIfMessage_GetPhoneCallAudioActiveRequest(
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetPhoneCallAudioActiveRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetActivePassiveDeviceListRequest> getNewPmCoreIfMessage_GetActivePassiveDeviceListRequest(
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetActivePassiveDeviceListRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SetActivePhoneRequest> getNewPmCoreIfMessage_SetActivePhoneRequest(
         IN const BdAddressList& deviceAddressList, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SetActivePhoneRequest>(deviceAddressList, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_RestoreDefaultSettingRequest> getNewPmCoreIfMessage_RestoreDefaultSettingRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_RestoreDefaultSettingRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetSupportedFeaturesRequest> getNewPmCoreIfMessage_GetSupportedFeaturesRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetSupportedFeaturesRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetNetworkStatusRequest> getNewPmCoreIfMessage_GetNetworkStatusRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetNetworkStatusRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetSignalStrengthRequest> getNewPmCoreIfMessage_GetSignalStrengthRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetSignalStrengthRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetBatteryChargeLevelRequest> getNewPmCoreIfMessage_GetBatteryChargeLevelRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetBatteryChargeLevelRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetNetworkOperatorRequest> getNewPmCoreIfMessage_GetNetworkOperatorRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetNetworkOperatorRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_VoiceMailListRequest> getNewPmCoreIfMessage_VoiceMailListRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_VoiceMailListRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetCallStatusListRequest> getNewPmCoreIfMessage_GetCallStatusListRequest(
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetCallStatusListRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetMicrophoneMuteStateRequest> getNewPmCoreIfMessage_GetMicrophoneMuteStateRequest(
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetMicrophoneMuteStateRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SetMicrophoneMuteStateRequest> getNewPmCoreIfMessage_SetMicrophoneMuteStateRequest(
         IN const MuteState microphoneMuteState, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SetMicrophoneMuteStateRequest>(microphoneMuteState, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_MergeCallsRequest> getNewPmCoreIfMessage_MergeCallsRequest(
         IN const BdAddress& bdAddress, IN const CallInstanceList& mergeCallList, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_MergeCallsRequest>(bdAddress, mergeCallList, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SplitCallsRequest> getNewPmCoreIfMessage_SplitCallsRequest(
         IN const BdAddress& bdAddress, IN const CallInstanceList& splitCallList, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SplitCallsRequest>(bdAddress, splitCallList, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_HangupCallsRequest> getNewPmCoreIfMessage_HangupCallsRequest(
         IN const BdAddress& bdAddress, IN const CallInstanceList& hangupCallList, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_HangupCallsRequest>(bdAddress, hangupCallList, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_RedialRequest> getNewPmCoreIfMessage_RedialRequest(
         IN const BdAddress& bdAddress, IN const HideCallerId hideCallerId, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_RedialRequest>(bdAddress, hideCallerId, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetSCOConnectionRequest> getNewPmCoreIfMessage_GetSCOConnectionRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetSCOConnectionRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetRingtoneMuteStateRequest> getNewPmCoreIfMessage_GetRingtoneMuteStateRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetRingtoneMuteStateRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SetRingtoneMuteStateRequest> getNewPmCoreIfMessage_SetRingtoneMuteStateRequest(
         IN const BdAddress& bdAddress, IN const MuteState ringtoneMuteState, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SetRingtoneMuteStateRequest>(bdAddress, ringtoneMuteState, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetWaitingModeStateRequest> getNewPmCoreIfMessage_GetWaitingModeStateRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetWaitingModeStateRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetRingtonePlaybackStatusRequest> getNewPmCoreIfMessage_GetRingtonePlaybackStatusRequest(
         IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetRingtonePlaybackStatusRequest>(act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_StartStopWaitingModeRequest> getNewPmCoreIfMessage_StartStopWaitingModeRequest(
         IN const BdAddress& bdAddress, IN const StartStop startStopWaitingMode, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_StartStopWaitingModeRequest>(bdAddress, startStopWaitingMode, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_DialRequest> getNewPmCoreIfMessage_DialRequest(IN const BdAddress& bdAddress,
         IN const TelephoneNumber& telephoneNumber, IN const HideCallerId hideCallerId,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_DialRequest>(bdAddress, telephoneNumber, hideCallerId, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_AcceptCallRequest> getNewPmCoreIfMessage_AcceptCallRequest(
         IN const BdAddress& bdAddress, IN const CallInstance& callInstance, IN const AcceptOperation operation,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_AcceptCallRequest>(bdAddress, callInstance, operation, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SwapCallRequest> getNewPmCoreIfMessage_SwapCallRequest(
         IN const BdAddress& bdAddress, IN const SwapOperation operation, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SwapCallRequest>(bdAddress, operation, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SpeedDialRequest> getNewPmCoreIfMessage_SpeedDialRequest(
         IN const BdAddress& bdAddress, IN const MemDialIndex memDialIndex, IN const HideCallerId hideCallerId,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SpeedDialRequest>(bdAddress, memDialIndex, hideCallerId, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SendDTMFRequest> getNewPmCoreIfMessage_SendDTMFRequest(
         IN const BdAddress& bdAddress, IN const DTMFTones& tones, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_SendDTMFRequest>(bdAddress, tones, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_TransferAudioRequest> getNewPmCoreIfMessage_TransferAudioRequest(
         IN const BdAddress& bdAddress, IN const AudioDirection audioDirection, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_TransferAudioRequest>(bdAddress, audioDirection, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetVoiceRecognitionStatusRequest> getNewPmCoreIfMessage_GetVoiceRecognitionStatusRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetVoiceRecognitionStatusRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetExtVoiceRecognitionStatusRequest> getNewPmCoreIfMessage_GetExtVoiceRecognitionStatusRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetExtVoiceRecognitionStatusRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_StartStopVoiceRecognitionRequest> getNewPmCoreIfMessage_StartStopVoiceRecognitionRequest(
         IN const BdAddress& bdAddress, IN const StartStop startStopVR, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_StartStopVoiceRecognitionRequest>(bdAddress, startStopVR, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_StartStopExternalVoiceRecognitionRequest> getNewPmCoreIfMessage_StartStopExternalVoiceRecognitionRequest(
         IN const BdAddress& bdAddress, IN const StartStop startStopExtVR, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_StartStopExternalVoiceRecognitionRequest>(bdAddress, startStopExtVR, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetEnhancedVoiceRecognitionFeatureRequest>
   getNewPmCoreIfMessage_GetEnhancedVoiceRecognitionFeatureRequest( IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_GetEnhancedVoiceRecognitionFeatureRequest>(bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_stopExtendedVRRequest> getNewPmCoreIfMessage_stopExtendedVRRequest(
         IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      return std::make_shared<PmCoreIfMessage_stopExtendedVRRequest>(bdAddress, act, origin);
   }

// ********************************************************************************************************************************

   //Result messages
   inline std::shared_ptr<PmCoreIfMessage_RequestPhoneNumberResult> getNewPmCoreIfMessage_RequestPhoneNumberResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const TelephoneNumber& telephoneNumber,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_RequestPhoneNumberResult>(
            btsResult, bdAddress, telephoneNumber, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetSubscriberResult> getNewPmCoreIfMessage_GetSubscriberResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const NumberType numberType,
         IN const TelephoneNumber& telephoneNumber, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_GetSubscriberResult>(
            btsResult, bdAddress, numberType, telephoneNumber, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SendCustomATCommandResult> getNewPmCoreIfMessage_SendCustomATCommandResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_SendCustomATCommandResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_HFUpdateIndicatorsValueResult>
   getNewPmCoreIfMessage_HFUpdateIndicatorsValueResult(IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_HFUpdateIndicatorsValueResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetModemsResult> getNewPmCoreIfMessage_GetModemsResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_GetModemsResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_AcceptSCOConnectResult> getNewPmCoreIfMessage_AcceptSCOConnectResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_AcceptSCOConnectResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SiriEnableResult> getNewPmCoreIfMessage_SiriEnableResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_SiriEnableResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SiriSetNRResult> getNewPmCoreIfMessage_SiriSetNRResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_SiriSetNRResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetCallsResult> getNewPmCoreIfMessage_GetCallsResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress,
         IN const BTSVoiceCallInfoList& btsVoiceCallInfoList, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_GetCallsResult>(btsResult, bdAddress, btsVoiceCallInfoList, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_DialResult> getNewPmCoreIfMessage_DialResult(IN const BTSResult& btsResult,
         IN const BdAddress& bdAddress, IN const CallInstance callInstance, IN const TelephoneNumber telephoneNumber,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_DialResult>(btsResult, bdAddress, callInstance, telephoneNumber, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SpeedDialResult> getNewPmCoreIfMessage_SpeedDialResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const CallInstance callInstance,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_SpeedDialResult>(btsResult, bdAddress, callInstance, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_RedialResult> getNewPmCoreIfMessage_RedialResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const CallInstance callInstance,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_RedialResult>(btsResult, bdAddress, callInstance, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SwapCallResult> getNewPmCoreIfMessage_SwapCallResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_SwapCallResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_ReleaseAndAcceptResult> getNewPmCoreIfMessage_ReleaseAndAcceptResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_ReleaseAndAcceptResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_ReleaseAndSwapResult> getNewPmCoreIfMessage_ReleaseAndSwapResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_ReleaseAndSwapResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_HoldAndAcceptResult> getNewPmCoreIfMessage_HoldAndAcceptResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_HoldAndAcceptResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_HangupAllResult> getNewPmCoreIfMessage_HangupAllResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_HangupAllResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SplitCallsResult> getNewPmCoreIfMessage_SplitCallsResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const CallInstanceList& callInstanceList,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_SplitCallsResult>(btsResult, bdAddress, callInstanceList, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_MergeCallsResult> getNewPmCoreIfMessage_MergeCallsResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const CallInstanceList& callInstanceList,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_MergeCallsResult>(btsResult, bdAddress, callInstanceList, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_HangupMultipartyResult> getNewPmCoreIfMessage_HangupMultipartyResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_HangupMultipartyResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SendDTMFResult> getNewPmCoreIfMessage_SendDTMFResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_SendDTMFResult>(btsResult, bdAddress, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_HangupCallResult> getNewPmCoreIfMessage_HangupCallResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const CallInstance callInstance,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_HangupCallResult>(btsResult, bdAddress, callInstance, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_AcceptCallResult> getNewPmCoreIfMessage_AcceptCallResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const CallInstance callInstance,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_AcceptCallResult>(btsResult, bdAddress, callInstance, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_HoldIncomingCallResult> getNewPmCoreIfMessage_HoldIncomingCallResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const CallInstance callInstance,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_HoldIncomingCallResult>(btsResult, bdAddress, callInstance, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_TransferAudioResult> getNewPmCoreIfMessage_TransferAudioResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const AudioDirectionEnumType audioDirection,
         IN const ActType act, IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_TransferAudioResult>(btsResult, bdAddress, audioDirection, act, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_StartStopVoiceRecognitionResult> getNewPmCoreIfMessage_StartStopVoiceRecognitionResult(
         IN const BTSResult& btsResult, IN const BdAddress& bdAddress, IN const StartStop vrStatus, IN const ActType act,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_BT_STACK_IF)
   {
      return std::make_shared<PmCoreIfMessage_StartStopVoiceRecognitionResult>(btsResult, bdAddress, vrStatus, act, origin);
   }

   // ********************************************************************************************************************************
   // Result messages from PM Audiomanager
   // ********************************************************************************************************************************
   inline std::shared_ptr<PmCoreIfMessage_PrepareAudioRouteResponse> getNewPmCoreIfMessage_PrepareAudioRouteResponse(
         IN const pmaudiomanager::AmResult& amResult, IN const BdAddress& bdAddress,
         IN const ControllerOriginEnum controllerOriginEnumType,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF)
   {
      return std::make_shared<PmCoreIfMessage_PrepareAudioRouteResponse>(
            amResult, bdAddress, controllerOriginEnumType, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_PlayAudioResponse> getNewPmCoreIfMessage_PlayAudioResponse(
         IN const pmaudiomanager::AmResult& amResult, IN const BdAddress& bdAddress,
         IN const ControllerOriginEnum controllerOriginEnumType,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF)
   {
      return std::make_shared<PmCoreIfMessage_PlayAudioResponse>(amResult, bdAddress,
            controllerOriginEnumType, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_StopAudioResponse> getNewPmCoreIfMessage_StopAudioResponse(
         IN const pmaudiomanager::AmResult& amResult, IN const BdAddress& bdAddress,
         IN const ControllerOriginEnum controllerOriginEnumType,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF)
   {
      return std::make_shared<PmCoreIfMessage_StopAudioResponse>(amResult, bdAddress,
            controllerOriginEnumType, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SetMicMuteStateResponse> getNewPmCoreIfMessage_SetMicMuteStateResponse(
         IN const pmaudiomanager::AmResult& amResult, IN const BdAddress& bdAddress,
         IN const ControllerOriginEnum controllerOriginEnumType,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF)
   {
      return std::make_shared<PmCoreIfMessage_SetMicMuteStateResponse>(amResult, bdAddress,
            controllerOriginEnumType, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_PauseAudioResponse> getNewPmCoreIfMessage_PauseAudioResponse(
         IN const pmaudiomanager::AmResult& amResult, IN const BdAddress& bdAddress,
         IN const ControllerOriginEnum controllerOriginEnumType,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF)
   {
      return std::make_shared<PmCoreIfMessage_PauseAudioResponse>(amResult, bdAddress,
            controllerOriginEnumType, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_GetAudioSinkVolumeResponse> getNewPmCoreIfMessage_GetAudioSinkVolumeResponse(
         IN const pmaudiomanager::AmResult& amResult, IN const BdAddress& bdAddress,
         IN const ControllerOriginEnum controllerOriginEnumType,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF)
   {
      return std::make_shared<PmCoreIfMessage_GetAudioSinkVolumeResponse>(amResult, bdAddress,
            controllerOriginEnumType, origin);
   }

   inline std::shared_ptr<PmCoreIfMessage_SetAudioSinkVolumeResponse> getNewPmCoreIfMessage_SetAudioSinkVolumeResponse(
         IN const pmaudiomanager::AmResult& amResult, IN const BdAddress& bdAddress,
         IN const ControllerOriginEnum controllerOriginEnumType,
         IN const PmCoreIfMsgOrigin origin = PM_CORE_IF_MSG_ORIGIN_PM_AUDIOMANAGER_IF)
   {
      return std::make_shared<PmCoreIfMessage_SetAudioSinkVolumeResponse>(amResult, bdAddress,
            controllerOriginEnumType, origin);
   }
}

#endif // PmCoreIfMessageCreator_h
