/**
 * @file PmCoreIfMessage.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the PmCoreIfMessage class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef PmCoreIfMessage_h
#define PmCoreIfMessage_h

#include "PmCoreIfTypes.h"

namespace pmcore
{

   class PmCoreIfMessage
   {
   public:

      /**
       * Parameterized Constructor of PmCoreIfMessage class
       *
       * @param[in] messageId - Message ID of the PmCoreIfMessage
       * @param[in] origin - Origin of the PmCoreIfMessage
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      explicit PmCoreIfMessage(const PmCoreIfMsgId messageId, const ActType act, const PmCoreIfMsgOrigin origin);

      /**
       * Copy Constructor of PmCoreIfMessage class
       *
       * @param[in] other - Instance of PmCoreIfMessage
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      PmCoreIfMessage(const PmCoreIfMessage& other);

      /**
       * Destructor of PmCoreIfMessage class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      virtual ~PmCoreIfMessage();

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      PmCoreIfMessage& operator=(PmCoreIfMessage other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const PmCoreIfMessage& rhs) const;

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(PmCoreIfMessage& first, PmCoreIfMessage& second);

      /**
       * This method is used to get the Message ID of the message
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return PmCoreIfMsgId - message ID
       */
      inline PmCoreIfMsgId getMessageId(void) const
      {
         return _messageId;
      }

      /**
       * This method is used to set the Origin of the message
       *
       * @param[in] origin - Origin of the message
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      inline void setOrigin(IN const PmCoreIfMsgOrigin origin)
      {
         _origin = origin;
      }

      /**
       * This method is used to get the Origin of the message
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return PmCoreIfMsgOrigin - origin of the message
       */
      inline PmCoreIfMsgOrigin getOrigin(void) const
      {
         return _origin;
      }

      /**
       * This method is used to set the Act of the message
       *
       * @param[in] ActType - act of the message
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      inline void setAct(IN const ActType act)
      {
         _act = act;
      }

      /**
       * This method is used to get the Act of the message
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return ActType - act of the message
       */
      inline ActType getAct(void) const
      {
         return _act;
      }

      /**
       * This method is used to trace Message
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return void
       */
      virtual void traceMessage(void) const;

   protected:
      PmCoreIfMsgId            _messageId; /**< Message Id of the message */
      ActType                  _act;       /**< Asynchronous Completion Token*/
      PmCoreIfMsgOrigin        _origin;    /**< Origin of the message */
   };
}

#endif // PmCoreIfMessage_h
