/**
 * @file PmCoreCallbackIfWrapper.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the PmCoreCallbackIfWrapper class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */


#include "PmCoreCallbackIfWrapper.h"
#include "IPmCoreCallbackIf.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PmCoreCallbackIfWrapper.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   PmCoreCallbackIfWrapper::PmCoreCallbackIfWrapper(IPmCoreCallbackIf* pmCoreCallbackIf) :
         _pmCoreCallbackIf(pmCoreCallbackIf)
   {
   }

   PmCoreCallbackIfWrapper::~PmCoreCallbackIfWrapper()
   {
      _pmCoreCallbackIf = nullptr;
   }

   void PmCoreCallbackIfWrapper::doGetSystemWideRingtonesListResponse(IN const PmResult& pmResult,
         IN const SystemWideRingtonesList& systemWideRingtonesList, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetSystemWideRingtonesListResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getSystemWideRingtonesListResponse(pmResult, systemWideRingtonesList, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnSystemWideRingtonesListChanged(
         IN const SystemWideRingtonesList& systemWideRingtonesList) const
   {
      ETG_TRACE_USR1(("OnSystemWideRingtonesListChanged"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onSystemWideRingtonesListChanged(systemWideRingtonesList);
      }
   }

   void PmCoreCallbackIfWrapper::doGetDeviceRingtoneListResponse(IN const PmResult& pmResult,
         IN const DeviceRingtoneList& deviceRingtoneList, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetDeviceRingtoneListResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getDeviceRingtoneListResponse(pmResult, deviceRingtoneList, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnDeviceRingtoneListChanged(IN const DeviceRingtoneList& deviceRingtoneList) const
   {
      ETG_TRACE_USR1(("OnDeviceRingtoneListChanged"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onDeviceRingtoneListChanged(deviceRingtoneList);
      }
   }

   void PmCoreCallbackIfWrapper::doSetRingtoneResponse(IN const PmResult& pmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("SetRingtoneResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->setRingtoneResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doPlayRingtoneResponse(IN const PmResult& pmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("PlayRingtoneResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->playRingtoneResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doStopRingtoneResponse(IN const PmResult& pmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("StopRingtoneResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->stopRingtoneResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doGetSuppressRingtoneOnOffListResponse(IN const PmResult& pmResult,
         IN const SuppressRingtoneOnOffList& suppressRingtoneOnOffList, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetSuppressRingtoneOnOffListResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getSuppressRingtoneOnOffListResponse(pmResult, suppressRingtoneOnOffList, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnSuppressRingtoneOnOffListChanged(
         IN const SuppressRingtoneOnOffList& suppressRingtoneOnOffList) const
   {
      ETG_TRACE_USR1(("OnSuppressRingtoneOnOffListChanged"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onSuppressRingtoneOnOffListChanged(suppressRingtoneOnOffList);
      }
   }

   void PmCoreCallbackIfWrapper::doSuppressRingtoneOnOffResponse(IN const PmResult& pmResult,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("SuppressRingtoneOnOffResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->suppressRingtoneOnOffResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doGetAutoWaitingModeOnOffListResponse(IN const PmResult& pmResult,
         IN const AutoWaitingModeOnOffList& autoWaitingModeOnOffList, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetAutoWaitingModeOnOffListResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getAutoWaitingModeOnOffListResponse(pmResult, autoWaitingModeOnOffList, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnAutoWaitingModeOnOffListChanged(
         IN AutoWaitingModeOnOffList& autoWaitingModeOnOffList) const
   {
      ETG_TRACE_USR1(("OnAutoWaitingModeOnOffListChanged"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onAutoWaitingModeOnOffListChanged(autoWaitingModeOnOffList);
      }
   }

   void PmCoreCallbackIfWrapper::doAutoWaitingModeOnOffResponse(IN const PmResult& pmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("AutoWaitingModeOnOffResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->autoWaitingModeOnOffResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doSetWaitingModeFilePathResponse(IN const PmResult& pmResult,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("SetWaitingModeFilePathResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->setWaitingModeFilePathResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doGetWaitingModeFilePathResponse(IN const PmResult& pmResult,
         IN const WaitingModeFilePath& waitingModeFilePath, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetWaitingModeFilePathResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getWaitingModeFilePathResponse(pmResult, waitingModeFilePath, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnWaitingModeFilePathChanged(IN const WaitingModeFilePath& waitingModeFilePath) const
   {
      ETG_TRACE_USR1(("OnWaitingModeFilePathChanged"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onWaitingModeFilePathChanged(waitingModeFilePath);
      }
   }

   void PmCoreCallbackIfWrapper::doGetPhoneCallAudioActiveResponse(IN const PmResult& pmResult,
         IN const PhoneCallAudioActive& phoneCallAudioActive, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetPhoneCallAudioActiveResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getPhoneCallAudioActiveResponse(pmResult, phoneCallAudioActive, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnPhoneCallAudioActiveChanged(
         IN const PhoneCallAudioActive& phoneCallAudioActive) const
   {
      ETG_TRACE_USR1(("OnPhoneCallAudioActiveChanged"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onPhoneCallAudioActiveChanged(phoneCallAudioActive);
      }
   }

   void PmCoreCallbackIfWrapper::doGetActivePassiveDeviceListResponse(IN const PmResult& pmResult,
         IN const ActivePassiveDeviceList& activePassiveDeviceList, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetActivePassiveDeviceListResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getActivePassiveDeviceListResponse(pmResult, activePassiveDeviceList, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnActivePassiveDeviceListChanged(
         IN const ActivePassiveDeviceList& activePassiveDeviceList) const
   {
      ETG_TRACE_USR1(("OnActivePassiveDeviceListChanged"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onActivePassiveDeviceListChanged(activePassiveDeviceList);
      }
   }

   void PmCoreCallbackIfWrapper::doSetActivePhoneResponse(IN const PmResult& pmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("SetActivePhoneResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->setActivePhoneResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doRestoreDefaultSettingResponse(IN const PmResult& pmResult,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("RestoreDefaultSettingResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->restoreDefaultSettingResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnNotificationEvent(IN const NotificationEvent& notificationEvent) const
   {
      ETG_TRACE_USR1(("OnNotificationEvent"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onNotificationEvent(notificationEvent);
      }
   }

   void PmCoreCallbackIfWrapper::doGetSupportedFeaturesResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const SupportedFeatures& supportedFeatures, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetSupportedFeaturesResponse: deviceAddress = %50s, act = %u", deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getSupportedFeaturesResponse(pmResult, deviceAddress, supportedFeatures, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnSupportedFeaturesChanged(IN const BdAddress& deviceAddress,
            IN const SupportedFeatures& supportedFeatures) const
   {
      ETG_TRACE_USR1(("OnSupportedFeaturesChanged: deviceAddress = %50s", deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onSupportedFeaturesChanged(deviceAddress, supportedFeatures);
      }
   }

   void PmCoreCallbackIfWrapper::doGetNetworkStatusResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const NetworkStatus& networkStatus,IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetNetworkStatusResponse: deviceAddress = %50s, act = %u", deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getNetworkStatusResponse(pmResult, deviceAddress, networkStatus, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnNetworkStatusChanged(IN const BdAddress& deviceAddress,
         IN const NetworkStatus& networkStatus) const
   {
      ETG_TRACE_USR1(("OnNetworkStatusChanged: deviceAddress = %50s", deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onNetworkStatusChanged(deviceAddress, networkStatus);
      }
   }

   void PmCoreCallbackIfWrapper::doGetSignalStrengthResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const SignalStrength& signalStrength, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetSignalStrengthResponse: deviceAddress = %50s, act = %u", deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getSignalStrengthResponse(pmResult, deviceAddress, signalStrength, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnSignalStrengthChanged(IN const BdAddress& deviceAddress,
            IN const SignalStrength& signalStrength) const
   {
      ETG_TRACE_USR1(("OnSignalStrengthChanged: deviceAddress = %50s",deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onSignalStrengthChanged(deviceAddress, signalStrength);
      }
   }

   void PmCoreCallbackIfWrapper::doGetBatteryChargeLevelResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const BatteryChargeLevel& batteryChargeLevel, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetBatteryChargeLevelResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getBatteryChargeLevelResponse(pmResult, deviceAddress, batteryChargeLevel, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnBatteryChargeLevelChanged(IN const BdAddress& deviceAddress,
            IN const BatteryChargeLevel& batteryChargeLevel) const
   {
      ETG_TRACE_USR1(("OnBatteryChargeLevelChanged: deviceAddress = %50s",deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onBatteryChargeLevelChanged(deviceAddress, batteryChargeLevel);
      }
   }

   void PmCoreCallbackIfWrapper::doGetNetworkOperatorResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const NetworkOperator& networkOperator, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetNetworkOperatorResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getNetworkOperatorResponse(pmResult, deviceAddress, networkOperator, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnNetworkOperatorChanged(IN const BdAddress& deviceAddress,
            IN const NetworkOperator& networkOperator) const
   {
      ETG_TRACE_USR1(("OnNetworkOperatorChanged: deviceAddress = %50s",deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onNetworkOperatorChanged(deviceAddress, networkOperator);
      }
   }

   void PmCoreCallbackIfWrapper::doVoiceMailListResponse(IN const PmResult& pmResult, IN const BdAddress& deviceAddress,
            IN const VoiceMailList& voiceMailList, IN const ActType act) const
   {
      ETG_TRACE_USR1(("VoiceMailListResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->voiceMailListResponse(pmResult, deviceAddress, voiceMailList, act);
      }
   }

   void PmCoreCallbackIfWrapper::doGetCallStatusListResponse(IN const PmResult& pmResult,
         IN const CallStatusList& callStatusList, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetCallStatusListResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getCallStatusListResponse(pmResult, callStatusList, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnCallStatusListChanged(IN const CallStatusList& callStatusList) const
   {
      ETG_TRACE_USR1(("OnCallStatusListChanged"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onCallStatusListChanged(callStatusList);
      }
   }

   void PmCoreCallbackIfWrapper::doGetMicrophoneMuteStateResponse(IN const PmResult& pmResult,
         IN const MicrophoneMuteState& microphoneMuteState, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetMicrophoneMuteStateResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getMicrophoneMuteStateResponse(pmResult, microphoneMuteState, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnMicrophoneMuteStateChanged(IN const MicrophoneMuteState& microphoneMuteState) const
   {
      ETG_TRACE_USR1(("OnMicrophoneMuteStateChanged"));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onMicrophoneMuteStateChanged(microphoneMuteState);
      }
   }

   void PmCoreCallbackIfWrapper::doSetMicrophoneMuteStateResponse(IN const PmResult& pmResult,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("SetMicrophoneMuteStateResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->setMicrophoneMuteStateResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doMergeCallsResponse(IN const PmResult& pmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("MergeCallsResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->mergeCallsResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doSplitCallsResponse(IN const PmResult& pmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("SplitCallsResponse: act = %u",act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->splitCallsResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doHangupCallsResponse(IN const PmResult& pmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("HangupCallsResponse: act = %u",act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->hangupCallsResponse(pmResult, act);
      }
   }

   void PmCoreCallbackIfWrapper::doRedialResponse(IN const PmResult& pmResult, IN const BdAddress& deviceAddress,
            IN const CallInstance callInstance, IN const ActType act) const
   {
      ETG_TRACE_USR1(("RedialResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->redialResponse(pmResult, deviceAddress, callInstance, act);
      }
   }

   void PmCoreCallbackIfWrapper::doGetSCOConnectionResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const SCOConnection& scoConnection, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetSCOConnectionResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getSCOConnectionResponse(pmResult, deviceAddress, scoConnection, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnSCOConnectionChanged(IN const BdAddress& deviceAddress,
         IN const SCOConnection& scoConnection) const
   {
      ETG_TRACE_USR1(("OnSCOConnectionChanged: deviceAddress = %50s",deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onSCOConnectionChanged(deviceAddress, scoConnection);
      }
   }

   void PmCoreCallbackIfWrapper::doGetRingtoneMuteStateResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const RingtoneMuteState& ringtoneMuteState, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetRingtoneMuteStateResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getRingtoneMuteStateResponse(pmResult, deviceAddress, ringtoneMuteState, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnRingtoneMuteStateChanged(IN const BdAddress& deviceAddress,
            IN const RingtoneMuteState& ringtoneMuteState) const
   {
      ETG_TRACE_USR1(("OnRingtoneMuteStateChanged: deviceAddress = %50s",deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onRingtoneMuteStateChanged(deviceAddress, ringtoneMuteState);
      }
   }

   void PmCoreCallbackIfWrapper::doSetRingtoneMuteStateResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const ActType act) const
   {
      ETG_TRACE_USR1(("SetRingtoneMuteStateResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->setRingtoneMuteStateResponse(pmResult, deviceAddress, act);
      }
   }

   void PmCoreCallbackIfWrapper::doGetWaitingModeStateResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const WaitingModeState& waitingModeState, IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetWaitingModeStateResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getWaitingModeStateResponse(pmResult, deviceAddress, waitingModeState, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnWaitingModeStateChanged(IN const BdAddress& deviceAddress,
            IN const WaitingModeState& waitingModeState) const
   {
      ETG_TRACE_USR1(("OnWaitingModeStateChanged: deviceAddress = %50s",deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onWaitingModeStateChanged(deviceAddress, waitingModeState);
      }
   }

   void PmCoreCallbackIfWrapper::doGetRingtonePlaybackStatusResponse(IN const pmcore::PmResult& pmResult,
         IN const pmcore::RingtonePlaybackState& ringtonePlaybackState, IN const pmcore::ActType act) const
   {
      ETG_TRACE_USR1(("doGetRingtonePlaybackStatusResponse: ringtonePlaybackState = %u",
            ringtonePlaybackState._ringtonePlaybackState));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getRingtonePlaybackStatusResponse(pmResult, ringtonePlaybackState ,act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnRingtonePlaybackStatusChanged(
         IN const pmcore::RingtonePlaybackState& ringtonePlaybackState) const
   {
      ETG_TRACE_USR1(("doOnRingtonePlaybackStatusChanged: ringtonePlaybackState= %u",
            ringtonePlaybackState._ringtonePlaybackState));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onRingtonePlaybackStatusChanged(ringtonePlaybackState);
      }
   }

   void PmCoreCallbackIfWrapper::doStartStopWaitingModeResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const ActType act) const
   {
      ETG_TRACE_USR1(("StartStopWaitingModeResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->startStopWaitingModeResponse(pmResult, deviceAddress, act);
      }
   }

   void PmCoreCallbackIfWrapper::doDialResponse(IN const PmResult& pmResult, IN const BdAddress& deviceAddress,
            IN const CallInstance callInstance, IN const ActType act) const
   {
      ETG_TRACE_USR1(("DialResponse: deviceAddress = %50s, callInstance = %d, act = %u",
            deviceAddress.c_str(), callInstance, act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->dialResponse(pmResult, deviceAddress, callInstance, act);
      }
   }

   void PmCoreCallbackIfWrapper::doAcceptCallResponse(IN const PmResult& pmResult, IN const BdAddress& deviceAddress,
            IN const CallInstance callInstance, IN const ActType act) const
   {
      ETG_TRACE_USR1(("AcceptCallResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->acceptCallResponse(pmResult, deviceAddress, callInstance, act);
      }
   }

   void PmCoreCallbackIfWrapper::doSwapCallResponse(IN const PmResult& pmResult, IN const BdAddress& deviceAddress,
            IN const ActType act) const
   {
      ETG_TRACE_USR1(("SwapCallResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->swapCallResponse(pmResult, deviceAddress, act);
      }
   }

   void PmCoreCallbackIfWrapper::doSpeedDialResponse(IN const PmResult& pmResult, IN const BdAddress& deviceAddress,
            IN const CallInstance callInstance, IN const ActType act) const
   {
      ETG_TRACE_USR1(("SpeedDialResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->speedDialResponse(pmResult, deviceAddress, callInstance, act);
      }
   }

   void PmCoreCallbackIfWrapper::doSendDTMFResponse(IN const PmResult& pmResult, IN const BdAddress& deviceAddress,
            IN const ActType act) const
   {
      ETG_TRACE_USR1(("SendDTMFResponse: deviceAddress = %50s, act = %u",deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->sendDTMFResponse(pmResult, deviceAddress, act);
      }
   }

   void PmCoreCallbackIfWrapper::doTransferAudioResponse(IN const PmResult& pmResult, IN const BdAddress& deviceAddress,
            IN const ActType act) const
   {
      ETG_TRACE_USR1(("TransferAudioResponse: deviceAddress = %50s, act = %u",
            deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->transferAudioResponse(pmResult, deviceAddress, act);
      }
   }

   void PmCoreCallbackIfWrapper::doGetVoiceRecognitionStatusResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const VoiceRecognitionStatus& voiceRecognitionStatus,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetVoiceRecognitionStatusResponse: deviceAddress = %50s", deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getVoiceRecognitionStatusResponse(pmResult, deviceAddress, voiceRecognitionStatus, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnVoiceRecognitionStatusChanged(IN const BdAddress& deviceAddress,
            IN const VoiceRecognitionStatus& voiceRecognitionStatus) const
   {
      ETG_TRACE_USR1(("OnVoiceRecognitionStatusChanged: deviceAddress = %50s", deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onVoiceRecognitionStatusChanged(deviceAddress, voiceRecognitionStatus);
      }
   }

   void PmCoreCallbackIfWrapper::doStartStopVoiceRecognitionResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const ActType act) const
   {
      ETG_TRACE_USR1(("StartStopVoiceRecognitionResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->startStopVoiceRecognitionResponse(pmResult, deviceAddress, act);
      }
   }

   void PmCoreCallbackIfWrapper::doGetEnhancedVoiceRecognitionFeatureResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const EnhancedVoiceRecognitionFeature& enhancedVoiceRecognitionFeature,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetEnhancedVoiceRecognitionFeatureResponse: deviceAddress = %50s, act = %u",
            deviceAddress.c_str(), act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getEnhancedVoiceRecognitionFeatureResponse(pmResult, deviceAddress,
               enhancedVoiceRecognitionFeature, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnEnhancedVoiceRecognitionFeatureChanged(IN const BdAddress& deviceAddress,
            IN const EnhancedVoiceRecognitionFeature& enhancedVoiceRecognitionFeature) const
   {
      ETG_TRACE_USR1(("OnEnhancedVoiceRecognitionFeatureChanged: deviceAddress = %50s",
            deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onEnhancedVoiceRecognitionFeatureChanged(deviceAddress, enhancedVoiceRecognitionFeature);
      }
   }

   void PmCoreCallbackIfWrapper::doGetExternalVRStateResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const ExtVoiceRecognitionStatus& extVoiceRecognitionStatus,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("GetExternalVRStateResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->getExternalVRStateResponse(pmResult, deviceAddress, extVoiceRecognitionStatus, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnExternalVRStateChanged(IN const BdAddress& deviceAddress,
         IN const ExtVoiceRecognitionStatus& extVoiceRecognitionStatus) const
   {
      ETG_TRACE_USR1(("OnExternalVRStateChanged: deviceAddress = %s", deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onExternalVRStateChanged(deviceAddress, extVoiceRecognitionStatus);
      }
   }

   void PmCoreCallbackIfWrapper::doActivateExternalVRResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const ActType act) const
   {
      ETG_TRACE_USR1(("ActivateExternalVRResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->activateExternalVRResponse(pmResult, deviceAddress, act);
      }
   }

   void PmCoreCallbackIfWrapper::doDeActivateExternalVRResponse(IN const PmResult& pmResult,
         IN const BdAddress& deviceAddress, IN const ActType act) const
   {
      ETG_TRACE_USR1(("DeActivateExternalVRResponse: act = %u", act));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->deActivateExternalVRResponse(pmResult, deviceAddress, act);
      }
   }

   void PmCoreCallbackIfWrapper::doOnPmStateChanged(IN const BdAddress& deviceAddress,
         IN const CallExistenceState callExistenceState) const
   {
      ETG_TRACE_USR1(("OnPmStateChanged: deviceAddress = %50s", deviceAddress.c_str()));

      if(nullptr != _pmCoreCallbackIf)
      {
         _pmCoreCallbackIf->onPmStateChanged(deviceAddress, callExistenceState);
      }
   }
}
