/**
 * @file WaitingModeState.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the WaitingModeState class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "WaitingModeState.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/WaitingModeState.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   WaitingModeState::WaitingModeState() : _waitingModeState(WAITING_MODE_IDLE)
   {
   }

   WaitingModeState::WaitingModeState(const WaitingModeStateType waitingModeState) :
         _waitingModeState(waitingModeState)
   {
   }

   WaitingModeState::WaitingModeState(const WaitingModeState& other) :
         _waitingModeState(other._waitingModeState)
   {
   }

   WaitingModeState::~WaitingModeState()
   {
   }

   void swap(WaitingModeState& first, WaitingModeState& second)
   {
      using std::swap;

      swap(first._waitingModeState, second._waitingModeState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   WaitingModeState& WaitingModeState::operator=(WaitingModeState other)
   {
      swap(*this, other);

      return *this;
   }

   bool WaitingModeState::operator==(const WaitingModeState& rhs) const
   {
      return ((this->_waitingModeState == rhs._waitingModeState));
   }

   bool WaitingModeState::operator!=(const WaitingModeState& rhs) const
   {
      return (!(this->_waitingModeState == rhs._waitingModeState));
   }
}
