/**
 * @file WaitingModeFilePath.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the WaitingModeFilePath class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef WaitingModeFilePath_h
#define WaitingModeFilePath_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class WaitingModeFilePath
   {
   public:
      /**
       * Constructor of WaitingModeFilePath class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      WaitingModeFilePath();

      /**
       * Parameterized Constructor of WaitingModeFilePath class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      WaitingModeFilePath(const FilePath filePathNB, const FilePath filePathWB);

      /**
       * Copy Constructor of WaitingModeFilePath class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      WaitingModeFilePath(const WaitingModeFilePath& other);

      /**
       * Destructor of WaitingModeFilePath class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~WaitingModeFilePath();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(WaitingModeFilePath& first, WaitingModeFilePath& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      WaitingModeFilePath& operator=(WaitingModeFilePath other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const WaitingModeFilePath& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const WaitingModeFilePath& rhs) const;

      FilePath _filePathNB; /**< file path of narrow band audio file */
      FilePath _filePathWB; /**< file path of wide band audio file */
   };

} // namespace pmcore

#endif // WaitingModeFilePath_h
