/**
 * @file VoiceRecognitionStatus.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the VoiceRecognitionStatus class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "VoiceRecognitionStatus.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/VoiceRecognitionStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   VoiceRecognitionStatus::VoiceRecognitionStatus() : _vrStatus(VR_SESSION_IDLE)
   {
   }

   VoiceRecognitionStatus::VoiceRecognitionStatus(const VRStatus vrStatus) : _vrStatus(vrStatus)
   {
   }

   VoiceRecognitionStatus::VoiceRecognitionStatus(const VoiceRecognitionStatus& other) : _vrStatus(other._vrStatus)
   {
   }

   VoiceRecognitionStatus::~VoiceRecognitionStatus()
   {
   }

   void swap(VoiceRecognitionStatus& first, VoiceRecognitionStatus& second)
   {
      using std::swap;

      swap(first._vrStatus, second._vrStatus);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   VoiceRecognitionStatus& VoiceRecognitionStatus::operator=(VoiceRecognitionStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool VoiceRecognitionStatus::operator==(const VoiceRecognitionStatus& rhs) const
   {
      return ((this->_vrStatus == rhs._vrStatus));
   }

   bool VoiceRecognitionStatus::operator!=(const VoiceRecognitionStatus& rhs) const
   {
      return (!(this->_vrStatus == rhs._vrStatus));
   }
}
