/**
 * @file VehicleConfiguration.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the VehicleConfiguration class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "VehicleConfiguration.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/VehicleConfiguration.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif


namespace pmcore
{

VehicleConfiguration::VehicleConfiguration()
: _vehicleBTAddress(""),_vendorIDSource(DEFAULT_VEHICLE_ID),_vendorID(DEFAULT_VEHICLE_ID),_productID(DEFAULT_VEHICLE_ID),_productVersion(DEFAULT_VEHICLE_ID)
{
}

VehicleConfiguration::VehicleConfiguration(const BdAddress BtAddress, const VehicleDetails vendorIDSource, const VehicleDetails vendorID, const VehicleDetails productID, const VehicleDetails productVersion) :
            _vehicleBTAddress(BtAddress), _vendorIDSource(vendorIDSource), _vendorID(vendorID), _productID(productID), _productVersion(productVersion)
{
}

VehicleConfiguration::VehicleConfiguration(const VehicleConfiguration& other) :
            _vehicleBTAddress(other._vehicleBTAddress), _vendorIDSource(other._vendorIDSource), _vendorID(other._vendorID), _productID(other._productID), _productVersion(other._productVersion)
{
}


VehicleConfiguration::~VehicleConfiguration()
{
}

void swap(VehicleConfiguration& first, VehicleConfiguration& second)
{
   using std::swap;

   swap(first._vehicleBTAddress, second._vehicleBTAddress);
   swap(first._vendorIDSource, second._vendorIDSource);
   swap(first._vendorID, second._vendorID);
   swap(first._productID, second._productID);
   swap(first._productVersion, second._productVersion);
}

VehicleConfiguration& VehicleConfiguration::operator=(VehicleConfiguration other)
{
   swap(*this, other);

   return *this;
}

bool VehicleConfiguration::operator==(const VehicleConfiguration& rhs) const
{
   return ((this->_vehicleBTAddress == rhs._vehicleBTAddress)
         && (this->_vendorIDSource == rhs._vendorIDSource)
         && (this->_vendorID == rhs._vendorID)
         && (this->_productID == rhs._productID)
         && (this->_productVersion == rhs._productVersion));
}

bool VehicleConfiguration::operator!=(const VehicleConfiguration& rhs) const
{
   return (!((this->_vehicleBTAddress == rhs._vehicleBTAddress)
         && (this->_vendorIDSource == rhs._vendorIDSource)
         && (this->_vendorID == rhs._vendorID)
         && (this->_productID == rhs._productID)
         && (this->_productVersion == rhs._productVersion)));
}

} // namespace pmcore
