/**
 * @file SystemWideRingtonesList.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SystemWideRingtonesList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "SystemWideRingtonesList.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/SystemWideRingtonesList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   SystemWideRingtonesList::SystemWideRingtonesList() :
         _activeSystemRingtoneId(RINGTONE_ID_DEFAULT), _systemRingtonesList()
   {
   }

   SystemWideRingtonesList::SystemWideRingtonesList(const RingtoneId activeSystemRingtoneId,
         const SystemRingtonesList systemRingtonesList) :
         _activeSystemRingtoneId(activeSystemRingtoneId),_systemRingtonesList(systemRingtonesList)
   {
   }

   SystemWideRingtonesList::SystemWideRingtonesList(const SystemWideRingtonesList& other) :
         _activeSystemRingtoneId(other._activeSystemRingtoneId),_systemRingtonesList(other._systemRingtonesList)
   {
   }

   SystemWideRingtonesList::~SystemWideRingtonesList()
   {
   }

   void swap(SystemWideRingtonesList& first, SystemWideRingtonesList& second)
   {
      using std::swap;

      swap(first._activeSystemRingtoneId, second._activeSystemRingtoneId);
      swap(first._systemRingtonesList, second._systemRingtonesList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   SystemWideRingtonesList& SystemWideRingtonesList::operator=(SystemWideRingtonesList other)
   {
      swap(*this, other);

      return *this;
   }

   bool SystemWideRingtonesList::operator==(const SystemWideRingtonesList& rhs) const
   {
      return ((this->_activeSystemRingtoneId == rhs._activeSystemRingtoneId)
            && (this->_systemRingtonesList == rhs._systemRingtonesList));
   }

   bool SystemWideRingtonesList::operator!=(const SystemWideRingtonesList& rhs) const
   {
      return (!((this->_activeSystemRingtoneId == rhs._activeSystemRingtoneId)
            && (this->_systemRingtonesList == rhs._systemRingtonesList)));
   }
}
