/**
 * @file SupportedFeatures.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SupportedFeatures class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef SupportedFeatures_h
#define SupportedFeatures_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class SupportedFeatures
   {
   public:
      /**
       * Constructor of SupportedFeatures class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SupportedFeatures();

      /**
       * Parameterized Constructor of SupportedFeatures class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SupportedFeatures(const SupportedFeaturesType supportedFeatures);

      /**
       * Copy Constructor of SupportedFeatures class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SupportedFeatures(const SupportedFeatures& other);

      /**
       * Destructor of SupportedFeatures class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~SupportedFeatures();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(SupportedFeatures& first, SupportedFeatures& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      SupportedFeatures& operator=(SupportedFeatures other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const SupportedFeatures& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const SupportedFeatures& rhs) const;

      SupportedFeaturesType _supportedFeatures; /**< supported features */
   };

} // namespace pmcore

#endif // SupportedFeatures_h
