/**
 * @file SupportedFeatures.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SupportedFeatures class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "SupportedFeatures.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/SupportedFeatures.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   SupportedFeatures::SupportedFeatures() : _supportedFeatures()
   {
   }

   SupportedFeatures::SupportedFeatures(const SupportedFeaturesType supportedFeatures) :
         _supportedFeatures(supportedFeatures)
   {
   }

   SupportedFeatures::SupportedFeatures(const SupportedFeatures& other) :
         _supportedFeatures(other._supportedFeatures)
   {
   }

   SupportedFeatures::~SupportedFeatures()
   {
   }

   void swap(SupportedFeatures& first, SupportedFeatures& second)
   {
      using std::swap;

      swap(first._supportedFeatures, second._supportedFeatures);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   SupportedFeatures& SupportedFeatures::operator=(SupportedFeatures other)
   {
      swap(*this, other);

      return *this;
   }

   bool SupportedFeatures::operator==(const SupportedFeatures& rhs) const
   {
      return ((this->_supportedFeatures == rhs._supportedFeatures));
   }

   bool SupportedFeatures::operator!=(const SupportedFeatures& rhs) const
   {
      return (!(this->_supportedFeatures == rhs._supportedFeatures));
   }
}
