/**
 * @file SignalStrength.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SignalStrength class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef SignalStrength_h
#define SignalStrength_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class SignalStrength
   {
   public:
      /**
       * Constructor of SignalStrength class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SignalStrength();

      /**
       * Parameterized Constructor of SignalStrength class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SignalStrength(const SignalStrengthType signalStrength);

      /**
       * Copy Constructor of SignalStrength class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SignalStrength(const SignalStrength& other);

      /**
       * Destructor of SignalStrength class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~SignalStrength();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(SignalStrength& first, SignalStrength& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      SignalStrength& operator=(SignalStrength other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const SignalStrength& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const SignalStrength& rhs) const;

      SignalStrengthType _signalStrength; /**< signal strength */
   };

} // namespace pmcore

#endif // SignalStrength_h
