/**
 * @file SignalStrength.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SignalStrength class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "SignalStrength.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/SignalStrength.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   SignalStrength::SignalStrength() : _signalStrength(SIGNAL_STRENGTH_DEFAULT)
   {
   }

   SignalStrength::SignalStrength(const SignalStrengthType signalStrength) : _signalStrength(signalStrength)
   {
   }

   SignalStrength::SignalStrength(const SignalStrength& other) : _signalStrength(other._signalStrength)
   {
   }

   SignalStrength::~SignalStrength()
   {
   }

   void swap(SignalStrength& first, SignalStrength& second)
   {
      using std::swap;

      swap(first._signalStrength, second._signalStrength);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   SignalStrength& SignalStrength::operator=(SignalStrength other)
   {
      swap(*this, other);

      return *this;
   }

   bool SignalStrength::operator==(const SignalStrength& rhs) const
   {
      return ((this->_signalStrength == rhs._signalStrength));
   }

   bool SignalStrength::operator!=(const SignalStrength& rhs) const
   {
      return (!(this->_signalStrength == rhs._signalStrength));
   }
}
