/**
 * @file SCOConnection.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SCOConnection class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef SCOConnection_h
#define SCOConnection_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class SCOConnection
   {
   public:
      /**
       * Constructor of SCOConnection class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SCOConnection();

      /**
       * Parameterized Constructor of SCOConnection class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SCOConnection(const SCOStatus scoStatus);

      /**
       * Copy Constructor of SCOConnection class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      SCOConnection(const SCOConnection& other);

      /**
       * Destructor of SCOConnection class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~SCOConnection();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(SCOConnection& first, SCOConnection& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      SCOConnection& operator=(SCOConnection other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const SCOConnection& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const SCOConnection& rhs) const;

      SCOStatus _scoStatus; /**< sco status */
   };

} // namespace pmcore

#endif // SCOConnection_h
