/**
 * @file SCOConnection.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the SCOConnection class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "SCOConnection.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/SCOConnection.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   SCOConnection::SCOConnection() : _scoStatus(SCO_DEFAULT)
   {
   }

   SCOConnection::SCOConnection(const SCOStatus scoStatus) : _scoStatus(scoStatus)
   {
   }

   SCOConnection::SCOConnection(const SCOConnection& other) : _scoStatus(other._scoStatus)
   {
   }

   SCOConnection::~SCOConnection()
   {
   }

   void swap(SCOConnection& first, SCOConnection& second)
   {
      using std::swap;

      swap(first._scoStatus, second._scoStatus);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   SCOConnection& SCOConnection::operator=(SCOConnection other)
   {
      swap(*this, other);

      return *this;
   }

   bool SCOConnection::operator==(const SCOConnection& rhs) const
   {
      return ((this->_scoStatus == rhs._scoStatus));
   }

   bool SCOConnection::operator!=(const SCOConnection& rhs) const
   {
      return (!(this->_scoStatus == rhs._scoStatus));
   }
}
