/**
 * @file RingtonePlaybackState.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the RingtonePlaybackState class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef RingtonePlaybackState_h
#define RingtonePlaybackState_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class RingtonePlaybackState
   {
   public:
      /**
       * Constructor of RingtonePlaybackState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      RingtonePlaybackState();

      /**
       * Parameterized constructor of RingtonePlaybackState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      RingtonePlaybackState(const RingtonePlaybackStateType RingtonePlaybackState);

      /**
       * Copy constructor of RingtonePlaybackState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      RingtonePlaybackState(const RingtonePlaybackState& other);

      /**
       * Destructor of RingtonePlaybackState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~RingtonePlaybackState();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(RingtonePlaybackState& first, RingtonePlaybackState& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      RingtonePlaybackState& operator=(RingtonePlaybackState other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const RingtonePlaybackState& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const RingtonePlaybackState& rhs) const;

      RingtonePlaybackStateType _ringtonePlaybackState; /**< Ringtone playback state type*/
   };

} // namespace pmcore

#endif // WatingModeStateType_h
