/**
 * @file RingtonePlaybackState.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the RingtonePlaybackState class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "RingtonePlaybackState.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/RingtonePlaybackState.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   RingtonePlaybackState::RingtonePlaybackState() : _ringtonePlaybackState(RT_NOT_PLAYING)
   {
   }

   RingtonePlaybackState::RingtonePlaybackState(const RingtonePlaybackStateType ringtonePlaybackState) :
         _ringtonePlaybackState(ringtonePlaybackState)
   {
   }

   RingtonePlaybackState::RingtonePlaybackState(const RingtonePlaybackState& other) :
         _ringtonePlaybackState(other._ringtonePlaybackState)
   {
   }

   RingtonePlaybackState::~RingtonePlaybackState()
   {
   }

   void swap(RingtonePlaybackState& first, RingtonePlaybackState& second)
   {
      using std::swap;

      swap(first._ringtonePlaybackState, second._ringtonePlaybackState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   RingtonePlaybackState& RingtonePlaybackState::operator=(RingtonePlaybackState other)
   {
      swap(*this, other);

      return *this;
   }

   bool RingtonePlaybackState::operator==(const RingtonePlaybackState& rhs) const
   {
      return ((this->_ringtonePlaybackState == rhs._ringtonePlaybackState));
   }

   bool RingtonePlaybackState::operator!=(const RingtonePlaybackState& rhs) const
   {
      return (!(this->_ringtonePlaybackState == rhs._ringtonePlaybackState));
   }
}
