/**
 * @file RingtoneMuteState.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the RingtoneMuteState class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef RingtoneMuteState_h
#define RingtoneMuteState_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class RingtoneMuteState
   {
   public:
      /**
       * Constructor of RingtoneMuteState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      RingtoneMuteState();

      /**
       * Parameterized Constructor of RingtoneMuteState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      RingtoneMuteState(const MuteState ringtoneMuteState);

      /**
       * Copy Constructor of RingtoneMuteState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      RingtoneMuteState(const RingtoneMuteState& other);

      /**
       * Destructor of RingtoneMuteState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~RingtoneMuteState();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(RingtoneMuteState& first, RingtoneMuteState& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      RingtoneMuteState& operator=(RingtoneMuteState other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const RingtoneMuteState& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const RingtoneMuteState& rhs) const;

      MuteState _ringtoneMuteState; /**< ringtone mute state */
   };

} // namespace pmcore

#endif // RingtoneMuteState_h
