/**
 * @file PmResult.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the PmResult class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef PmResult_h
#define PmResult_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class PmResult
   {
   public:
      /**
       * Constructor of PmResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      PmResult();

      /**
       * Parameterized Constructor of PmResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      PmResult(const PmResultCode pmResultCode, const PmResultMessage pmResultMessage);

      /**
       * Copy Constructor of PmResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      PmResult(const PmResult& other);

      /**
       * Destructor of PmResult class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~PmResult();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(PmResult& first, PmResult& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      PmResult& operator=(PmResult other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const PmResult& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const PmResult& rhs) const;

      PmResultCode _pmResultCode;       /**< pm result code */
      PmResultMessage _pmResultMessage; /**< pm result message */
   };

} // namespace pmcore

#endif // PmResult_h
