/**
 * @file NetworkStatus.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the NetworkStatus class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "NetworkStatus.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/NetworkStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   NetworkStatus::NetworkStatus() : _networkStatus(NETWORK_STATUS_DEFAULT)
   {
   }

   NetworkStatus::NetworkStatus(const NetworkStatusType networkStatus) : _networkStatus(networkStatus)
   {
   }

   NetworkStatus::NetworkStatus(const NetworkStatus& other) : _networkStatus(other._networkStatus)
   {
   }

   NetworkStatus::~NetworkStatus()
   {
   }

   void swap(NetworkStatus& first, NetworkStatus& second)
   {
      using std::swap;

      swap(first._networkStatus, second._networkStatus);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   NetworkStatus& NetworkStatus::operator=(NetworkStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool NetworkStatus::operator==(const NetworkStatus& rhs) const
   {
      return ((this->_networkStatus == rhs._networkStatus));
   }

   bool NetworkStatus::operator!=(const NetworkStatus& rhs) const
   {
      return (!(this->_networkStatus == rhs._networkStatus));
   }
}
