/**
 * @file NetworkOperator.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the NetworkOperator class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "NetworkOperator.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/NetworkOperator.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   NetworkOperator::NetworkOperator() : _networkOperator("")
   {
   }

   NetworkOperator::NetworkOperator(const NetworkOperatorType networkOperator) : _networkOperator(networkOperator)
   {
   }

   NetworkOperator::NetworkOperator(const NetworkOperator& other) : _networkOperator(other._networkOperator)
   {
   }

   NetworkOperator::~NetworkOperator()
   {
   }

   void swap(NetworkOperator& first, NetworkOperator& second)
   {
      using std::swap;

      swap(first._networkOperator, second._networkOperator);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   NetworkOperator& NetworkOperator::operator=(NetworkOperator other)
   {
      swap(*this, other);

      return *this;
   }

   bool NetworkOperator::operator==(const NetworkOperator& rhs) const
   {
      return ((this->_networkOperator == rhs._networkOperator));
   }

   bool NetworkOperator::operator!=(const NetworkOperator& rhs) const
   {
      return (!(this->_networkOperator == rhs._networkOperator));
   }
}
