/**
 * @file MicrophoneMuteState.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the MicrophoneMuteState class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef MicrophoneMuteState_h
#define MicrophoneMuteState_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class MicrophoneMuteState
   {
   public:
      /**
       * Constructor of MicrophoneMuteState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      MicrophoneMuteState();

      /**
       * Parameterized Constructor of MicrophoneMuteState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      MicrophoneMuteState(const MuteState microphoneMuteState);

      /**
       * Copy Constructor of MicrophoneMuteState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      MicrophoneMuteState(const MicrophoneMuteState& other);

      /**
       * Destructor of MicrophoneMuteState class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~MicrophoneMuteState();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(MicrophoneMuteState& first, MicrophoneMuteState& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      MicrophoneMuteState& operator=(MicrophoneMuteState other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const MicrophoneMuteState& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const MicrophoneMuteState& rhs) const;

      MuteState _microphoneMuteState; /**< microphone mute state */
   };

} // namespace pmcore

#endif // MicrophoneMuteState_h
