/**
 * @file MicrophoneMuteState.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the MicrophoneMuteState class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "MicrophoneMuteState.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/MicrophoneMuteState.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   MicrophoneMuteState::MicrophoneMuteState() : _microphoneMuteState(false)
   {
   }

   MicrophoneMuteState::MicrophoneMuteState(const MuteState microphoneMuteState) :
         _microphoneMuteState(microphoneMuteState)
   {
   }

   MicrophoneMuteState::MicrophoneMuteState(const MicrophoneMuteState& other) :
         _microphoneMuteState(other._microphoneMuteState)
   {
   }

   MicrophoneMuteState::~MicrophoneMuteState()
   {
   }

   void swap(MicrophoneMuteState& first, MicrophoneMuteState& second)
   {
      using std::swap;

      swap(first._microphoneMuteState, second._microphoneMuteState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   MicrophoneMuteState& MicrophoneMuteState::operator=(MicrophoneMuteState other)
   {
      swap(*this, other);

      return *this;
   }

   bool MicrophoneMuteState::operator==(const MicrophoneMuteState& rhs) const
   {
      return ((this->_microphoneMuteState == rhs._microphoneMuteState));
   }

   bool MicrophoneMuteState::operator!=(const MicrophoneMuteState& rhs) const
   {
      return (!(this->_microphoneMuteState == rhs._microphoneMuteState));
   }
}
