/**
 * @file FriendlyName.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the FriendlyName class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef FriendlyName_h
#define FriendlyName_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class FriendlyName
   {
   public:
      /**
       * Constructor of FriendlyName class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      FriendlyName();

      /**
       * Parameterized Constructor of FriendlyName class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      FriendlyName(const FriendlyNameType friendlyName);

      /**
       * Copy Constructor of FriendlyName class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      FriendlyName(const FriendlyName& other);

      /**
       * Destructor of FriendlyName class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~FriendlyName();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(FriendlyName& first, FriendlyName& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      FriendlyName& operator=(FriendlyName other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const FriendlyName& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const FriendlyName& rhs) const;

      FriendlyNameType _friendlyName; /**< friendly name of the device */
   };

} // namespace pmcore

#endif // FriendlyName_h
