/**
 * @file FriendlyName.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the FriendlyName class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "FriendlyName.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/FriendlyName.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   FriendlyName::FriendlyName() : _friendlyName("")
   {
   }

   FriendlyName::FriendlyName(const FriendlyNameType friendlyName) : _friendlyName(friendlyName)
   {
   }

   FriendlyName::FriendlyName(const FriendlyName& other) : _friendlyName(other._friendlyName)
   {
   }

   FriendlyName::~FriendlyName()
   {
   }

   void swap(FriendlyName& first, FriendlyName& second)
   {
      using std::swap;

      swap(first._friendlyName, second._friendlyName);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   FriendlyName& FriendlyName::operator=(FriendlyName other)
   {
      swap(*this, other);

      return *this;
   }

   bool FriendlyName::operator==(const FriendlyName& rhs) const
   {
      return ((this->_friendlyName == rhs._friendlyName));
   }

   bool FriendlyName::operator!=(const FriendlyName& rhs) const
   {
      return (!(this->_friendlyName == rhs._friendlyName));
   }
}
