/**
 * @file ExtVoiceRecognitionStatus.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the ExtVoiceRecognitionStatus class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef ExtVoiceRecognitionStatus_h
#define ExtVoiceRecognitionStatus_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class ExtVoiceRecognitionStatus
   {
   public:
      /**
       * Constructor of ExtVoiceRecognitionStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ExtVoiceRecognitionStatus();

      /**
       * Parameterized Constructor of ExtVoiceRecognitionStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ExtVoiceRecognitionStatus(const ExternalVRStatusEnumType extVRStatus);

      /**
       * Copy Constructor of ExtVoiceRecognitionStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ExtVoiceRecognitionStatus(const ExtVoiceRecognitionStatus& other);

      /**
       * Destructor of ExtVoiceRecognitionStatus class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~ExtVoiceRecognitionStatus();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(ExtVoiceRecognitionStatus& first, ExtVoiceRecognitionStatus& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      ExtVoiceRecognitionStatus& operator=(ExtVoiceRecognitionStatus other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const ExtVoiceRecognitionStatus& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const ExtVoiceRecognitionStatus& rhs) const;

      ExternalVRStatusEnumType _extVRStatus; /**< voice recognition status */
   };

} // namespace pmcore

#endif // VoiceRecognitionStatus_h
