/**
 * @file ExtVoiceRecognitionStatus.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the ExtVoiceRecognitionStatus class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "ExtVoiceRecognitionStatus.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ExtVoiceRecognitionStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   ExtVoiceRecognitionStatus::ExtVoiceRecognitionStatus() : _extVRStatus(EXT_VR_SESSION_IDLE)
   {
   }

   ExtVoiceRecognitionStatus::ExtVoiceRecognitionStatus(const ExternalVRStatusEnumType extVRStatus) :
         _extVRStatus(extVRStatus)
   {
   }

   ExtVoiceRecognitionStatus::ExtVoiceRecognitionStatus(const ExtVoiceRecognitionStatus& other) :
         _extVRStatus(other._extVRStatus)
   {
   }

   ExtVoiceRecognitionStatus::~ExtVoiceRecognitionStatus()
   {
   }

   void swap(ExtVoiceRecognitionStatus& first, ExtVoiceRecognitionStatus& second)
   {
      using std::swap;

      swap(first._extVRStatus, second._extVRStatus);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   ExtVoiceRecognitionStatus& ExtVoiceRecognitionStatus::operator=(ExtVoiceRecognitionStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool ExtVoiceRecognitionStatus::operator==(const ExtVoiceRecognitionStatus& rhs) const
   {
      return ((this->_extVRStatus == rhs._extVRStatus));
   }

   bool ExtVoiceRecognitionStatus::operator!=(const ExtVoiceRecognitionStatus& rhs) const
   {
      return (!(this->_extVRStatus == rhs._extVRStatus));
   }
}
