/**
 * @file EnhancedVoiceRecognitionFeature.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the EnhancedVoiceRecognitionFeature class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef EnhancedVoiceRecognitionFeature_h
#define EnhancedVoiceRecognitionFeature_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class EnhancedVoiceRecognitionFeature
   {
   public:
      /**
       * Constructor of EnhancedVoiceRecognitionFeature class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      EnhancedVoiceRecognitionFeature();

      /**
       * Parameterized Constructor of EnhancedVoiceRecognitionFeature class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      EnhancedVoiceRecognitionFeature(const EnhancedVRFeature enhancedVRFeature,
            const EnhancedVRAvailability enhancedVRAvailability);

      /**
       * Copy Constructor of EnhancedVoiceRecognitionFeature class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      EnhancedVoiceRecognitionFeature(const EnhancedVoiceRecognitionFeature& other);

      /**
       * Destructor of EnhancedVoiceRecognitionFeature class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~EnhancedVoiceRecognitionFeature();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(EnhancedVoiceRecognitionFeature& first, EnhancedVoiceRecognitionFeature& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      EnhancedVoiceRecognitionFeature& operator=(EnhancedVoiceRecognitionFeature other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const EnhancedVoiceRecognitionFeature& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const EnhancedVoiceRecognitionFeature& rhs) const;

      EnhancedVRFeature    _enhancedVRFeature;    /**< enhanced voice recognition feature */
      EnhancedVRAvailability _enhancedVRAvailability; /**< Enhanced voice recognition availability status */
   };

} // namespace pmcore

#endif // EnhancedVoiceRecognitionFeature_h
