/**
 * @file EnhancedVoiceRecognitionFeature.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the EnhancedVoiceRecognitionFeature class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "EnhancedVoiceRecognitionFeature.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EnhancedVoiceRecognitionFeature.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   EnhancedVoiceRecognitionFeature::EnhancedVoiceRecognitionFeature() :
         _enhancedVRFeature(""), _enhancedVRAvailability(ENHANCED_VR_DEFAULT)
   {
   }

   EnhancedVoiceRecognitionFeature::EnhancedVoiceRecognitionFeature(const EnhancedVRFeature enhancedVRFeature,
         const EnhancedVRAvailability enhancedVRAvailability) :
      _enhancedVRFeature(enhancedVRFeature), _enhancedVRAvailability(enhancedVRAvailability)
   {
   }

   EnhancedVoiceRecognitionFeature::EnhancedVoiceRecognitionFeature(const EnhancedVoiceRecognitionFeature& other) :
      _enhancedVRFeature(other._enhancedVRFeature), _enhancedVRAvailability(other._enhancedVRAvailability)
   {
   }

   EnhancedVoiceRecognitionFeature::~EnhancedVoiceRecognitionFeature()
   {
   }

   void swap(EnhancedVoiceRecognitionFeature& first, EnhancedVoiceRecognitionFeature& second)
   {
      using std::swap;

      swap(first._enhancedVRFeature, second._enhancedVRFeature);
      swap(first._enhancedVRAvailability, second._enhancedVRAvailability);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   EnhancedVoiceRecognitionFeature& EnhancedVoiceRecognitionFeature::operator=(EnhancedVoiceRecognitionFeature other)
   {
      swap(*this, other);

      return *this;
   }

   bool EnhancedVoiceRecognitionFeature::operator==(const EnhancedVoiceRecognitionFeature& rhs) const
   {
      return ((this->_enhancedVRFeature == rhs._enhancedVRFeature)
            && (this->_enhancedVRAvailability == rhs._enhancedVRAvailability));
   }

   bool EnhancedVoiceRecognitionFeature::operator!=(const EnhancedVoiceRecognitionFeature& rhs) const
   {
      return (!((this->_enhancedVRFeature == rhs._enhancedVRFeature)
            && (this->_enhancedVRAvailability == rhs._enhancedVRAvailability)));
   }
}
