/**
 * @file DeviceRingtoneList.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the DeviceRingtoneList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef DeviceRingtoneList_h
#define DeviceRingtoneList_h

#include "DeviceRingtone.h"

namespace pmcore
{
   class DeviceRingtoneList
   {
   public:
      /**
       * Constructor of DeviceRingtoneList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      DeviceRingtoneList();

      /**
       * Parameterized Constructor of DeviceRingtoneList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      DeviceRingtoneList(const DeviceRingtoneListType deviceRingtoneList);

      /**
       * Copy Constructor of DeviceRingtoneList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      DeviceRingtoneList(const DeviceRingtoneList& other);

      /**
       * Destructor of DeviceRingtoneList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~DeviceRingtoneList();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(DeviceRingtoneList& first, DeviceRingtoneList& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      DeviceRingtoneList& operator=(DeviceRingtoneList other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const DeviceRingtoneList& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const DeviceRingtoneList& rhs) const;

      DeviceRingtoneListType _deviceRingtoneList; /**< device ringtone list */
   };

} // namespace pmcore

#endif // DeviceRingtoneList_h
