/**
 * @file DeviceRingtone.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the DeviceRingtone class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef DeviceRingtone_h
#define DeviceRingtone_h

#include "PmInterfaceTypesInternal.h"
#include <vector>

namespace pmcore
{
   class DeviceRingtone
   {
   public:
      /**
       * Constructor of DeviceRingtone class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      DeviceRingtone();

      /**
       * Parameterized Constructor of DeviceRingtone class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      DeviceRingtone(const BdAddress deviceAddress, const RingtoneId ringtoneId, const RingtoneName ringtoneName,
            const InbandRingingSupport inbandRingingSupport);

      /**
       * Copy Constructor of DeviceRingtone class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      DeviceRingtone(const DeviceRingtone& other);

      /**
       * Destructor of DeviceRingtone class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      ~DeviceRingtone();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      friend void swap(DeviceRingtone& first, DeviceRingtone& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      DeviceRingtone& operator=(DeviceRingtone other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      bool operator==(const DeviceRingtone& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       */
      bool operator!=(const DeviceRingtone& rhs) const;

      BdAddress            _deviceAddress;        /**< device address */
      RingtoneId           _ringtoneId;           /**< ringtone id */
      RingtoneName         _ringtoneName;         /**< ringtone name */
      InbandRingingSupport _inbandRingingSupport; /**< inband ringing supported status */
   };

   typedef std::vector<DeviceRingtone> DeviceRingtoneListType; /**< device ringtone list */

} // namespace pmcore

#endif // DeviceRingtone_h
