/**
 * @file DeviceIdentification.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the MsgTypes between IpcWrapper and CPP layer
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef DeviceIdentification_h
#define DeviceIdentification_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{

#define VENDOR_ID_INVALID (unsigned short int)0x00
#define VENDOR_ID_SOURCE_INVALID (unsigned short int)0x00

class DeviceIdentification
{
public:
   /**
    * Constructor of DeviceIdentification class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   DeviceIdentification();

   /**
    * Destructor of DeviceIdentification class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~DeviceIdentification();

   /**
    * Parameterized constructor of DeviceIdentification class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   DeviceIdentification(unsigned short int vendorId, unsigned short int vendorIdSource);

   /**
    * Copy constructor of DeviceIdentification class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   DeviceIdentification(const DeviceIdentification& deviceIdentification);

   /**
    * Friend function used when copying the object.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   friend void swap(DeviceIdentification& first, DeviceIdentification& second);

   /**
    * Overloading '=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
   DeviceIdentification& operator=(DeviceIdentification deviceIdentification);

   /**
    * Overloading '==' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator==(const DeviceIdentification& rhs) const;

   unsigned short int _vendorId;
   unsigned short int _vendorIdSource;

   void printDeviceIdentificationInfo();
};

} // namespace pmcore

#endif // #define DeviceIdentification_h
