/**
 * @file CallStatusList.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the CallStatusList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef CallStatusList_h
#define CallStatusList_h

#include "CallStatus.h"

namespace pmcore
{
   class CallStatusList
   {
   public:
      /**
       * Constructor of CallStatusList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      CallStatusList();

      /**
       * Parameterized Constructor of CallStatusList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      CallStatusList(const CallStatusListMap callStatusList);

      /**
       * Copy Constructor of CallStatusList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      CallStatusList(const CallStatusList& other);

      /**
       * Destructor of CallStatusList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~CallStatusList();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(CallStatusList& first, CallStatusList& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      CallStatusList& operator=(CallStatusList other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const CallStatusList& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const CallStatusList& rhs) const;

      CallStatusListMap _callStatusList; /**< call status list */
   };

} // namespace pmcore

#endif // CallStatusList_h
