/**
 * @file CallInfo.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the CallInfo class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef CallInfo_h
#define CallInfo_h

#include "PmInterfaceTypesInternal.h"
#include <vector>

namespace pmcore
{
   class CallInfo
   {
   public:
      /**
       * Constructor of CallInfo class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      CallInfo();

      /**
       * Copy Constructor of CallInfo class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      CallInfo(const CallInfo& other);

      /**
       * Destructor of CallInfo class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~CallInfo();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(CallInfo& first, CallInfo& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      CallInfo& operator=(CallInfo other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const CallInfo& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const CallInfo& rhs) const;

      /**
       * Prints the call info
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      void printCallInfo();

      CallInstance    _instance;        /**< call instance */
      CallState       _state;           /**< call state */
      Duration        _durationHr;      /**< call duration in hours */
      Duration        _durationMin;     /**< call duration in minutes */
      Duration        _durationSec;     /**< call duration in seconds */
      TelephoneNumber _telephoneNumber; /**< telephone number */
      CallMode        _mode;            /**< call mode */
      NumberType      _type;            /**< call number type */
      CallDirection   _direction;       /**< call direction */
   };

   typedef std::vector<CallInfo> CallInfoList; /**< call info list */

} // namespace pmcore

#endif // CallInfo_h
