/**
 * @file CallInfo.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the CallInfo class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "CallInfo.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/CallInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   CallInfo::CallInfo() :
         _instance(CALL_INSTANCE_DEFAULT),
         _state(""),
         _durationHr(CALL_DURATION_DEFAULT),
         _durationMin(CALL_DURATION_DEFAULT),
         _durationSec(CALL_DURATION_DEFAULT),
         _telephoneNumber(""),
         _mode(CALL_MODE_UNKNOWN),
         _type(NUMBER_TYPE_UNKNOWN),
         _direction(CALL_DIRECTION_UNKNOWN)
   {
   }

   CallInfo::CallInfo(const CallInfo& other) :
         _instance(other._instance),
         _state(other._state),
         _durationHr(other._durationHr),
         _durationMin(other._durationMin),
         _durationSec(other._durationSec),
         _telephoneNumber(other._telephoneNumber),
         _mode(other._mode),
         _type(other._type),
         _direction(other._direction)
   {
   }

   CallInfo::~CallInfo()
   {
   }

   void swap(CallInfo& first, CallInfo& second)
   {
      using std::swap;

      swap(first._instance, second._instance);
      swap(first._state, second._state);
      swap(first._durationHr, second._durationHr);
      swap(first._durationMin, second._durationMin);
      swap(first._durationSec, second._durationSec);
      swap(first._telephoneNumber, second._telephoneNumber);
      swap(first._mode, second._mode);
      swap(first._type, second._type);
      swap(first._direction, second._direction);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   CallInfo& CallInfo::operator=(CallInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool CallInfo::operator==(const CallInfo& rhs) const
   {
      return ((this->_instance == rhs._instance)
            && (this->_state == rhs._state)
            && (this->_durationHr == rhs._durationHr)
            && (this->_durationMin == rhs._durationMin)
            && (this->_durationSec == rhs._durationSec)
            && (this->_telephoneNumber == rhs._telephoneNumber)
            && (this->_mode == rhs._mode)
            && (this->_type == rhs._type)
            && (this->_direction == rhs._direction));
   }

   bool CallInfo::operator!=(const CallInfo& rhs) const
   {
      return (!((this->_instance == rhs._instance)
            && (this->_state == rhs._state)
            && (this->_durationHr == rhs._durationHr)
            && (this->_durationMin == rhs._durationMin)
            && (this->_durationSec == rhs._durationSec)
            && (this->_telephoneNumber == rhs._telephoneNumber)
            && (this->_mode == rhs._mode)
            && (this->_type == rhs._type)
            && (this->_direction == rhs._direction)));
   }

   void CallInfo::printCallInfo()
   {
      ETG_TRACE_USR4(("printCallInfo::_instance: %u", _instance));
      ETG_TRACE_USR4(("printCallInfo::_state: %s", _state.c_str()));
      ETG_TRACE_USR4(("printCallInfo::_durationHr: %u", _durationHr));
      ETG_TRACE_USR4(("printCallInfo::_durationMin: %u", _durationMin));
      ETG_TRACE_USR4(("printCallInfo::_durationSec: %u", _durationSec));
      ETG_TRACE_USR4(("printCallInfo::_telephoneNumber: %s", _telephoneNumber.c_str()));
      ETG_TRACE_USR4(("printCallInfo::_mode: %u", ETG_CENUM(CallModeEnumType, _mode)));
      ETG_TRACE_USR4(("printCallInfo::_type: %u", ETG_CENUM(NumberTypeEnumType, _type)));
      ETG_TRACE_USR4(("printCallInfo::_direction: %u", ETG_CENUM(CallDirectionEnumType, _direction)));
   }
}
