/**
 * @file BasicDeviceDetails.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the MsgTypes between IpcWrapper and CPP layer
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup IpcWrapper
 */

#ifndef BasicDeviceDetails_h
#define BasicDeviceDetails_h

#include "PmInterfaceTypesInternal.h"
#include "DeviceIdentification.h"

namespace pmcore
{

class BasicDeviceDetails
{
public:
   /**
    * Constructor of BasicDeviceDetails class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   BasicDeviceDetails();

   /**
    * Destructor of BasicDeviceDetails class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   ~BasicDeviceDetails();

   /**
    * Parameterized constructor of BasicDeviceDetails class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   BasicDeviceDetails(const BdAddress& deviceAddress, const DeviceHandle deviceHandle,
         const DeviceIdentification& deviceIdentification);

   /**
    * Copy constructor of BasicDeviceDetails class
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   BasicDeviceDetails(const BasicDeviceDetails& other);

   /**
    * Friend function used when copying the object.
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   friend void swap(BasicDeviceDetails& first, BasicDeviceDetails& second);

   /**
    * Overloading '=' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
   BasicDeviceDetails& operator=(BasicDeviceDetails other);

   /**
    * Overloading '==' operator
    *
    * @param[in]
    * @param[out]
    * @param[in,out]
    *
    * @return
    *
    */
   bool operator==(const BasicDeviceDetails& rhs) const;

   std::string _deviceAddress;
   unsigned char _deviceHandle;
   DeviceIdentification _deviceIdentification;

   void printDeviceIdentity();
};

typedef std::vector<BasicDeviceDetails> BasicDeviceDetailsList;

} // namespace pmccore

#endif // #define BasicDeviceDetails_h
