/**
 * @file BTSVoiceCallInfo.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the BTSVoiceCallInfo class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "BTSVoiceCallInfo.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BTSVoiceCallInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   BTSVoiceCallInfo::BTSVoiceCallInfo() :
         _callInfo(),
         _contactName(""),
         _multiparty(false),
         _emergency(false)
   {
   }

   BTSVoiceCallInfo::BTSVoiceCallInfo(const CallInfo callInfo, const ContactName& contactName,
         const Multiparty multiparty, const Emergency emergency) :
         _callInfo(callInfo),
         _contactName(contactName),
         _multiparty(multiparty),
         _emergency(emergency)
   {
   }

   BTSVoiceCallInfo::BTSVoiceCallInfo(const BTSVoiceCallInfo& other) :
         _callInfo(other._callInfo),
         _contactName(other._contactName),
         _multiparty(other._multiparty),
         _emergency(other._emergency)
   {
   }

   BTSVoiceCallInfo::~BTSVoiceCallInfo()
   {
   }

   void swap(BTSVoiceCallInfo& first, BTSVoiceCallInfo& second)
   {
      using std::swap;

      swap(first._callInfo, second._callInfo);
      swap(first._contactName, second._contactName);
      swap(first._multiparty, second._multiparty);
      swap(first._emergency, second._emergency);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BTSVoiceCallInfo& BTSVoiceCallInfo::operator=(BTSVoiceCallInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool BTSVoiceCallInfo::operator==(const BTSVoiceCallInfo& rhs) const
   {
      return ((this->_callInfo == rhs._callInfo)
            && (this->_contactName == rhs._contactName)
            && (this->_multiparty == rhs._multiparty)
            && (this->_emergency == rhs._emergency));
   }

   bool BTSVoiceCallInfo::operator!=(const BTSVoiceCallInfo& rhs) const
   {
      return (!((this->_callInfo == rhs._callInfo)
            && (this->_contactName == rhs._contactName)
            && (this->_multiparty == rhs._multiparty)
            && (this->_emergency == rhs._emergency)));
   }
}
