/**
 * @file ActivePassiveDeviceList.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the ActivePassiveDeviceList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#ifndef ActivePassiveDeviceList_h
#define ActivePassiveDeviceList_h

#include "PmInterfaceTypesInternal.h"

namespace pmcore
{
   class ActivePassiveDeviceList
   {
   public:
      /**
       * Constructor of ActivePassiveDeviceList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ActivePassiveDeviceList();

      /**
       * Parameterized Constructor of ActivePassiveDeviceList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ActivePassiveDeviceList(const ActivePassiveDeviceListMap activePassiveDeviceList);

      /**
       * Copy Constructor of ActivePassiveDeviceList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ActivePassiveDeviceList(const ActivePassiveDeviceList& other);

      /**
       * Destructor of ActivePassiveDeviceList class
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      ~ActivePassiveDeviceList();

      /**
       * Friend function used when copying the object.
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      friend void swap(ActivePassiveDeviceList& first, ActivePassiveDeviceList& second);

      /**
       * Overloading '=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      ActivePassiveDeviceList& operator=(ActivePassiveDeviceList other);

      /**
       * Overloading '==' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator==(const ActivePassiveDeviceList& rhs) const;

      /**
       * Overloading '!=' operator
       *
       * @param[in]
       * @param[out]
       * @param[in,out]
       *
       * @return
       *
       */
      bool operator!=(const ActivePassiveDeviceList& rhs) const;

      ActivePassiveDeviceListMap _activePassiveDeviceList; /**< active passive device list map */
   };

} // namespace pmcore

#endif // ActivePassiveDeviceList_h
