/**
 * @file ActivePassiveDeviceList.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the type definition of the ActivePassiveDeviceList class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 */

#include "ActivePassiveDeviceList.h"
#include "PmAppTrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ActivePassiveDeviceList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PM_CORE
#endif
#endif

namespace pmcore
{
   ActivePassiveDeviceList::ActivePassiveDeviceList() : _activePassiveDeviceList()
   {
   }

   ActivePassiveDeviceList::ActivePassiveDeviceList(const ActivePassiveDeviceListMap activePassiveDeviceList) :
         _activePassiveDeviceList(activePassiveDeviceList)
   {
   }

   ActivePassiveDeviceList::ActivePassiveDeviceList(const ActivePassiveDeviceList& other) :
         _activePassiveDeviceList(other._activePassiveDeviceList)
   {
   }

   ActivePassiveDeviceList::~ActivePassiveDeviceList()
   {
   }

   void swap(ActivePassiveDeviceList& first, ActivePassiveDeviceList& second)
   {
      using std::swap;

      swap(first._activePassiveDeviceList, second._activePassiveDeviceList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   ActivePassiveDeviceList& ActivePassiveDeviceList::operator=(ActivePassiveDeviceList other)
   {
      swap(*this, other);

      return *this;
   }

   bool ActivePassiveDeviceList::operator==(const ActivePassiveDeviceList& rhs) const
   {
      return ((this->_activePassiveDeviceList == rhs._activePassiveDeviceList));
   }

   bool ActivePassiveDeviceList::operator!=(const ActivePassiveDeviceList& rhs) const
   {
      return (!(this->_activePassiveDeviceList == rhs._activePassiveDeviceList));
   }
}
