/* *
 * @file PmCallStateHandlerSm.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Generated code from PmCallStateHandlerSm.sct
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup PmCore
 * */

#include "PmCallStateHandlerSm.h"

/*! \file Implementation of the state machine 'PmCallStateHandlerSm'
*/




PmCallStateHandlerSm::PmCallStateHandlerSm()  :
ifaceTraceObserver(0),
stateConfVectorPosition(0),
ifaceUserAction(this),
ifaceUserAction_OCB(sc_null),
ifaceAgCallStateUpdate(this),
ifaceAgCallStateUpdate_OCB(sc_null),
ifaceAgAudioUpdate(this),
ifaceSmHandler(this),
ifaceSmHandler_OCB(sc_null),
ifaceAudioManagerRequest(this),
ifaceAudioManagerRequest_OCB(sc_null),
ifaceAudioManagerResponse(this),
ifaceAgResponse(this),
ifaceAgResponse_OCB(sc_null),
ifaceTimerUpdate(this),
ifaceTimerUpdate_OCB(sc_null),
ifaceInternalSCI(this),
isRunningCycle(false)
{
}

PmCallStateHandlerSm::~PmCallStateHandlerSm()
{
}


using namespace pmcallstatehandlersm_events;

SctEvent* PmCallStateHandlerSm::getNextEvent()
{
	SctEvent* nextEvent = 0;
	
	if(!internalEventQueue.empty()) {
		nextEvent = internalEventQueue.front();
		internalEventQueue.pop_front();
	}
	else if(!inEventQueue.empty()) {
		nextEvent = inEventQueue.front();
		inEventQueue.pop_front();
	}
	
	return nextEvent;
}

void PmCallStateHandlerSm::dispatch_event(SctEvent * event)
{
	if(event == 0) {
		return;
	}
	switch(event->name)
	{
		case SCI_UserAction_DIAL_CALL:
		case SCI_UserAction_ACCEPT_CALL:
		case SCI_UserAction_SPEED_DIAL:
		case SCI_UserAction_REDIAL:
		case SCI_UserAction_HANGUP_CALLS:
		case SCI_UserAction_HANGUP_ALL_CALLS:
		case SCI_UserAction_SWAP_CALLS:
		case SCI_UserAction_SPLIT_CALLS:
		case SCI_UserAction_CONFERENCE_CALL:
		case SCI_UserAction_TRANSFER_AUDIO_TO_AG:
		case SCI_UserAction_TRANSFER_AUDIO_TO_HF:
		case SCI_UserAction_MUTE_RINGTONE:
		case SCI_UserAction_START_WAITING_MODE:
		case SCI_UserAction_STOP_WAITING_MODE:
		case SCI_UserAction_ACCEPT_CALL_BY_ACQUIRING_CH:
		{
			ifaceUserAction.dispatch_event(event);
			break;
		}
		case SCI_AgCallStateUpdate_IDLE:
		case SCI_AgCallStateUpdate_INCOMING:
		case SCI_AgCallStateUpdate_INCOMING_INBAND:
		case SCI_AgCallStateUpdate_DIALING:
		case SCI_AgCallStateUpdate_HELD:
		case SCI_AgCallStateUpdate_ACTIVE:
		case SCI_AgCallStateUpdate_CALL_DISCONNECTING:
		case SCI_AgCallStateUpdate_CALL_DISCONNECTED:
		case SCI_AgCallStateUpdate_CALL_X_DIALING:
		case SCI_AgCallStateUpdate_CALL_X_WAITING:
		case SCI_AgCallStateUpdate_CALLS_SWAPPABLE:
		case SCI_AgCallStateUpdate_CALLS_CONFERENCE:
		case SCI_AgCallStateUpdate_ALL_CALLS_DISCONNECTED:
		{
			ifaceAgCallStateUpdate.dispatch_event(event);
			break;
		}
		case SCI_AgAudioUpdate_SCO_CONNECTED:
		case SCI_AgAudioUpdate_SCO_PAUSED:
		case SCI_AgAudioUpdate_SCO_DISCONNECTED:
		{
			ifaceAgAudioUpdate.dispatch_event(event);
			break;
		}
		case SCI_SmHandler_SWITCH_TO_PASSIVE:
		case SCI_SmHandler_SWITCH_TO_ACTIVE:
		{
			ifaceSmHandler.dispatch_event(event);
			break;
		}
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED:
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED:
		case SCI_AudioManagerResponse_PHONE_CHANNEL_GRANTED:
		case SCI_AudioManagerResponse_PHONE_CHANNEL_DENIED:
		case SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_GRANTED:
		case SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_DENIED:
		case SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS:
		case SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE:
		case SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS:
		case SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE:
		case SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS:
		case SCI_AudioManagerResponse_STOP_AUDIO_FAILURE:
		case SCI_AudioManagerResponse_PHONE_CHANNEL_RELEASED:
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED:
		case SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_RELEASED:
		{
			ifaceAudioManagerResponse.dispatch_event(event);
			break;
		}
		case SCI_AgResponse_ACCEPT_OK:
		case SCI_AgResponse_DIAL_OK:
		case SCI_AgResponse_HOLD_INCOMING_OK:
		case SCI_AgResponse_HANGUP_OK:
		case SCI_AgResponse_CONF_OK:
		case SCI_AgResponse_SWAP_OK:
		case SCI_AgResponse_SPLIT_OK:
		case SCI_AgResponse_SPEED_DIAL_OK:
		case SCI_AgResponse_ACCEPT_SCO_CONNECT_OK:
		case SCI_AgResponse_GET_CALLS_OK:
		case SCI_AgResponse_REDIAL_OK:
		case SCI_AgResponse_TRANSFER_OK:
		case SCI_AgResponse_RELEASE_AND_ACCEPT_OK:
		case SCI_AgResponse_RELEASE_AND_SWAP_OK:
		case SCI_AgResponse_HOLD_AND_ACCEPT_OK:
		case SCI_AgResponse_HANGUP_ALL_OK:
		case SCI_AgResponse_HANGUP_MULTIPARTY_OK:
		case SCI_AgResponse_SEND_DTMF_OK:
		case SCI_AgResponse_DEFAULT_ERROR:
		case SCI_AgResponse_ACCEPT_ERROR:
		case SCI_AgResponse_DIAL_ERROR:
		case SCI_AgResponse_HOLD_INCOMING_ERROR:
		case SCI_AgResponse_SPEED_DIAL_ERROR:
		case SCI_AgResponse_ACCEPT_SCO_CONNECT_ERROR:
		case SCI_AgResponse_GET_CALLS_ERROR:
		case SCI_AgResponse_REDIAL_ERROR:
		case SCI_AgResponse_TRANSFER_ERROR:
		case SCI_AgResponse_RELEASE_AND_ACCEPT_ERROR:
		case SCI_AgResponse_RELEASE_AND_SWAP_ERROR:
		case SCI_AgResponse_HOLD_AND_ACCEPT_ERROR:
		case SCI_AgResponse_SEND_DTMF_ERROR:
		{
			ifaceAgResponse.dispatch_event(event);
			break;
		}
		case SCI_TimerUpdate_TIMER_CALLBACK:
		{
			ifaceTimerUpdate.dispatch_event(event);
			break;
		}
		case InternalSCI_CHECK_AUDIO:
		case InternalSCI_GENERATE_CALL_STATE_EVENT:
		case InternalSCI_TO_START_WAITING_MODE:
		case InternalSCI_MOVE_TO_NEXT_STATE:
		{
			ifaceInternalSCI.dispatch_event(event);
			break;
		}
		default:
			break;
	}
}

void PmCallStateHandlerSm::SCI_UserAction::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_UserAction_DIAL_CALL:
		{
			SctEvent_SCI_UserAction_DIAL_CALL * e = static_cast<SctEvent_SCI_UserAction_DIAL_CALL*>(event);
			if(e != 0) {
				internal_raise_dIAL_CALL(e->value);
			}
			break;
		}
		case SCI_UserAction_ACCEPT_CALL:
		{
			SctEvent_SCI_UserAction_ACCEPT_CALL * e = static_cast<SctEvent_SCI_UserAction_ACCEPT_CALL*>(event);
			if(e != 0) {
				internal_raise_aCCEPT_CALL(e->value);
			}
			break;
		}
		case SCI_UserAction_SPEED_DIAL:
		{
			SctEvent_SCI_UserAction_SPEED_DIAL * e = static_cast<SctEvent_SCI_UserAction_SPEED_DIAL*>(event);
			if(e != 0) {
				internal_raise_sPEED_DIAL(e->value);
			}
			break;
		}
		case SCI_UserAction_REDIAL:
		{
			SctEvent_SCI_UserAction_REDIAL * e = static_cast<SctEvent_SCI_UserAction_REDIAL*>(event);
			if(e != 0) {
				internal_raise_rEDIAL(e->value);
			}
			break;
		}
		case SCI_UserAction_HANGUP_CALLS:
		{
			SctEvent_SCI_UserAction_HANGUP_CALLS * e = static_cast<SctEvent_SCI_UserAction_HANGUP_CALLS*>(event);
			if(e != 0) {
				internal_raise_hANGUP_CALLS(e->value);
			}
			break;
		}
		case SCI_UserAction_HANGUP_ALL_CALLS:
		{
			SctEvent_SCI_UserAction_HANGUP_ALL_CALLS * e = static_cast<SctEvent_SCI_UserAction_HANGUP_ALL_CALLS*>(event);
			if(e != 0) {
				internal_raise_hANGUP_ALL_CALLS(e->value);
			}
			break;
		}
		case SCI_UserAction_SWAP_CALLS:
		{
			SctEvent_SCI_UserAction_SWAP_CALLS * e = static_cast<SctEvent_SCI_UserAction_SWAP_CALLS*>(event);
			if(e != 0) {
				internal_raise_sWAP_CALLS(e->value);
			}
			break;
		}
		case SCI_UserAction_SPLIT_CALLS:
		{
			SctEvent_SCI_UserAction_SPLIT_CALLS * e = static_cast<SctEvent_SCI_UserAction_SPLIT_CALLS*>(event);
			if(e != 0) {
				internal_raise_sPLIT_CALLS(e->value);
			}
			break;
		}
		case SCI_UserAction_CONFERENCE_CALL:
		{
			SctEvent_SCI_UserAction_CONFERENCE_CALL * e = static_cast<SctEvent_SCI_UserAction_CONFERENCE_CALL*>(event);
			if(e != 0) {
				internal_raise_cONFERENCE_CALL(e->value);
			}
			break;
		}
		case SCI_UserAction_TRANSFER_AUDIO_TO_AG:
		{
			SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_AG * e = static_cast<SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_AG*>(event);
			if(e != 0) {
				internal_raise_tRANSFER_AUDIO_TO_AG(e->value);
			}
			break;
		}
		case SCI_UserAction_TRANSFER_AUDIO_TO_HF:
		{
			SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_HF * e = static_cast<SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_HF*>(event);
			if(e != 0) {
				internal_raise_tRANSFER_AUDIO_TO_HF(e->value);
			}
			break;
		}
		case SCI_UserAction_MUTE_RINGTONE:
		{
			SctEvent_SCI_UserAction_MUTE_RINGTONE * e = static_cast<SctEvent_SCI_UserAction_MUTE_RINGTONE*>(event);
			if(e != 0) {
				internal_raise_mUTE_RINGTONE(e->value);
			}
			break;
		}
		case SCI_UserAction_START_WAITING_MODE:
		{
			internal_raise_sTART_WAITING_MODE();
			break;
		}
		case SCI_UserAction_STOP_WAITING_MODE:
		{
			internal_raise_sTOP_WAITING_MODE();
			break;
		}
		case SCI_UserAction_ACCEPT_CALL_BY_ACQUIRING_CH:
		{
			SctEvent_SCI_UserAction_ACCEPT_CALL_BY_ACQUIRING_CH * e = static_cast<SctEvent_SCI_UserAction_ACCEPT_CALL_BY_ACQUIRING_CH*>(event);
			if(e != 0) {
				internal_raise_aCCEPT_CALL_BY_ACQUIRING_CH(e->value);
			}
			break;
		}
		default:
			break;
	}
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AgCallStateUpdate_IDLE:
		{
			internal_raise_iDLE();
			break;
		}
		case SCI_AgCallStateUpdate_INCOMING:
		{
			internal_raise_iNCOMING();
			break;
		}
		case SCI_AgCallStateUpdate_INCOMING_INBAND:
		{
			internal_raise_iNCOMING_INBAND();
			break;
		}
		case SCI_AgCallStateUpdate_DIALING:
		{
			internal_raise_dIALING();
			break;
		}
		case SCI_AgCallStateUpdate_HELD:
		{
			internal_raise_hELD();
			break;
		}
		case SCI_AgCallStateUpdate_ACTIVE:
		{
			internal_raise_aCTIVE();
			break;
		}
		case SCI_AgCallStateUpdate_CALL_DISCONNECTING:
		{
			internal_raise_cALL_DISCONNECTING();
			break;
		}
		case SCI_AgCallStateUpdate_CALL_DISCONNECTED:
		{
			internal_raise_cALL_DISCONNECTED();
			break;
		}
		case SCI_AgCallStateUpdate_CALL_X_DIALING:
		{
			internal_raise_cALL_X_DIALING();
			break;
		}
		case SCI_AgCallStateUpdate_CALL_X_WAITING:
		{
			internal_raise_cALL_X_WAITING();
			break;
		}
		case SCI_AgCallStateUpdate_CALLS_SWAPPABLE:
		{
			internal_raise_cALLS_SWAPPABLE();
			break;
		}
		case SCI_AgCallStateUpdate_CALLS_CONFERENCE:
		{
			internal_raise_cALLS_CONFERENCE();
			break;
		}
		case SCI_AgCallStateUpdate_ALL_CALLS_DISCONNECTED:
		{
			internal_raise_aLL_CALLS_DISCONNECTED();
			break;
		}
		default:
			break;
	}
}
void PmCallStateHandlerSm::SCI_AgAudioUpdate::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AgAudioUpdate_SCO_CONNECTED:
		{
			SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED * e = static_cast<SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED*>(event);
			if(e != 0) {
				internal_raise_sCO_CONNECTED(e->value);
			}
			break;
		}
		case SCI_AgAudioUpdate_SCO_PAUSED:
		{
			SctEvent_SCI_AgAudioUpdate_SCO_PAUSED * e = static_cast<SctEvent_SCI_AgAudioUpdate_SCO_PAUSED*>(event);
			if(e != 0) {
				internal_raise_sCO_PAUSED(e->value);
			}
			break;
		}
		case SCI_AgAudioUpdate_SCO_DISCONNECTED:
		{
			SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED * e = static_cast<SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED*>(event);
			if(e != 0) {
				internal_raise_sCO_DISCONNECTED(e->value);
			}
			break;
		}
		default:
			break;
	}
}
void PmCallStateHandlerSm::SCI_SmHandler::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_SmHandler_SWITCH_TO_PASSIVE:
		{
			internal_raise_sWITCH_TO_PASSIVE();
			break;
		}
		case SCI_SmHandler_SWITCH_TO_ACTIVE:
		{
			internal_raise_sWITCH_TO_ACTIVE();
			break;
		}
		default:
			break;
	}
}
void PmCallStateHandlerSm::SCI_AudioManagerRequest::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		default:
			break;
	}
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED:
		{
			internal_raise_rINGTONE_CHANNEL_GRANTED();
			break;
		}
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED:
		{
			internal_raise_rINGTONE_CHANNEL_DENIED();
			break;
		}
		case SCI_AudioManagerResponse_PHONE_CHANNEL_GRANTED:
		{
			internal_raise_pHONE_CHANNEL_GRANTED();
			break;
		}
		case SCI_AudioManagerResponse_PHONE_CHANNEL_DENIED:
		{
			internal_raise_pHONE_CHANNEL_DENIED();
			break;
		}
		case SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_GRANTED:
		{
			internal_raise_wAITINGMODE_CHANNEL_GRANTED();
			break;
		}
		case SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_DENIED:
		{
			internal_raise_wAITINGMODE_CHANNEL_DENIED();
			break;
		}
		case SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS:
		{
			internal_raise_pLAY_AUDIO_SUCCESS();
			break;
		}
		case SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE:
		{
			internal_raise_pLAY_AUDIO_FAILURE();
			break;
		}
		case SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS:
		{
			internal_raise_pAUSE_AUDIO_SUCCESS();
			break;
		}
		case SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE:
		{
			internal_raise_pAUSE_AUDIO_FAILURE();
			break;
		}
		case SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS:
		{
			internal_raise_sTOP_AUDIO_SUCCESS();
			break;
		}
		case SCI_AudioManagerResponse_STOP_AUDIO_FAILURE:
		{
			internal_raise_sTOP_AUDIO_FAILURE();
			break;
		}
		case SCI_AudioManagerResponse_PHONE_CHANNEL_RELEASED:
		{
			internal_raise_pHONE_CHANNEL_RELEASED();
			break;
		}
		case SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED:
		{
			internal_raise_rINGTONE_CHANNEL_RELEASED();
			break;
		}
		case SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_RELEASED:
		{
			internal_raise_wAITINGMODE_CHANNEL_RELEASED();
			break;
		}
		default:
			break;
	}
}
void PmCallStateHandlerSm::SCI_AgResponse::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_AgResponse_ACCEPT_OK:
		{
			internal_raise_aCCEPT_OK();
			break;
		}
		case SCI_AgResponse_DIAL_OK:
		{
			internal_raise_dIAL_OK();
			break;
		}
		case SCI_AgResponse_HOLD_INCOMING_OK:
		{
			internal_raise_hOLD_INCOMING_OK();
			break;
		}
		case SCI_AgResponse_HANGUP_OK:
		{
			internal_raise_hANGUP_OK();
			break;
		}
		case SCI_AgResponse_CONF_OK:
		{
			internal_raise_cONF_OK();
			break;
		}
		case SCI_AgResponse_SWAP_OK:
		{
			internal_raise_sWAP_OK();
			break;
		}
		case SCI_AgResponse_SPLIT_OK:
		{
			internal_raise_sPLIT_OK();
			break;
		}
		case SCI_AgResponse_SPEED_DIAL_OK:
		{
			internal_raise_sPEED_DIAL_OK();
			break;
		}
		case SCI_AgResponse_ACCEPT_SCO_CONNECT_OK:
		{
			internal_raise_aCCEPT_SCO_CONNECT_OK();
			break;
		}
		case SCI_AgResponse_GET_CALLS_OK:
		{
			internal_raise_gET_CALLS_OK();
			break;
		}
		case SCI_AgResponse_REDIAL_OK:
		{
			internal_raise_rEDIAL_OK();
			break;
		}
		case SCI_AgResponse_TRANSFER_OK:
		{
			internal_raise_tRANSFER_OK();
			break;
		}
		case SCI_AgResponse_RELEASE_AND_ACCEPT_OK:
		{
			internal_raise_rELEASE_AND_ACCEPT_OK();
			break;
		}
		case SCI_AgResponse_RELEASE_AND_SWAP_OK:
		{
			internal_raise_rELEASE_AND_SWAP_OK();
			break;
		}
		case SCI_AgResponse_HOLD_AND_ACCEPT_OK:
		{
			internal_raise_hOLD_AND_ACCEPT_OK();
			break;
		}
		case SCI_AgResponse_HANGUP_ALL_OK:
		{
			internal_raise_hANGUP_ALL_OK();
			break;
		}
		case SCI_AgResponse_HANGUP_MULTIPARTY_OK:
		{
			internal_raise_hANGUP_MULTIPARTY_OK();
			break;
		}
		case SCI_AgResponse_SEND_DTMF_OK:
		{
			internal_raise_sEND_DTMF_OK();
			break;
		}
		case SCI_AgResponse_DEFAULT_ERROR:
		{
			internal_raise_dEFAULT_ERROR();
			break;
		}
		case SCI_AgResponse_ACCEPT_ERROR:
		{
			SctEvent_SCI_AgResponse_ACCEPT_ERROR * e = static_cast<SctEvent_SCI_AgResponse_ACCEPT_ERROR*>(event);
			if(e != 0) {
				internal_raise_aCCEPT_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_DIAL_ERROR:
		{
			SctEvent_SCI_AgResponse_DIAL_ERROR * e = static_cast<SctEvent_SCI_AgResponse_DIAL_ERROR*>(event);
			if(e != 0) {
				internal_raise_dIAL_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_HOLD_INCOMING_ERROR:
		{
			SctEvent_SCI_AgResponse_HOLD_INCOMING_ERROR * e = static_cast<SctEvent_SCI_AgResponse_HOLD_INCOMING_ERROR*>(event);
			if(e != 0) {
				internal_raise_hOLD_INCOMING_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_SPEED_DIAL_ERROR:
		{
			SctEvent_SCI_AgResponse_SPEED_DIAL_ERROR * e = static_cast<SctEvent_SCI_AgResponse_SPEED_DIAL_ERROR*>(event);
			if(e != 0) {
				internal_raise_sPEED_DIAL_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_ACCEPT_SCO_CONNECT_ERROR:
		{
			SctEvent_SCI_AgResponse_ACCEPT_SCO_CONNECT_ERROR * e = static_cast<SctEvent_SCI_AgResponse_ACCEPT_SCO_CONNECT_ERROR*>(event);
			if(e != 0) {
				internal_raise_aCCEPT_SCO_CONNECT_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_GET_CALLS_ERROR:
		{
			SctEvent_SCI_AgResponse_GET_CALLS_ERROR * e = static_cast<SctEvent_SCI_AgResponse_GET_CALLS_ERROR*>(event);
			if(e != 0) {
				internal_raise_gET_CALLS_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_REDIAL_ERROR:
		{
			SctEvent_SCI_AgResponse_REDIAL_ERROR * e = static_cast<SctEvent_SCI_AgResponse_REDIAL_ERROR*>(event);
			if(e != 0) {
				internal_raise_rEDIAL_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_TRANSFER_ERROR:
		{
			SctEvent_SCI_AgResponse_TRANSFER_ERROR * e = static_cast<SctEvent_SCI_AgResponse_TRANSFER_ERROR*>(event);
			if(e != 0) {
				internal_raise_tRANSFER_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_RELEASE_AND_ACCEPT_ERROR:
		{
			SctEvent_SCI_AgResponse_RELEASE_AND_ACCEPT_ERROR * e = static_cast<SctEvent_SCI_AgResponse_RELEASE_AND_ACCEPT_ERROR*>(event);
			if(e != 0) {
				internal_raise_rELEASE_AND_ACCEPT_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_RELEASE_AND_SWAP_ERROR:
		{
			SctEvent_SCI_AgResponse_RELEASE_AND_SWAP_ERROR * e = static_cast<SctEvent_SCI_AgResponse_RELEASE_AND_SWAP_ERROR*>(event);
			if(e != 0) {
				internal_raise_rELEASE_AND_SWAP_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_HOLD_AND_ACCEPT_ERROR:
		{
			SctEvent_SCI_AgResponse_HOLD_AND_ACCEPT_ERROR * e = static_cast<SctEvent_SCI_AgResponse_HOLD_AND_ACCEPT_ERROR*>(event);
			if(e != 0) {
				internal_raise_hOLD_AND_ACCEPT_ERROR(e->value);
			}
			break;
		}
		case SCI_AgResponse_SEND_DTMF_ERROR:
		{
			SctEvent_SCI_AgResponse_SEND_DTMF_ERROR * e = static_cast<SctEvent_SCI_AgResponse_SEND_DTMF_ERROR*>(event);
			if(e != 0) {
				internal_raise_sEND_DTMF_ERROR(e->value);
			}
			break;
		}
		default:
			break;
	}
}
void PmCallStateHandlerSm::SCI_TimerUpdate::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case SCI_TimerUpdate_TIMER_CALLBACK:
		{
			internal_raise_tIMER_CALLBACK();
			break;
		}
		default:
			break;
	}
}
void PmCallStateHandlerSm::InternalSCI::dispatch_event(SctEvent * event)
{
	switch(event->name)
	{
		case InternalSCI_CHECK_AUDIO:
		{
			internal_raise_cHECK_AUDIO();
			break;
		}
		case InternalSCI_GENERATE_CALL_STATE_EVENT:
		{
			internal_raise_gENERATE_CALL_STATE_EVENT();
			break;
		}
		case InternalSCI_TO_START_WAITING_MODE:
		{
			internal_raise_tO_START_WAITING_MODE();
			break;
		}
		case InternalSCI_MOVE_TO_NEXT_STATE:
		{
			internal_raise_mOVE_TO_NEXT_STATE();
			break;
		}
		default:
			break;
	}
}


void PmCallStateHandlerSm::init()
{
	for (sc_ushort i = 0; i < maxOrthogonalStates; ++i)
		stateConfVector[i] = PmCallStateHandlerSm_last_state;
	
	stateConfVectorPosition = 0;

	clearInEvents();
	clearOutEvents();
	
	/* Default init sequence for statechart PmCallStateHandlerSm */
	ifaceAgCallStateUpdate.callCount = 0;
	ifaceAgAudioUpdate.scoStatus = SCO_NOT_ESTABLISHED;
	ifaceSmHandler.isActiveDevice = true;
	ifaceAudioManagerRequest.phoneAudioState = PHONE_AUDIO_CHANNEL_IDLE;
}

void PmCallStateHandlerSm::enter()
{
	/* Default enter sequence for statechart PmCallStateHandlerSm */
	enseq_Main_region_default();
}

void PmCallStateHandlerSm::exit()
{
	/* Default exit sequence for statechart PmCallStateHandlerSm */
	exseq_Main_region();
}

sc_boolean PmCallStateHandlerSm::isActive() const
{
	return stateConfVector[0] != PmCallStateHandlerSm_last_state;
}

/* 
 * Always returns 'false' since this state machine can never become final.
 */
sc_boolean PmCallStateHandlerSm::isFinal() const
{
   return false;}

void PmCallStateHandlerSm::runCycle()
{
	if (isRunningCycle == false)
	{
		isRunningCycle = true;
		clearOutEvents();
						
		SctEvent * currentEvent = getNextEvent();
		
		do
		{
			/* Set event flags as usual */
			dispatch_event(currentEvent);
			
			for (stateConfVectorPosition = 0;
				stateConfVectorPosition < maxOrthogonalStates;
				stateConfVectorPosition++)
				{
					
				switch (stateConfVector[stateConfVectorPosition])
				{
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall :
				{
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall_react(true);
					break;
				}
				case Main_region_CallHandlerSm_CallHandler_region_Idle :
				{
					Main_region_CallHandlerSm_CallHandler_region_Idle_react(true);
					break;
				}
				default:
					break;
				}
			}
			
			/* Delete event from memory */
			delete currentEvent;
			clearInEvents();
		} while((currentEvent = getNextEvent()));
		
		isRunningCycle = false;
	}
}

void PmCallStateHandlerSm::clearInEvents()
{
	ifaceUserAction.DIAL_CALL_raised = false;
	ifaceUserAction.ACCEPT_CALL_raised = false;
	ifaceUserAction.SPEED_DIAL_raised = false;
	ifaceUserAction.REDIAL_raised = false;
	ifaceUserAction.HANGUP_CALLS_raised = false;
	ifaceUserAction.HANGUP_ALL_CALLS_raised = false;
	ifaceUserAction.SWAP_CALLS_raised = false;
	ifaceUserAction.SPLIT_CALLS_raised = false;
	ifaceUserAction.CONFERENCE_CALL_raised = false;
	ifaceUserAction.TRANSFER_AUDIO_TO_AG_raised = false;
	ifaceUserAction.TRANSFER_AUDIO_TO_HF_raised = false;
	ifaceUserAction.MUTE_RINGTONE_raised = false;
	ifaceUserAction.START_WAITING_MODE_raised = false;
	ifaceUserAction.STOP_WAITING_MODE_raised = false;
	ifaceUserAction.ACCEPT_CALL_BY_ACQUIRING_CH_raised = false;
	ifaceAgCallStateUpdate.IDLE_raised = false;
	ifaceAgCallStateUpdate.INCOMING_raised = false;
	ifaceAgCallStateUpdate.INCOMING_INBAND_raised = false;
	ifaceAgCallStateUpdate.DIALING_raised = false;
	ifaceAgCallStateUpdate.HELD_raised = false;
	ifaceAgCallStateUpdate.ACTIVE_raised = false;
	ifaceAgCallStateUpdate.CALL_DISCONNECTING_raised = false;
	ifaceAgCallStateUpdate.CALL_DISCONNECTED_raised = false;
	ifaceAgCallStateUpdate.CALL_X_DIALING_raised = false;
	ifaceAgCallStateUpdate.CALL_X_WAITING_raised = false;
	ifaceAgCallStateUpdate.CALLS_SWAPPABLE_raised = false;
	ifaceAgCallStateUpdate.CALLS_CONFERENCE_raised = false;
	ifaceAgCallStateUpdate.ALL_CALLS_DISCONNECTED_raised = false;
	ifaceAgAudioUpdate.SCO_CONNECTED_raised = false;
	ifaceAgAudioUpdate.SCO_PAUSED_raised = false;
	ifaceAgAudioUpdate.SCO_DISCONNECTED_raised = false;
	ifaceSmHandler.SWITCH_TO_PASSIVE_raised = false;
	ifaceSmHandler.SWITCH_TO_ACTIVE_raised = false;
	ifaceAudioManagerResponse.RINGTONE_CHANNEL_GRANTED_raised = false;
	ifaceAudioManagerResponse.RINGTONE_CHANNEL_DENIED_raised = false;
	ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised = false;
	ifaceAudioManagerResponse.PHONE_CHANNEL_DENIED_raised = false;
	ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_GRANTED_raised = false;
	ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_DENIED_raised = false;
	ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised = false;
	ifaceAudioManagerResponse.PLAY_AUDIO_FAILURE_raised = false;
	ifaceAudioManagerResponse.PAUSE_AUDIO_SUCCESS_raised = false;
	ifaceAudioManagerResponse.PAUSE_AUDIO_FAILURE_raised = false;
	ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised = false;
	ifaceAudioManagerResponse.STOP_AUDIO_FAILURE_raised = false;
	ifaceAudioManagerResponse.PHONE_CHANNEL_RELEASED_raised = false;
	ifaceAudioManagerResponse.RINGTONE_CHANNEL_RELEASED_raised = false;
	ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_RELEASED_raised = false;
	ifaceAgResponse.ACCEPT_OK_raised = false;
	ifaceAgResponse.DIAL_OK_raised = false;
	ifaceAgResponse.HOLD_INCOMING_OK_raised = false;
	ifaceAgResponse.HANGUP_OK_raised = false;
	ifaceAgResponse.CONF_OK_raised = false;
	ifaceAgResponse.SWAP_OK_raised = false;
	ifaceAgResponse.SPLIT_OK_raised = false;
	ifaceAgResponse.SPEED_DIAL_OK_raised = false;
	ifaceAgResponse.ACCEPT_SCO_CONNECT_OK_raised = false;
	ifaceAgResponse.GET_CALLS_OK_raised = false;
	ifaceAgResponse.REDIAL_OK_raised = false;
	ifaceAgResponse.TRANSFER_OK_raised = false;
	ifaceAgResponse.RELEASE_AND_ACCEPT_OK_raised = false;
	ifaceAgResponse.RELEASE_AND_SWAP_OK_raised = false;
	ifaceAgResponse.HOLD_AND_ACCEPT_OK_raised = false;
	ifaceAgResponse.HANGUP_ALL_OK_raised = false;
	ifaceAgResponse.HANGUP_MULTIPARTY_OK_raised = false;
	ifaceAgResponse.SEND_DTMF_OK_raised = false;
	ifaceAgResponse.DEFAULT_ERROR_raised = false;
	ifaceAgResponse.ACCEPT_ERROR_raised = false;
	ifaceAgResponse.DIAL_ERROR_raised = false;
	ifaceAgResponse.HOLD_INCOMING_ERROR_raised = false;
	ifaceAgResponse.SPEED_DIAL_ERROR_raised = false;
	ifaceAgResponse.ACCEPT_SCO_CONNECT_ERROR_raised = false;
	ifaceAgResponse.GET_CALLS_ERROR_raised = false;
	ifaceAgResponse.REDIAL_ERROR_raised = false;
	ifaceAgResponse.TRANSFER_ERROR_raised = false;
	ifaceAgResponse.RELEASE_AND_ACCEPT_ERROR_raised = false;
	ifaceAgResponse.RELEASE_AND_SWAP_ERROR_raised = false;
	ifaceAgResponse.HOLD_AND_ACCEPT_ERROR_raised = false;
	ifaceAgResponse.SEND_DTMF_ERROR_raised = false;
	ifaceTimerUpdate.TIMER_CALLBACK_raised = false;
	ifaceInternalSCI.CHECK_AUDIO_raised = false; 
	ifaceInternalSCI.GENERATE_CALL_STATE_EVENT_raised = false; 
	ifaceInternalSCI.TO_START_WAITING_MODE_raised = false; 
	ifaceInternalSCI.MOVE_TO_NEXT_STATE_raised = false; 
}

void PmCallStateHandlerSm::clearOutEvents()
{
}


sc_boolean PmCallStateHandlerSm::isStateActive(PmCallStateHandlerSmStates state) const
{
	switch (state)
	{
		case Main_region_CallHandlerSm : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM] >= Main_region_CallHandlerSm
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM] <= Main_region_CallHandlerSm_CallHandler_region_Idle);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_REQUESTPHONEAUDIO] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_REQUESTSTREAMING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_STREAMINGSTARTED] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_STREAMINGSTOPPED] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORPREPARECHANNELRESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORSTOPAUDIORESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_REQUESTPAUSEAUDIOSTREAMING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_STREAMINGPAUSED] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_REQUESTSTOPAUDIORINGTONE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORCALLSTATEEVENTTOSTARTWAITINGMODE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORSCO] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORSCODISCONNECTION] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_AUDIOHANDLING_AUDIOHANDLING_REGION_WAITFORSTARTAUDIORESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_WAITFORAUDIOCHANNEL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORACTIVECALLSTATUS] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_RECEIVEDACTIVECALLSTATUS] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORCHANNELALLOCATION] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORSTOPAUDIORESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORSTOPAUDIORESPONSETOACCEPTCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_TOSTARTWAITINGMODE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_INBANDACCEPTCALL_INBANDACCEPTCALL_REGION_WAITFORACCEPTCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_STARTWAITINGMODEAFTERACCEPTRESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_REQUESTSTREAMINGACCEPTINGCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_STARTWAITINGMODEAFTERCHANNELALLOCATION] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_WAITFORSTOPAUDIORESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_WAITFORSTOPAUDIORESPONSETOACCEPTCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_STARTTOWAITINGMODE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACCEPTINGCALL_ACCEPTINGCALL_REGION_WAITFORACCEPTCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSCO] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSTOPAUDIORESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSTOPAUDIORESPONSEOUTBAND] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORAUDIORESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_OUTBANDCALL] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_OUTBANDCALL] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_OUTBANDCALL_OUTBANDRINGING_REGION_OUTBANDCALLNORINGING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_OUTBANDCALL_OUTBANDRINGING_REGION_OUTBANDRINGING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_REQUESTPLAYHFAUDIO] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_INBANDCALLNORINGING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_PLAYAUDIOFAILURE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_WAITFORSTOPAUDIORESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_WAITFORSCO] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_INBANDRINGING_INBANDRINGING_REGION_INBANDRINGTONESTREAMING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSCOINSWITCHTOACTIVE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_AUDIOCHANNELDENIED] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSTOPAUDIORESPONSEOUTBANDTOACCEPTCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_INCOMING_INCOMING_REGION_WAITFORSTOPAUDIORESPONSETOACCEPTCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_WAITFORCALLSTATEEVENT] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_DISCONNECTING] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_DISCONNECTING] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_DISCONNECTING_DISCONNECTING_REGION_WAITFORSTOPRESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_DISCONNECTING_DISCONNECTING_REGION_REQUESTSTOPAUDIO] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_DISCONNECTING_DISCONNECTING_REGION_WAITFORSCORELEASE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACTIVECALL] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACTIVECALL] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_ACTIVECALL_ACTIVECALL_REGION_WAITFORAUDIOEVENTACTIVECALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_OUTGOING] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_OUTGOING] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_OUTGOING_OUTGOING_REGION_WAITFORDIALRESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_OUTGOING_OUTGOING_REGION_WAITFORSCO] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_OUTGOING_OUTGOING_REGION_CANCELOUTGOINGCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORAUDIOCHANNEL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTSTREAMING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_STREAMINGSTARTED] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTPHONEAUDIO] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTINGAUDIOCHANNEL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_POSTHOLDANDACCEPTWAITINGMODECALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSTOPAUDIORESPONSEAUDIOHANDLING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSCO] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTWAITINGMODE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_POSTACCEPTWAITINGMODECALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSCORINGING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTSTREAMINGRINGING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORAUDIOCHANNELFORACTIVECALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTSTOPSTREAMING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_SENDERROR] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_SWITCHTOPASSIVE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_REQUESTWAITINGMODEACCEPTING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_RECEIVEDTIMERCALLBACK] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORWAITMODECHANNELAFTERTIMEREXPIRY] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSTOPAUDIORESPONSEXCALLOUTGOINGORWAITING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORSTOPAUDIORESPONSEACTIVECALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITINGMODECHANNELDENIED] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORWAITINGMODECHANNELRESPONSETOSTOPWAITINGMODE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_WAITINGMODE_INNER_REGION_WAITINGMODE_WAITINGMODE_REGION_WAITFORPHONECHANNELRESPONSETOSTARTWAITINGMODE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_HANDLINGHANGUP] >= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup
				&& stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_HANDLINGHANGUP] <= Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_HANDLINGHANGUP_HANDLINGHANGUP_REGION_WAITFORHANGUPRESPONSE] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_HANDLINGHANGUP_HANDLINGHANGUP_REGION_ACCEPTAFTERHANGUP] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_WAITFORAUDIOEVENTXCALLOUTGOINGORWAITING] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting
			);
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_SINGLECALL_SINGLECALL_REGION_COMPOSITE_XCALLOUTGOINGORWAITING_INNER_REGION_XCALLOUTGOINGORWAITING_WAITINGORDIALING_REGION_ACCEPTWAITINGCALL] == Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall
			);
		case Main_region_CallHandlerSm_CallHandler_region_Idle : 
			return (sc_boolean) (stateConfVector[SCVI_MAIN_REGION_CALLHANDLERSM_CALLHANDLER_REGION_IDLE] == Main_region_CallHandlerSm_CallHandler_region_Idle
			);
		default: return false;
	}
}

PmCallStateHandlerSm::SCI_UserAction* PmCallStateHandlerSm::getSCI_UserAction()
{
	return &ifaceUserAction;
}
/* Functions for event DIAL_CALL in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_dIAL_CALL(pmcore::PmCoreIfMessage_DialRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_DIAL_CALL(SCI_UserAction_DIAL_CALL, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_dIAL_CALL(pmcore::PmCoreIfMessage_DialRequest * value)
{
	DIAL_CALL_value = value;
	DIAL_CALL_raised = true;
}
/* Functions for event ACCEPT_CALL in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_aCCEPT_CALL(pmcore::PmCoreIfMessage_AcceptCallRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_ACCEPT_CALL(SCI_UserAction_ACCEPT_CALL, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_aCCEPT_CALL(pmcore::PmCoreIfMessage_AcceptCallRequest * value)
{
	ACCEPT_CALL_value = value;
	ACCEPT_CALL_raised = true;
}
/* Functions for event SPEED_DIAL in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_sPEED_DIAL(pmcore::PmCoreIfMessage_SpeedDialRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_SPEED_DIAL(SCI_UserAction_SPEED_DIAL, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_sPEED_DIAL(pmcore::PmCoreIfMessage_SpeedDialRequest * value)
{
	SPEED_DIAL_value = value;
	SPEED_DIAL_raised = true;
}
/* Functions for event REDIAL in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_rEDIAL(pmcore::PmCoreIfMessage_RedialRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_REDIAL(SCI_UserAction_REDIAL, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_rEDIAL(pmcore::PmCoreIfMessage_RedialRequest * value)
{
	REDIAL_value = value;
	REDIAL_raised = true;
}
/* Functions for event HANGUP_CALLS in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_hANGUP_CALLS(pmcore::PmCoreIfMessage_HangupCallsRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_HANGUP_CALLS(SCI_UserAction_HANGUP_CALLS, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_hANGUP_CALLS(pmcore::PmCoreIfMessage_HangupCallsRequest * value)
{
	HANGUP_CALLS_value = value;
	HANGUP_CALLS_raised = true;
}
/* Functions for event HANGUP_ALL_CALLS in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_hANGUP_ALL_CALLS(pmcore::PmCoreIfMessage_HangupCallsRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_HANGUP_ALL_CALLS(SCI_UserAction_HANGUP_ALL_CALLS, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_hANGUP_ALL_CALLS(pmcore::PmCoreIfMessage_HangupCallsRequest * value)
{
	HANGUP_ALL_CALLS_value = value;
	HANGUP_ALL_CALLS_raised = true;
}
/* Functions for event SWAP_CALLS in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_sWAP_CALLS(pmcore::PmCoreIfMessage_SwapCallRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_SWAP_CALLS(SCI_UserAction_SWAP_CALLS, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_sWAP_CALLS(pmcore::PmCoreIfMessage_SwapCallRequest * value)
{
	SWAP_CALLS_value = value;
	SWAP_CALLS_raised = true;
}
/* Functions for event SPLIT_CALLS in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_sPLIT_CALLS(pmcore::PmCoreIfMessage_SplitCallsRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_SPLIT_CALLS(SCI_UserAction_SPLIT_CALLS, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_sPLIT_CALLS(pmcore::PmCoreIfMessage_SplitCallsRequest * value)
{
	SPLIT_CALLS_value = value;
	SPLIT_CALLS_raised = true;
}
/* Functions for event CONFERENCE_CALL in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_cONFERENCE_CALL(pmcore::PmCoreIfMessage_MergeCallsRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_CONFERENCE_CALL(SCI_UserAction_CONFERENCE_CALL, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_cONFERENCE_CALL(pmcore::PmCoreIfMessage_MergeCallsRequest * value)
{
	CONFERENCE_CALL_value = value;
	CONFERENCE_CALL_raised = true;
}
/* Functions for event TRANSFER_AUDIO_TO_AG in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_tRANSFER_AUDIO_TO_AG(pmcore::PmCoreIfMessage_TransferAudioRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_AG(SCI_UserAction_TRANSFER_AUDIO_TO_AG, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_tRANSFER_AUDIO_TO_AG(pmcore::PmCoreIfMessage_TransferAudioRequest * value)
{
	TRANSFER_AUDIO_TO_AG_value = value;
	TRANSFER_AUDIO_TO_AG_raised = true;
}
/* Functions for event TRANSFER_AUDIO_TO_HF in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_tRANSFER_AUDIO_TO_HF(pmcore::PmCoreIfMessage_TransferAudioRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_TRANSFER_AUDIO_TO_HF(SCI_UserAction_TRANSFER_AUDIO_TO_HF, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_tRANSFER_AUDIO_TO_HF(pmcore::PmCoreIfMessage_TransferAudioRequest * value)
{
	TRANSFER_AUDIO_TO_HF_value = value;
	TRANSFER_AUDIO_TO_HF_raised = true;
}
/* Functions for event MUTE_RINGTONE in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_mUTE_RINGTONE(pmcore::PmCoreIfMessage_SetRingtoneMuteStateRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_MUTE_RINGTONE(SCI_UserAction_MUTE_RINGTONE, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_mUTE_RINGTONE(pmcore::PmCoreIfMessage_SetRingtoneMuteStateRequest * value)
{
	MUTE_RINGTONE_value = value;
	MUTE_RINGTONE_raised = true;
}
/* Functions for event START_WAITING_MODE in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_sTART_WAITING_MODE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_START_WAITING_MODE(SCI_UserAction_START_WAITING_MODE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_sTART_WAITING_MODE()
{
	START_WAITING_MODE_raised = true;
}
/* Functions for event STOP_WAITING_MODE in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_sTOP_WAITING_MODE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_STOP_WAITING_MODE(SCI_UserAction_STOP_WAITING_MODE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_sTOP_WAITING_MODE()
{
	STOP_WAITING_MODE_raised = true;
}
/* Functions for event ACCEPT_CALL_BY_ACQUIRING_CH in interface SCI_UserAction */
void PmCallStateHandlerSm::SCI_UserAction::raise_aCCEPT_CALL_BY_ACQUIRING_CH(pmcore::PmCoreIfMessage_AcceptCallRequest * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_UserAction_ACCEPT_CALL_BY_ACQUIRING_CH(SCI_UserAction_ACCEPT_CALL_BY_ACQUIRING_CH, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_UserAction::internal_raise_aCCEPT_CALL_BY_ACQUIRING_CH(pmcore::PmCoreIfMessage_AcceptCallRequest * value)
{
	ACCEPT_CALL_BY_ACQUIRING_CH_value = value;
	ACCEPT_CALL_BY_ACQUIRING_CH_raised = true;
}
void PmCallStateHandlerSm::setSCI_UserAction_OCB(SCI_UserAction_OCB* operationCallback)
{
	ifaceUserAction_OCB = operationCallback;
}
PmCallStateHandlerSm::SCI_AgCallStateUpdate* PmCallStateHandlerSm::getSCI_AgCallStateUpdate()
{
	return &ifaceAgCallStateUpdate;
}
/* Functions for event IDLE in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_iDLE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_IDLE(SCI_AgCallStateUpdate_IDLE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_iDLE()
{
	IDLE_raised = true;
}
/* Functions for event INCOMING in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_iNCOMING()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_INCOMING(SCI_AgCallStateUpdate_INCOMING));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_iNCOMING()
{
	INCOMING_raised = true;
}
/* Functions for event INCOMING_INBAND in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_iNCOMING_INBAND()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_INCOMING_INBAND(SCI_AgCallStateUpdate_INCOMING_INBAND));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_iNCOMING_INBAND()
{
	INCOMING_INBAND_raised = true;
}
/* Functions for event DIALING in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_dIALING()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_DIALING(SCI_AgCallStateUpdate_DIALING));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_dIALING()
{
	DIALING_raised = true;
}
/* Functions for event HELD in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_hELD()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_HELD(SCI_AgCallStateUpdate_HELD));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_hELD()
{
	HELD_raised = true;
}
/* Functions for event ACTIVE in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_aCTIVE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_ACTIVE(SCI_AgCallStateUpdate_ACTIVE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_aCTIVE()
{
	ACTIVE_raised = true;
}
/* Functions for event CALL_DISCONNECTING in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_cALL_DISCONNECTING()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_CALL_DISCONNECTING(SCI_AgCallStateUpdate_CALL_DISCONNECTING));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_cALL_DISCONNECTING()
{
	CALL_DISCONNECTING_raised = true;
}
/* Functions for event CALL_DISCONNECTED in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_cALL_DISCONNECTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_CALL_DISCONNECTED(SCI_AgCallStateUpdate_CALL_DISCONNECTED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_cALL_DISCONNECTED()
{
	CALL_DISCONNECTED_raised = true;
}
/* Functions for event CALL_X_DIALING in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_cALL_X_DIALING()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_CALL_X_DIALING(SCI_AgCallStateUpdate_CALL_X_DIALING));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_cALL_X_DIALING()
{
	CALL_X_DIALING_raised = true;
}
/* Functions for event CALL_X_WAITING in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_cALL_X_WAITING()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_CALL_X_WAITING(SCI_AgCallStateUpdate_CALL_X_WAITING));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_cALL_X_WAITING()
{
	CALL_X_WAITING_raised = true;
}
/* Functions for event CALLS_SWAPPABLE in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_cALLS_SWAPPABLE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_CALLS_SWAPPABLE(SCI_AgCallStateUpdate_CALLS_SWAPPABLE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_cALLS_SWAPPABLE()
{
	CALLS_SWAPPABLE_raised = true;
}
/* Functions for event CALLS_CONFERENCE in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_cALLS_CONFERENCE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_CALLS_CONFERENCE(SCI_AgCallStateUpdate_CALLS_CONFERENCE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_cALLS_CONFERENCE()
{
	CALLS_CONFERENCE_raised = true;
}
/* Functions for event ALL_CALLS_DISCONNECTED in interface SCI_AgCallStateUpdate */
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::raise_aLL_CALLS_DISCONNECTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgCallStateUpdate_ALL_CALLS_DISCONNECTED(SCI_AgCallStateUpdate_ALL_CALLS_DISCONNECTED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgCallStateUpdate::internal_raise_aLL_CALLS_DISCONNECTED()
{
	ALL_CALLS_DISCONNECTED_raised = true;
}
CallCount PmCallStateHandlerSm::SCI_AgCallStateUpdate::get_callCount() const
{
	return callCount;
}

void PmCallStateHandlerSm::SCI_AgCallStateUpdate::set_callCount(CallCount value)
{
	this->callCount = value;
}

void PmCallStateHandlerSm::setSCI_AgCallStateUpdate_OCB(SCI_AgCallStateUpdate_OCB* operationCallback)
{
	ifaceAgCallStateUpdate_OCB = operationCallback;
}
PmCallStateHandlerSm::SCI_AgAudioUpdate* PmCallStateHandlerSm::getSCI_AgAudioUpdate()
{
	return &ifaceAgAudioUpdate;
}
/* Functions for event SCO_CONNECTED in interface SCI_AgAudioUpdate */
void PmCallStateHandlerSm::SCI_AgAudioUpdate::raise_sCO_CONNECTED(SCOStatus value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgAudioUpdate_SCO_CONNECTED(SCI_AgAudioUpdate_SCO_CONNECTED, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgAudioUpdate::internal_raise_sCO_CONNECTED(SCOStatus value)
{
	SCO_CONNECTED_value = value;
	SCO_CONNECTED_raised = true;
}
/* Functions for event SCO_PAUSED in interface SCI_AgAudioUpdate */
void PmCallStateHandlerSm::SCI_AgAudioUpdate::raise_sCO_PAUSED(SCOStatus value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgAudioUpdate_SCO_PAUSED(SCI_AgAudioUpdate_SCO_PAUSED, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgAudioUpdate::internal_raise_sCO_PAUSED(SCOStatus value)
{
	SCO_PAUSED_value = value;
	SCO_PAUSED_raised = true;
}
/* Functions for event SCO_DISCONNECTED in interface SCI_AgAudioUpdate */
void PmCallStateHandlerSm::SCI_AgAudioUpdate::raise_sCO_DISCONNECTED(SCOStatus value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgAudioUpdate_SCO_DISCONNECTED(SCI_AgAudioUpdate_SCO_DISCONNECTED, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgAudioUpdate::internal_raise_sCO_DISCONNECTED(SCOStatus value)
{
	SCO_DISCONNECTED_value = value;
	SCO_DISCONNECTED_raised = true;
}
SCOStatus PmCallStateHandlerSm::SCI_AgAudioUpdate::get_scoStatus() const
{
	return scoStatus;
}

void PmCallStateHandlerSm::SCI_AgAudioUpdate::set_scoStatus(SCOStatus value)
{
	this->scoStatus = value;
}

PmCallStateHandlerSm::SCI_SmHandler* PmCallStateHandlerSm::getSCI_SmHandler()
{
	return &ifaceSmHandler;
}
/* Functions for event SWITCH_TO_PASSIVE in interface SCI_SmHandler */
void PmCallStateHandlerSm::SCI_SmHandler::raise_sWITCH_TO_PASSIVE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_SmHandler_SWITCH_TO_PASSIVE(SCI_SmHandler_SWITCH_TO_PASSIVE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_SmHandler::internal_raise_sWITCH_TO_PASSIVE()
{
	SWITCH_TO_PASSIVE_raised = true;
}
/* Functions for event SWITCH_TO_ACTIVE in interface SCI_SmHandler */
void PmCallStateHandlerSm::SCI_SmHandler::raise_sWITCH_TO_ACTIVE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_SmHandler_SWITCH_TO_ACTIVE(SCI_SmHandler_SWITCH_TO_ACTIVE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_SmHandler::internal_raise_sWITCH_TO_ACTIVE()
{
	SWITCH_TO_ACTIVE_raised = true;
}
sc_boolean PmCallStateHandlerSm::SCI_SmHandler::get_isActiveDevice() const
{
	return isActiveDevice;
}

void PmCallStateHandlerSm::SCI_SmHandler::set_isActiveDevice(sc_boolean value)
{
	this->isActiveDevice = value;
}

void PmCallStateHandlerSm::setSCI_SmHandler_OCB(SCI_SmHandler_OCB* operationCallback)
{
	ifaceSmHandler_OCB = operationCallback;
}
PmCallStateHandlerSm::SCI_AudioManagerRequest* PmCallStateHandlerSm::getSCI_AudioManagerRequest()
{
	return &ifaceAudioManagerRequest;
}
PmCorePhoneAudioState PmCallStateHandlerSm::SCI_AudioManagerRequest::get_phoneAudioState() const
{
	return phoneAudioState;
}

void PmCallStateHandlerSm::SCI_AudioManagerRequest::set_phoneAudioState(PmCorePhoneAudioState value)
{
	this->phoneAudioState = value;
}

void PmCallStateHandlerSm::setSCI_AudioManagerRequest_OCB(SCI_AudioManagerRequest_OCB* operationCallback)
{
	ifaceAudioManagerRequest_OCB = operationCallback;
}
PmCallStateHandlerSm::SCI_AudioManagerResponse* PmCallStateHandlerSm::getSCI_AudioManagerResponse()
{
	return &ifaceAudioManagerResponse;
}
/* Functions for event RINGTONE_CHANNEL_GRANTED in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_rINGTONE_CHANNEL_GRANTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED(SCI_AudioManagerResponse_RINGTONE_CHANNEL_GRANTED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_rINGTONE_CHANNEL_GRANTED()
{
	RINGTONE_CHANNEL_GRANTED_raised = true;
}
/* Functions for event RINGTONE_CHANNEL_DENIED in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_rINGTONE_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED(SCI_AudioManagerResponse_RINGTONE_CHANNEL_DENIED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_rINGTONE_CHANNEL_DENIED()
{
	RINGTONE_CHANNEL_DENIED_raised = true;
}
/* Functions for event PHONE_CHANNEL_GRANTED in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_pHONE_CHANNEL_GRANTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PHONE_CHANNEL_GRANTED(SCI_AudioManagerResponse_PHONE_CHANNEL_GRANTED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_pHONE_CHANNEL_GRANTED()
{
	PHONE_CHANNEL_GRANTED_raised = true;
}
/* Functions for event PHONE_CHANNEL_DENIED in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_pHONE_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PHONE_CHANNEL_DENIED(SCI_AudioManagerResponse_PHONE_CHANNEL_DENIED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_pHONE_CHANNEL_DENIED()
{
	PHONE_CHANNEL_DENIED_raised = true;
}
/* Functions for event WAITINGMODE_CHANNEL_GRANTED in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_wAITINGMODE_CHANNEL_GRANTED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_GRANTED(SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_GRANTED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_wAITINGMODE_CHANNEL_GRANTED()
{
	WAITINGMODE_CHANNEL_GRANTED_raised = true;
}
/* Functions for event WAITINGMODE_CHANNEL_DENIED in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_wAITINGMODE_CHANNEL_DENIED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_DENIED(SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_DENIED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_wAITINGMODE_CHANNEL_DENIED()
{
	WAITINGMODE_CHANNEL_DENIED_raised = true;
}
/* Functions for event PLAY_AUDIO_SUCCESS in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_pLAY_AUDIO_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS(SCI_AudioManagerResponse_PLAY_AUDIO_SUCCESS));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_pLAY_AUDIO_SUCCESS()
{
	PLAY_AUDIO_SUCCESS_raised = true;
}
/* Functions for event PLAY_AUDIO_FAILURE in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_pLAY_AUDIO_FAILURE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE(SCI_AudioManagerResponse_PLAY_AUDIO_FAILURE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_pLAY_AUDIO_FAILURE()
{
	PLAY_AUDIO_FAILURE_raised = true;
}
/* Functions for event PAUSE_AUDIO_SUCCESS in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_pAUSE_AUDIO_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS(SCI_AudioManagerResponse_PAUSE_AUDIO_SUCCESS));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_pAUSE_AUDIO_SUCCESS()
{
	PAUSE_AUDIO_SUCCESS_raised = true;
}
/* Functions for event PAUSE_AUDIO_FAILURE in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_pAUSE_AUDIO_FAILURE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE(SCI_AudioManagerResponse_PAUSE_AUDIO_FAILURE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_pAUSE_AUDIO_FAILURE()
{
	PAUSE_AUDIO_FAILURE_raised = true;
}
/* Functions for event STOP_AUDIO_SUCCESS in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_sTOP_AUDIO_SUCCESS()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS(SCI_AudioManagerResponse_STOP_AUDIO_SUCCESS));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_sTOP_AUDIO_SUCCESS()
{
	STOP_AUDIO_SUCCESS_raised = true;
}
/* Functions for event STOP_AUDIO_FAILURE in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_sTOP_AUDIO_FAILURE()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_STOP_AUDIO_FAILURE(SCI_AudioManagerResponse_STOP_AUDIO_FAILURE));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_sTOP_AUDIO_FAILURE()
{
	STOP_AUDIO_FAILURE_raised = true;
}
/* Functions for event PHONE_CHANNEL_RELEASED in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_pHONE_CHANNEL_RELEASED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_PHONE_CHANNEL_RELEASED(SCI_AudioManagerResponse_PHONE_CHANNEL_RELEASED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_pHONE_CHANNEL_RELEASED()
{
	PHONE_CHANNEL_RELEASED_raised = true;
}
/* Functions for event RINGTONE_CHANNEL_RELEASED in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_rINGTONE_CHANNEL_RELEASED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED(SCI_AudioManagerResponse_RINGTONE_CHANNEL_RELEASED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_rINGTONE_CHANNEL_RELEASED()
{
	RINGTONE_CHANNEL_RELEASED_raised = true;
}
/* Functions for event WAITINGMODE_CHANNEL_RELEASED in interface SCI_AudioManagerResponse */
void PmCallStateHandlerSm::SCI_AudioManagerResponse::raise_wAITINGMODE_CHANNEL_RELEASED()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_RELEASED(SCI_AudioManagerResponse_WAITINGMODE_CHANNEL_RELEASED));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AudioManagerResponse::internal_raise_wAITINGMODE_CHANNEL_RELEASED()
{
	WAITINGMODE_CHANNEL_RELEASED_raised = true;
}
PmCallStateHandlerSm::SCI_AgResponse* PmCallStateHandlerSm::getSCI_AgResponse()
{
	return &ifaceAgResponse;
}
/* Functions for event ACCEPT_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_aCCEPT_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_ACCEPT_OK(SCI_AgResponse_ACCEPT_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_aCCEPT_OK()
{
	ACCEPT_OK_raised = true;
}
/* Functions for event DIAL_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_dIAL_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_DIAL_OK(SCI_AgResponse_DIAL_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_dIAL_OK()
{
	DIAL_OK_raised = true;
}
/* Functions for event HOLD_INCOMING_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_hOLD_INCOMING_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_HOLD_INCOMING_OK(SCI_AgResponse_HOLD_INCOMING_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_hOLD_INCOMING_OK()
{
	HOLD_INCOMING_OK_raised = true;
}
/* Functions for event HANGUP_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_hANGUP_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_HANGUP_OK(SCI_AgResponse_HANGUP_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_hANGUP_OK()
{
	HANGUP_OK_raised = true;
}
/* Functions for event CONF_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_cONF_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_CONF_OK(SCI_AgResponse_CONF_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_cONF_OK()
{
	CONF_OK_raised = true;
}
/* Functions for event SWAP_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_sWAP_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_SWAP_OK(SCI_AgResponse_SWAP_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_sWAP_OK()
{
	SWAP_OK_raised = true;
}
/* Functions for event SPLIT_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_sPLIT_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_SPLIT_OK(SCI_AgResponse_SPLIT_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_sPLIT_OK()
{
	SPLIT_OK_raised = true;
}
/* Functions for event SPEED_DIAL_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_sPEED_DIAL_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_SPEED_DIAL_OK(SCI_AgResponse_SPEED_DIAL_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_sPEED_DIAL_OK()
{
	SPEED_DIAL_OK_raised = true;
}
/* Functions for event ACCEPT_SCO_CONNECT_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_aCCEPT_SCO_CONNECT_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_ACCEPT_SCO_CONNECT_OK(SCI_AgResponse_ACCEPT_SCO_CONNECT_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_aCCEPT_SCO_CONNECT_OK()
{
	ACCEPT_SCO_CONNECT_OK_raised = true;
}
/* Functions for event GET_CALLS_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_gET_CALLS_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_GET_CALLS_OK(SCI_AgResponse_GET_CALLS_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_gET_CALLS_OK()
{
	GET_CALLS_OK_raised = true;
}
/* Functions for event REDIAL_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_rEDIAL_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_REDIAL_OK(SCI_AgResponse_REDIAL_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_rEDIAL_OK()
{
	REDIAL_OK_raised = true;
}
/* Functions for event TRANSFER_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_tRANSFER_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_TRANSFER_OK(SCI_AgResponse_TRANSFER_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_tRANSFER_OK()
{
	TRANSFER_OK_raised = true;
}
/* Functions for event RELEASE_AND_ACCEPT_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_rELEASE_AND_ACCEPT_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_RELEASE_AND_ACCEPT_OK(SCI_AgResponse_RELEASE_AND_ACCEPT_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_rELEASE_AND_ACCEPT_OK()
{
	RELEASE_AND_ACCEPT_OK_raised = true;
}
/* Functions for event RELEASE_AND_SWAP_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_rELEASE_AND_SWAP_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_RELEASE_AND_SWAP_OK(SCI_AgResponse_RELEASE_AND_SWAP_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_rELEASE_AND_SWAP_OK()
{
	RELEASE_AND_SWAP_OK_raised = true;
}
/* Functions for event HOLD_AND_ACCEPT_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_hOLD_AND_ACCEPT_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_HOLD_AND_ACCEPT_OK(SCI_AgResponse_HOLD_AND_ACCEPT_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_hOLD_AND_ACCEPT_OK()
{
	HOLD_AND_ACCEPT_OK_raised = true;
}
/* Functions for event HANGUP_ALL_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_hANGUP_ALL_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_HANGUP_ALL_OK(SCI_AgResponse_HANGUP_ALL_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_hANGUP_ALL_OK()
{
	HANGUP_ALL_OK_raised = true;
}
/* Functions for event HANGUP_MULTIPARTY_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_hANGUP_MULTIPARTY_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_HANGUP_MULTIPARTY_OK(SCI_AgResponse_HANGUP_MULTIPARTY_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_hANGUP_MULTIPARTY_OK()
{
	HANGUP_MULTIPARTY_OK_raised = true;
}
/* Functions for event SEND_DTMF_OK in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_sEND_DTMF_OK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_SEND_DTMF_OK(SCI_AgResponse_SEND_DTMF_OK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_sEND_DTMF_OK()
{
	SEND_DTMF_OK_raised = true;
}
/* Functions for event DEFAULT_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_dEFAULT_ERROR()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_DEFAULT_ERROR(SCI_AgResponse_DEFAULT_ERROR));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_dEFAULT_ERROR()
{
	DEFAULT_ERROR_raised = true;
}
/* Functions for event ACCEPT_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_aCCEPT_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_ACCEPT_ERROR(SCI_AgResponse_ACCEPT_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_aCCEPT_ERROR(pmcore::PmCoreIfMessage * value)
{
	ACCEPT_ERROR_value = value;
	ACCEPT_ERROR_raised = true;
}
/* Functions for event DIAL_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_dIAL_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_DIAL_ERROR(SCI_AgResponse_DIAL_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_dIAL_ERROR(pmcore::PmCoreIfMessage * value)
{
	DIAL_ERROR_value = value;
	DIAL_ERROR_raised = true;
}
/* Functions for event HOLD_INCOMING_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_hOLD_INCOMING_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_HOLD_INCOMING_ERROR(SCI_AgResponse_HOLD_INCOMING_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_hOLD_INCOMING_ERROR(pmcore::PmCoreIfMessage * value)
{
	HOLD_INCOMING_ERROR_value = value;
	HOLD_INCOMING_ERROR_raised = true;
}
/* Functions for event SPEED_DIAL_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_sPEED_DIAL_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_SPEED_DIAL_ERROR(SCI_AgResponse_SPEED_DIAL_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_sPEED_DIAL_ERROR(pmcore::PmCoreIfMessage * value)
{
	SPEED_DIAL_ERROR_value = value;
	SPEED_DIAL_ERROR_raised = true;
}
/* Functions for event ACCEPT_SCO_CONNECT_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_aCCEPT_SCO_CONNECT_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_ACCEPT_SCO_CONNECT_ERROR(SCI_AgResponse_ACCEPT_SCO_CONNECT_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_aCCEPT_SCO_CONNECT_ERROR(pmcore::PmCoreIfMessage * value)
{
	ACCEPT_SCO_CONNECT_ERROR_value = value;
	ACCEPT_SCO_CONNECT_ERROR_raised = true;
}
/* Functions for event GET_CALLS_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_gET_CALLS_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_GET_CALLS_ERROR(SCI_AgResponse_GET_CALLS_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_gET_CALLS_ERROR(pmcore::PmCoreIfMessage * value)
{
	GET_CALLS_ERROR_value = value;
	GET_CALLS_ERROR_raised = true;
}
/* Functions for event REDIAL_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_rEDIAL_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_REDIAL_ERROR(SCI_AgResponse_REDIAL_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_rEDIAL_ERROR(pmcore::PmCoreIfMessage * value)
{
	REDIAL_ERROR_value = value;
	REDIAL_ERROR_raised = true;
}
/* Functions for event TRANSFER_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_tRANSFER_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_TRANSFER_ERROR(SCI_AgResponse_TRANSFER_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_tRANSFER_ERROR(pmcore::PmCoreIfMessage * value)
{
	TRANSFER_ERROR_value = value;
	TRANSFER_ERROR_raised = true;
}
/* Functions for event RELEASE_AND_ACCEPT_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_rELEASE_AND_ACCEPT_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_RELEASE_AND_ACCEPT_ERROR(SCI_AgResponse_RELEASE_AND_ACCEPT_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_rELEASE_AND_ACCEPT_ERROR(pmcore::PmCoreIfMessage * value)
{
	RELEASE_AND_ACCEPT_ERROR_value = value;
	RELEASE_AND_ACCEPT_ERROR_raised = true;
}
/* Functions for event RELEASE_AND_SWAP_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_rELEASE_AND_SWAP_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_RELEASE_AND_SWAP_ERROR(SCI_AgResponse_RELEASE_AND_SWAP_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_rELEASE_AND_SWAP_ERROR(pmcore::PmCoreIfMessage * value)
{
	RELEASE_AND_SWAP_ERROR_value = value;
	RELEASE_AND_SWAP_ERROR_raised = true;
}
/* Functions for event HOLD_AND_ACCEPT_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_hOLD_AND_ACCEPT_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_HOLD_AND_ACCEPT_ERROR(SCI_AgResponse_HOLD_AND_ACCEPT_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_hOLD_AND_ACCEPT_ERROR(pmcore::PmCoreIfMessage * value)
{
	HOLD_AND_ACCEPT_ERROR_value = value;
	HOLD_AND_ACCEPT_ERROR_raised = true;
}
/* Functions for event SEND_DTMF_ERROR in interface SCI_AgResponse */
void PmCallStateHandlerSm::SCI_AgResponse::raise_sEND_DTMF_ERROR(pmcore::PmCoreIfMessage * value)
{
	parent->inEventQueue.push_back(new SctEvent_SCI_AgResponse_SEND_DTMF_ERROR(SCI_AgResponse_SEND_DTMF_ERROR, value));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_AgResponse::internal_raise_sEND_DTMF_ERROR(pmcore::PmCoreIfMessage * value)
{
	SEND_DTMF_ERROR_value = value;
	SEND_DTMF_ERROR_raised = true;
}
void PmCallStateHandlerSm::setSCI_AgResponse_OCB(SCI_AgResponse_OCB* operationCallback)
{
	ifaceAgResponse_OCB = operationCallback;
}
PmCallStateHandlerSm::SCI_TimerUpdate* PmCallStateHandlerSm::getSCI_TimerUpdate()
{
	return &ifaceTimerUpdate;
}
/* Functions for event TIMER_CALLBACK in interface SCI_TimerUpdate */
void PmCallStateHandlerSm::SCI_TimerUpdate::raise_tIMER_CALLBACK()
{
	parent->inEventQueue.push_back(new SctEvent_SCI_TimerUpdate_TIMER_CALLBACK(SCI_TimerUpdate_TIMER_CALLBACK));
	parent->runCycle();
}
void PmCallStateHandlerSm::SCI_TimerUpdate::internal_raise_tIMER_CALLBACK()
{
	TIMER_CALLBACK_raised = true;
}
void PmCallStateHandlerSm::setSCI_TimerUpdate_OCB(SCI_TimerUpdate_OCB* operationCallback)
{
	ifaceTimerUpdate_OCB = operationCallback;
}
/* Functions for event CHECK_AUDIO in interface InternalSCI */
void PmCallStateHandlerSm::InternalSCI::raise_cHECK_AUDIO()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
	parent->runCycle();
}
void PmCallStateHandlerSm::InternalSCI::internal_raise_cHECK_AUDIO()
{
	CHECK_AUDIO_raised = true;
}
sc_boolean PmCallStateHandlerSm::InternalSCI::isRaised_cHECK_AUDIO() const
{
	return CHECK_AUDIO_raised;
}
/* Functions for event GENERATE_CALL_STATE_EVENT in interface InternalSCI */
void PmCallStateHandlerSm::InternalSCI::raise_gENERATE_CALL_STATE_EVENT()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT(InternalSCI_GENERATE_CALL_STATE_EVENT));
	parent->runCycle();
}
void PmCallStateHandlerSm::InternalSCI::internal_raise_gENERATE_CALL_STATE_EVENT()
{
	GENERATE_CALL_STATE_EVENT_raised = true;
}
sc_boolean PmCallStateHandlerSm::InternalSCI::isRaised_gENERATE_CALL_STATE_EVENT() const
{
	return GENERATE_CALL_STATE_EVENT_raised;
}
/* Functions for event TO_START_WAITING_MODE in interface InternalSCI */
void PmCallStateHandlerSm::InternalSCI::raise_tO_START_WAITING_MODE()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_TO_START_WAITING_MODE(InternalSCI_TO_START_WAITING_MODE));
	parent->runCycle();
}
void PmCallStateHandlerSm::InternalSCI::internal_raise_tO_START_WAITING_MODE()
{
	TO_START_WAITING_MODE_raised = true;
}
sc_boolean PmCallStateHandlerSm::InternalSCI::isRaised_tO_START_WAITING_MODE() const
{
	return TO_START_WAITING_MODE_raised;
}
/* Functions for event MOVE_TO_NEXT_STATE in interface InternalSCI */
void PmCallStateHandlerSm::InternalSCI::raise_mOVE_TO_NEXT_STATE()
{
	parent->internalEventQueue.push_back(new SctEvent_InternalSCI_MOVE_TO_NEXT_STATE(InternalSCI_MOVE_TO_NEXT_STATE));
	parent->runCycle();
}
void PmCallStateHandlerSm::InternalSCI::internal_raise_mOVE_TO_NEXT_STATE()
{
	MOVE_TO_NEXT_STATE_raised = true;
}
sc_boolean PmCallStateHandlerSm::InternalSCI::isRaised_mOVE_TO_NEXT_STATE() const
{
	return MOVE_TO_NEXT_STATE_raised;
}

void PmCallStateHandlerSm::setTraceObserver(ysc::TraceObserver<PmCallStateHandlerSmStates>* tracingcallback) {
	ifaceTraceObserver = tracingcallback;
}

ysc::TraceObserver<PmCallStateHandlerSm::PmCallStateHandlerSmStates>* PmCallStateHandlerSm::getTraceObserver() {
	return ifaceTraceObserver;
}

// implementations of all internal functions

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0_tr1_tr1()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr0_tr0()
{
	return (ifaceAudioManagerRequest.phoneAudioState) == (PHONE_CHANNEL_REQUESTED);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr2_tr2()
{
	return (ifaceAudioManagerRequest.phoneAudioState) == (PHONE_START_STREAMING_REQUESTED);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr0_tr0()
{
	return (ifaceAudioManagerRequest.phoneAudioState) == (PHONE_START_STREAMING_SUCCESS);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr2_tr2()
{
	return ((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_AUDIO_CHANNEL_IDLE)) || ((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_SUCCESS));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3_tr1_tr1()
{
	return (((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_START_STREAMING_SUCCESS)) || ((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_PAUSE_STREAMING_SUCCESS))) || ((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_PAUSE_STREAMING_REQUESTED));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4_tr0_tr0()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5_tr1_tr1()
{
	return (ifaceSmHandler.isActiveDevice) == (false);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6_tr1_tr1()
{
	return ((((ifaceAudioManagerRequest.phoneAudioState) == (RINGTONE_CHANNEL_REQUESTED)) || ((ifaceAudioManagerRequest.phoneAudioState) == (RINGTONE_CHANNEL_ALLOCATED))) || ((ifaceAudioManagerRequest.phoneAudioState) == (RINGTONE_START_STREAMING_REQUESTED))) || ((ifaceAudioManagerRequest.phoneAudioState) == (RINGTONE_START_STREAMING_SUCCESS));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7_tr0_tr0()
{
	return (ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_REQUESTED);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8_tr0_tr0()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9_tr0_tr0()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10_tr0_tr0()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0_tr0_tr0()
{
	return (false) == (ifaceSmHandler_OCB->isChannelDenied());
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0_tr1_tr1()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1_tr0_tr0()
{
	return (ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_REQUESTED);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2_tr0_tr0()
{
	return (ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_REQUESTED);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3_tr1_tr1()
{
	return (true) == (ifaceSmHandler_OCB->isRingtoneSuppressed());
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr0_tr0()
{
	return (true) == (ifaceSmHandler_OCB->isRingtoneSuppressed());
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr2_tr2()
{
	return ((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_AUDIO_CHANNEL_IDLE)) || ((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_SUCCESS));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0_tr1_tr1()
{
	return (ifaceAgAudioUpdate.scoStatus) == (0);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5_tr0_tr0()
{
	return (ifaceAgAudioUpdate.scoStatus) == (0);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6_tr0_tr0()
{
	return (ifaceAgAudioUpdate.scoStatus) != (0);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr0_tr0()
{
	return ((STOP_AUDIO_NOT_CALLED) == (ifaceSmHandler_OCB->isStopAudioRequested())) || ((WAIT_FOR_PAUSE_AUDIO_RESPONSE) == (ifaceSmHandler_OCB->isStopAudioRequested()));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr2_tr2()
{
	return (WAIT_FOR_STOP_AUDIO_RESPONSE) == (ifaceSmHandler_OCB->isStopAudioRequested());
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1_tr0_tr0()
{
	return (ifaceAgAudioUpdate.scoStatus) == (0);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0_tr0_tr0()
{
	return (ifaceAgAudioUpdate.scoStatus) == (0);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0_tr0_tr0()
{
	return ((((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_REQUESTED))) || (((ifaceAudioManagerRequest.phoneAudioState) == (RINGTONE_STOP_STREAMING_REQUESTED)))) || (((ifaceAudioManagerRequest.phoneAudioState) == (WAITINGMODE_STOP_STREAMING_REQUESTED)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1_tr1_tr1()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2_tr0_tr0()
{
	return (true) == (ifaceSmHandler_OCB->isInbandRinging());
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3_tr0_tr0()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4_tr1_tr1()
{
	return (ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_REQUESTED);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5_tr1_tr1()
{
	return (ifaceSmHandler.isActiveDevice) == (false);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6_tr1_tr1()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7_tr0_tr0()
{
	return (ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_REQUESTED);
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8_tr0_tr0()
{
	return ((((SCO_DEFAULT) != (ifaceAgAudioUpdate.scoStatus))) && (((SCO_NOT_ESTABLISHED) != (ifaceAgAudioUpdate.scoStatus)))) && (((SCO_PAUSED) != (ifaceAgAudioUpdate.scoStatus)));
}

sc_boolean PmCallStateHandlerSm::check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0_tr0_tr0()
{
	return (((((((((((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_AUDIO_CHANNEL_IDLE))) || (((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_REQUESTED)))) || (((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_STOP_STREAMING_SUCCESS)))) || (((ifaceAudioManagerRequest.phoneAudioState) == (RINGTONE_STOP_STREAMING_REQUESTED)))) || (((ifaceAudioManagerRequest.phoneAudioState) == (RINGTONE_STOP_STREAMING_SUCCESS)))) || (((ifaceAudioManagerRequest.phoneAudioState) == (WAITINGMODE_STOP_STREAMING_REQUESTED)))) || (((ifaceAudioManagerRequest.phoneAudioState) == (WAITINGMODE_STOP_STREAMING_SUCCESS)))) || (((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_CHANNEL_NOT_ALLOCATED)))) || (((ifaceAudioManagerRequest.phoneAudioState) == (RINGTONE_CHANNEL_NOT_ALLOCATED)))) || (((ifaceAudioManagerRequest.phoneAudioState) == (WAITINGMODE_CHANNEL_NOT_ALLOCATED)));
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr0()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_default();
	Main_region_CallHandlerSm_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr2()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
	ifaceSmHandler_OCB->processAllCallsRemoved();
	enseq_Main_region_CallHandlerSm_CallHandler_region_Idle_default();
	Main_region_CallHandlerSm_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr3()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_AudioHandling();
	Main_region_CallHandlerSm_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr4()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_Ringing();
	Main_region_CallHandlerSm_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr5()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_ActiveCall();
	Main_region_CallHandlerSm_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr6()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_XCallOutgoingOrWaiting();
	Main_region_CallHandlerSm_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr7()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_Accepting();
	Main_region_CallHandlerSm_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr8()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
	enseq_Main_region_CallHandlerSm_CallHandler_region_Idle_default();
	Main_region_CallHandlerSm_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr0()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent_default();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr3()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr4()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling();
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromAudioHandling();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr5()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling();
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromActive();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr6()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling();
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromXCallOutgoingOrWaiting();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr0()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr2()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromAccepting();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr3()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromAccepting();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr4()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromRinging();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr2()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr3()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_WaitForAudioChannelOutband();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr4()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_WaitForActiveCallStatus();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr5()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_WaitForAudioChannelInband();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr6()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_ReceivedActiveCallStatus();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_tr0()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting();
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_MoveToIdle();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_tr1()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_tr2()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_tr4()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing();
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToIdleFromOutgoingCall();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_tr0()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_tr2()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_ToEntry();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr2()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr2()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3_tr1()
{
	ifaceAudioManagerRequest_OCB->stopAudio();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4_tr0()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5_tr0()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8_tr0()
{
	ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_ToEntry();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeFromRinging();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_EntryToNoRinging();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_EntryToNoRinging();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr2()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_EntryToNoRinging();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0_tr0()
{
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_default();
	Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5_tr0()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_ExitToAudioHandling();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5_tr1()
{
	ifaceAudioManagerRequest_OCB->requestPhoneAudio();
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_ExitToAudioHandling();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6_tr0()
{
	ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr2()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1_tr0()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_Exit_Idle();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_ExitToAudioHandling();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2_tr1()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6_tr1()
{
	ifaceAudioManagerRequest_OCB->playWaitingModeTone(ifaceAgAudioUpdate.scoStatus);
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8_tr0()
{
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8_tr1()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0_tr0()
{
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_default();
}

void PmCallStateHandlerSm::effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0_tr1()
{
	ifaceAudioManagerRequest_OCB->stopAudio();
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_default();
}

/* Entry action for state 'RequestPhoneAudio'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio()
{
	/* Entry action for state 'RequestPhoneAudio'. */
	ifaceAudioManagerRequest_OCB->requestPhoneAudio();
}

/* Entry action for state 'RequestStreaming'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming()
{
	/* Entry action for state 'RequestStreaming'. */
	ifaceAudioManagerRequest_OCB->playHfAudio(ifaceAgAudioUpdate.scoStatus);
}

/* Entry action for state 'StreamingStarted'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted()
{
	/* Entry action for state 'StreamingStarted'. */
	ifaceSmHandler_OCB->updatePhoneCallAudioActive(true);
	internalEventQueue.push_back(new SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT(InternalSCI_GENERATE_CALL_STATE_EVENT));
}

/* Entry action for state 'StreamingStopped'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped()
{
	/* Entry action for state 'StreamingStopped'. */
	ifaceSmHandler_OCB->updatePhoneCallAudioActive(false);
	internalEventQueue.push_back(new SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT(InternalSCI_GENERATE_CALL_STATE_EVENT));
}

/* Entry action for state 'RequestPauseAudioStreaming'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming()
{
	/* Entry action for state 'RequestPauseAudioStreaming'. */
	ifaceAudioManagerRequest_OCB->pauseHfAudio();
}

/* Entry action for state 'StreamingPaused'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused()
{
	/* Entry action for state 'StreamingPaused'. */
	ifaceSmHandler_OCB->postSwitchToPassiveResponse((sc_string) "OK");
	ifaceSmHandler.isActiveDevice = true;
	internalEventQueue.push_back(new SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT(InternalSCI_GENERATE_CALL_STATE_EVENT));
}

/* Entry action for state 'RequestStopAudioRingtone'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone()
{
	/* Entry action for state 'RequestStopAudioRingtone'. */
	ifaceAudioManagerRequest_OCB->stopAudio();
	ifaceSmHandler.isActiveDevice = true;
}

/* Entry action for state 'WaitForCallStateEventToStartwaitingMode'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode()
{
	/* Entry action for state 'WaitForCallStateEventToStartwaitingMode'. */
	ifaceSmHandler_OCB->generateCallStateEvent();
}

/* Entry action for state 'WaitForSCO'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO()
{
	/* Entry action for state 'WaitForSCO'. */
	ifaceUserAction_OCB->postTransferAudio((sc_string) "HF");
}

/* Entry action for state 'WaitForStopAudioResponse'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse()
{
	/* Entry action for state 'WaitForStopAudioResponse'. */
	ifaceAudioManagerRequest_OCB->stopAudio();
}

/* Entry action for state 'ToStartWaitingMode'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode()
{
	/* Entry action for state 'ToStartWaitingMode'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_TO_START_WAITING_MODE(InternalSCI_TO_START_WAITING_MODE));
}

/* Entry action for state 'RequestStreamingAcceptingCall'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall()
{
	/* Entry action for state 'RequestStreamingAcceptingCall'. */
	ifaceAudioManagerRequest_OCB->playHfAudio(ifaceAgAudioUpdate.scoStatus);
}

/* Entry action for state 'WaitForStopAudioResponse'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse()
{
	/* Entry action for state 'WaitForStopAudioResponse'. */
	ifaceAudioManagerRequest_OCB->stopAudio();
}

/* Entry action for state 'StartToWaitingMode'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode()
{
	/* Entry action for state 'StartToWaitingMode'. */
	internalEventQueue.push_back(new SctEvent_InternalSCI_TO_START_WAITING_MODE(InternalSCI_TO_START_WAITING_MODE));
}

/* Entry action for state 'Incoming'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming()
{
	/* Entry action for state 'Incoming'. */
	ifaceSmHandler_OCB->updateCallStatus();
}

/* Entry action for state 'InbandCall'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall()
{
	/* Entry action for state 'InbandCall'. */
	ifaceAudioManagerRequest_OCB->requestPhoneAudio();
}

/* Entry action for state 'OutbandRinging'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging()
{
	/* Entry action for state 'OutbandRinging'. */
	ifaceAudioManagerRequest_OCB->playRingtone();
}

/* Entry action for state 'RequestPlayHfAudio'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio()
{
	/* Entry action for state 'RequestPlayHfAudio'. */
	ifaceAudioManagerRequest_OCB->playHfAudio(ifaceAgAudioUpdate.scoStatus);
}

/* Entry action for state 'PlayAudioFailure'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure()
{
	/* Entry action for state 'PlayAudioFailure'. */
	ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
}

/* Entry action for state 'InbandRingtoneStreaming'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming()
{
	/* Entry action for state 'InbandRingtoneStreaming'. */
	ifaceSmHandler_OCB->updatePhoneCallAudioActive(true);
}

/* Entry action for state 'WaitForSCOInSwitchToActive'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive()
{
	/* Entry action for state 'WaitForSCOInSwitchToActive'. */
	ifaceUserAction_OCB->postTransferAudio((sc_string) "HF");
}

/* Entry action for state 'AudioChannelDenied'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied()
{
	/* Entry action for state 'AudioChannelDenied'. */
	ifaceSmHandler_OCB->updateErrorStatus(PHONE_CHANNEL_DENIED_FOR_RINGTONE_ERROR);
}

/* Entry action for state 'WaitForCallStateEvent'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent()
{
	/* Entry action for state 'WaitForCallStateEvent'. */
	ifaceSmHandler_OCB->generateCallStateEvent();
}

/* Entry action for state 'RequestStopAudio'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio()
{
	/* Entry action for state 'RequestStopAudio'. */
	ifaceAudioManagerRequest_OCB->stopAudio();
}

/* Entry action for state 'Composite_WaitingMode'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode()
{
	/* Entry action for state 'Composite_WaitingMode'. */
	ifaceSmHandler_OCB->updateWaitingModeState(WAITING_MODE_STARTING);
}

/* Entry action for state 'WaitForAudioChannel'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel()
{
	/* Entry action for state 'WaitForAudioChannel'. */
	ifaceSmHandler_OCB->printPhoneAudioState(ifaceAudioManagerRequest.phoneAudioState);
	ifaceAudioManagerRequest_OCB->requestWaitingModeAudio();
}

/* Entry action for state 'RequestStreaming'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming()
{
	/* Entry action for state 'RequestStreaming'. */
	ifaceAudioManagerRequest_OCB->playWaitingModeTone(ifaceAgAudioUpdate.scoStatus);
}

/* Entry action for state 'StreamingStarted'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted()
{
	/* Entry action for state 'StreamingStarted'. */
	ifaceSmHandler_OCB->updateWaitingModeState(WAITING_MODE_ACTIVE);
}

/* Entry action for state 'RequestPhoneAudio'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio()
{
	/* Entry action for state 'RequestPhoneAudio'. */
	ifaceSmHandler_OCB->updateWaitingModeState(WAITING_MODE_STOPPING);
	ifaceAudioManagerRequest_OCB->requestPhoneAudio();
}

/* Entry action for state 'RequestingAudioChannel'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel()
{
	/* Entry action for state 'RequestingAudioChannel'. */
	ifaceAudioManagerRequest_OCB->requestWaitingModeAudio();
}

/* Entry action for state 'PostholdAndAcceptWaitingModeCall'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall()
{
	/* Entry action for state 'PostholdAndAcceptWaitingModeCall'. */
	ifaceSmHandler_OCB->holdAndAcceptWaitingModeCall();
}

/* Entry action for state 'RequestWaitingMode'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode()
{
	/* Entry action for state 'RequestWaitingMode'. */
	ifaceAudioManagerRequest_OCB->requestWaitingModeAudio();
}

/* Entry action for state 'PostAcceptWaitingModeCall'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall()
{
	/* Entry action for state 'PostAcceptWaitingModeCall'. */
	ifaceSmHandler_OCB->acceptWaitingModeCall();
}

/* Entry action for state 'WaitForAudioChannelForActiveCall'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall()
{
	/* Entry action for state 'WaitForAudioChannelForActiveCall'. */
	ifaceAudioManagerRequest_OCB->requestWaitingModeAudio();
}

/* Entry action for state 'RequestStopStreaming'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming()
{
	/* Entry action for state 'RequestStopStreaming'. */
	ifaceSmHandler_OCB->updateWaitingModeState(WAITING_MODE_STOPPING);
	ifaceAudioManagerRequest_OCB->stopAudio();
}

/* Entry action for state 'SendError'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError()
{
	/* Entry action for state 'SendError'. */
	ifaceSmHandler_OCB->traceMessage((sc_string) "ERROR:START_WAITING_MODE");
	internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
}

/* Entry action for state 'SwitchToPassive'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive()
{
	/* Entry action for state 'SwitchToPassive'. */
	ifaceSmHandler_OCB->updateWaitingModeState(WAITING_MODE_STOPPING);
	ifaceAudioManagerRequest_OCB->requestPhoneAudio();
}

/* Entry action for state 'RequestWaitingModeAccepting'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting()
{
	/* Entry action for state 'RequestWaitingModeAccepting'. */
	ifaceAudioManagerRequest_OCB->requestWaitingModeAudio();
}

/* Entry action for state 'WaitingModeChannelDenied'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied()
{
	/* Entry action for state 'WaitingModeChannelDenied'. */
	ifaceSmHandler_OCB->updateErrorStatus(WAITINGMODE_CHANNEL_DENIED_ERROR);
	internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
}

/* Entry action for state 'AcceptWaitingCall'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall()
{
	/* Entry action for state 'AcceptWaitingCall'. */
	ifaceUserAction_OCB->postHoldAndAcceptCall();
}

/* Entry action for state 'Idle'. */
void PmCallStateHandlerSm::enact_Main_region_CallHandlerSm_CallHandler_region_Idle()
{
	/* Entry action for state 'Idle'. */
	ifaceSmHandler_OCB->updateCallStatus();
	ifaceSmHandler_OCB->acceptCallFinished();
	ifaceAudioManagerRequest.phoneAudioState = PHONE_AUDIO_CHANNEL_IDLE;
	ifaceSmHandler_OCB->generateCallStateEvent();
}

/* Exit action for state 'AcceptingCall'. */
void PmCallStateHandlerSm::exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall()
{
	/* Exit action for state 'AcceptingCall'. */
	ifaceSmHandler_OCB->acceptCallFinished();
}

/* Exit action for state 'Composite_WaitingMode'. */
void PmCallStateHandlerSm::exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode()
{
	/* Exit action for state 'Composite_WaitingMode'. */
	ifaceSmHandler_OCB->updateWaitingModeState(WAITING_MODE_IDLE);
	ifaceSmHandler_OCB->acceptCallFinished();
}

/* 'Entry_WaitForCallStateEventToStartwaitingMode' enter sequence for state AudioHandling */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_Entry_WaitForCallStateEventToStartwaitingMode()
{
	/* 'Entry_WaitForCallStateEventToStartwaitingMode' enter sequence for state AudioHandling */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForCallStateEventToStartwaitingMode();
}

/* 'Entry_WaitForStopAudioResponse' enter sequence for state AudioHandling */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_Entry_WaitForStopAudioResponse()
{
	/* 'Entry_WaitForStopAudioResponse' enter sequence for state AudioHandling */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForStopAudioResponse();
}

/* 'TransferAudioToHFEntry' enter sequence for state AudioHandling */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_TransferAudioToHFEntry()
{
	/* 'TransferAudioToHFEntry' enter sequence for state AudioHandling */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_TransferAudioToHFEntry();
}

/* 'default' enter sequence for state AudioHandling */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default()
{
	/* 'default' enter sequence for state AudioHandling */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_default();
}

/* 'default' enter sequence for state RequestPhoneAudio */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_default()
{
	/* 'default' enter sequence for state RequestPhoneAudio */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestStreaming */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming_default()
{
	/* 'default' enter sequence for state RequestStreaming */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StreamingStarted */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted_default()
{
	/* 'default' enter sequence for state StreamingStarted */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StreamingStopped */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped_default()
{
	/* 'default' enter sequence for state StreamingStopped */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForPrepareChannelResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse_default()
{
	/* 'default' enter sequence for state WaitForPrepareChannelResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestPauseAudioStreaming */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming_default()
{
	/* 'default' enter sequence for state RequestPauseAudioStreaming */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StreamingPaused */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused_default()
{
	/* 'default' enter sequence for state StreamingPaused */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestStopAudioRingtone */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone_default()
{
	/* 'default' enter sequence for state RequestStopAudioRingtone */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForCallStateEventToStartwaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode_default()
{
	/* 'default' enter sequence for state WaitForCallStateEventToStartwaitingMode */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCO */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO_default()
{
	/* 'default' enter sequence for state WaitForSCO */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCODisconnection */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection_default()
{
	/* 'default' enter sequence for state WaitForSCODisconnection */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStartAudioResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse_default()
{
	/* 'default' enter sequence for state WaitForStartAudioResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'Entry_ReceivedActiveCallStatus' enter sequence for state AcceptingCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_ReceivedActiveCallStatus()
{
	/* 'Entry_ReceivedActiveCallStatus' enter sequence for state AcceptingCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_ReceivedActiveCallStatus();
}

/* 'Entry_StartWaitingModeAfterAcceptResponse' enter sequence for state AcceptingCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_StartWaitingModeAfterAcceptResponse()
{
	/* 'Entry_StartWaitingModeAfterAcceptResponse' enter sequence for state AcceptingCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_StartWaitingModeAfterAcceptResponse();
}

/* 'Entry_WaitForActiveCallStatus' enter sequence for state AcceptingCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_WaitForActiveCallStatus()
{
	/* 'Entry_WaitForActiveCallStatus' enter sequence for state AcceptingCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForActiveCallStatus();
}

/* 'Entry_WaitForAudioChannelInband' enter sequence for state AcceptingCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_WaitForAudioChannelInband()
{
	/* 'Entry_WaitForAudioChannelInband' enter sequence for state AcceptingCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelInband();
}

/* 'Entry_WaitForAudioChannelOutband' enter sequence for state AcceptingCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_WaitForAudioChannelOutband()
{
	/* 'Entry_WaitForAudioChannelOutband' enter sequence for state AcceptingCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelOutband();
}

/* 'default' enter sequence for state WaitForAudioChannel */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel_default()
{
	/* 'default' enter sequence for state WaitForAudioChannel */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel;
	stateConfVectorPosition = 0;
}

/* 'EntryToWaitForChannelAllocation' enter sequence for state InbandAcceptCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_EntryToWaitForChannelAllocation()
{
	/* 'EntryToWaitForChannelAllocation' enter sequence for state InbandAcceptCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_EntryToWaitForChannelAllocation();
}

/* 'default' enter sequence for state InbandAcceptCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_default()
{
	/* 'default' enter sequence for state InbandAcceptCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_default();
}

/* 'default' enter sequence for state WaitForActiveCallStatus */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus_default()
{
	/* 'default' enter sequence for state WaitForActiveCallStatus */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ReceivedActiveCallStatus */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_default()
{
	/* 'default' enter sequence for state ReceivedActiveCallStatus */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForChannelAllocation */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation_default()
{
	/* 'default' enter sequence for state WaitForChannelAllocation */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponse */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponseToAcceptCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponseToAcceptCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ToStartWaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode_default()
{
	/* 'default' enter sequence for state ToStartWaitingMode */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForAcceptCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall_default()
{
	/* 'default' enter sequence for state WaitForAcceptCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StartWaitingModeAfterAcceptResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse_default()
{
	/* 'default' enter sequence for state StartWaitingModeAfterAcceptResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestStreamingAcceptingCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall_default()
{
	/* 'default' enter sequence for state RequestStreamingAcceptingCall */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StartWaitingModeAfterChannelAllocation */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation_default()
{
	/* 'default' enter sequence for state StartWaitingModeAfterChannelAllocation */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponse */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponseToAcceptCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponseToAcceptCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StartToWaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode_default()
{
	/* 'default' enter sequence for state StartToWaitingMode */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForAcceptCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall_default()
{
	/* 'default' enter sequence for state WaitForAcceptCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall;
	stateConfVectorPosition = 0;
}

/* 'EntryToInbandCall' enter sequence for state Incoming */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_EntryToInbandCall()
{
	/* 'EntryToInbandCall' enter sequence for state Incoming */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_EntryToInbandCall();
}

/* 'Entry_ActiveCallStatus' enter sequence for state Incoming */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_Entry_ActiveCallStatus()
{
	/* 'Entry_ActiveCallStatus' enter sequence for state Incoming */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Entry_ActiveCallStatus();
}

/* 'default' enter sequence for state Incoming */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_default()
{
	/* 'default' enter sequence for state Incoming */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_default();
}

/* 'default' enter sequence for state InbandCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_default()
{
	/* 'default' enter sequence for state InbandCall */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCO */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO_default()
{
	/* 'default' enter sequence for state WaitForSCO */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponseOutband */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponseOutband */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForAudioResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse_default()
{
	/* 'default' enter sequence for state WaitForAudioResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'EntryToNoRinging' enter sequence for state OutbandCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_EntryToNoRinging()
{
	/* 'EntryToNoRinging' enter sequence for state OutbandCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_EntryToNoRinging();
}

/* 'default' enter sequence for state OutbandCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_default()
{
	/* 'default' enter sequence for state OutbandCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_default();
}

/* 'default' enter sequence for state OutbandCallNoRinging */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging_default()
{
	/* 'default' enter sequence for state OutbandCallNoRinging */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state OutbandRinging */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging_default()
{
	/* 'default' enter sequence for state OutbandRinging */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging;
	stateConfVectorPosition = 0;
}

/* 'EntryToNoRinging' enter sequence for state InbandRinging */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_EntryToNoRinging()
{
	/* 'EntryToNoRinging' enter sequence for state InbandRinging */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_EntryToNoRinging();
}

/* 'default' enter sequence for state InbandRinging */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_default()
{
	/* 'default' enter sequence for state InbandRinging */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_default();
}

/* 'default' enter sequence for state RequestPlayHfAudio */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio_default()
{
	/* 'default' enter sequence for state RequestPlayHfAudio */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state InbandCallNoRinging */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging_default()
{
	/* 'default' enter sequence for state InbandCallNoRinging */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PlayAudioFailure */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure_default()
{
	/* 'default' enter sequence for state PlayAudioFailure */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCO */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO_default()
{
	/* 'default' enter sequence for state WaitForSCO */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state InbandRingtoneStreaming */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming_default()
{
	/* 'default' enter sequence for state InbandRingtoneStreaming */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCOInSwitchToActive */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive_default()
{
	/* 'default' enter sequence for state WaitForSCOInSwitchToActive */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AudioChannelDenied */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied_default()
{
	/* 'default' enter sequence for state AudioChannelDenied */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponseOutbandToAcceptCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponseOutbandToAcceptCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponseToAcceptCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponseToAcceptCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForCallStateEvent */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent_default()
{
	/* 'default' enter sequence for state WaitForCallStateEvent */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Disconnecting */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_default()
{
	/* 'default' enter sequence for state Disconnecting */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_default();
}

/* 'default' enter sequence for state WaitForStopResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse_default()
{
	/* 'default' enter sequence for state WaitForStopResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestStopAudio */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio_default()
{
	/* 'default' enter sequence for state RequestStopAudio */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCORelease */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease_default()
{
	/* 'default' enter sequence for state WaitForSCORelease */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ActiveCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_default()
{
	/* 'default' enter sequence for state ActiveCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_default();
}

/* 'default' enter sequence for state WaitForAudioEventActiveCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall_default()
{
	/* 'default' enter sequence for state WaitForAudioEventActiveCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall;
	stateConfVectorPosition = 0;
}

/* 'DialedFromPhone' enter sequence for state Outgoing */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_DialedFromPhone()
{
	/* 'DialedFromPhone' enter sequence for state Outgoing */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_DialedFromPhone();
}

/* 'default' enter sequence for state Outgoing */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_default()
{
	/* 'default' enter sequence for state Outgoing */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_default();
}

/* 'default' enter sequence for state WaitForDialResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse_default()
{
	/* 'default' enter sequence for state WaitForDialResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCO */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO_default()
{
	/* 'default' enter sequence for state WaitForSCO */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state CancelOutgoingCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall_default()
{
	/* 'default' enter sequence for state CancelOutgoingCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall;
	stateConfVectorPosition = 0;
}

/* 'Entry_Accepting' enter sequence for state Composite_WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_Accepting()
{
	/* 'Entry_Accepting' enter sequence for state Composite_WaitingMode */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Accepting();
}

/* 'Entry_ActiveCall' enter sequence for state Composite_WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_ActiveCall()
{
	/* 'Entry_ActiveCall' enter sequence for state Composite_WaitingMode */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_ActiveCall();
}

/* 'Entry_AudioHandling' enter sequence for state Composite_WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_AudioHandling()
{
	/* 'Entry_AudioHandling' enter sequence for state Composite_WaitingMode */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_AudioHandling();
}

/* 'Entry_Ringing' enter sequence for state Composite_WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_Ringing()
{
	/* 'Entry_Ringing' enter sequence for state Composite_WaitingMode */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Ringing();
}

/* 'Entry_XCallOutgoingOrWaiting' enter sequence for state Composite_WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_Entry_XCallOutgoingOrWaiting()
{
	/* 'Entry_XCallOutgoingOrWaiting' enter sequence for state Composite_WaitingMode */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_XCallOutgoingOrWaiting();
}

/* 'EntryFromAccepting' enter sequence for state WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromAccepting()
{
	/* 'EntryFromAccepting' enter sequence for state WaitingMode */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAccepting();
}

/* 'EntryFromActiveCall' enter sequence for state WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromActiveCall()
{
	/* 'EntryFromActiveCall' enter sequence for state WaitingMode */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromActiveCall();
}

/* 'EntryFromAudioHandling' enter sequence for state WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromAudioHandling()
{
	/* 'EntryFromAudioHandling' enter sequence for state WaitingMode */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAudioHandling();
}

/* 'EntryFromRinging' enter sequence for state WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromRinging()
{
	/* 'EntryFromRinging' enter sequence for state WaitingMode */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromRinging();
}

/* 'EntryFromXCallOutgoingOrWaiting' enter sequence for state WaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromXCallOutgoingOrWaiting()
{
	/* 'EntryFromXCallOutgoingOrWaiting' enter sequence for state WaitingMode */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromXCallOutgoingOrWaiting();
}

/* 'default' enter sequence for state WaitForAudioChannel */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel_default()
{
	/* 'default' enter sequence for state WaitForAudioChannel */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestStreaming */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming_default()
{
	/* 'default' enter sequence for state RequestStreaming */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state StreamingStarted */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted_default()
{
	/* 'default' enter sequence for state StreamingStarted */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestPhoneAudio */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio_default()
{
	/* 'default' enter sequence for state RequestPhoneAudio */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestingAudioChannel */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel_default()
{
	/* 'default' enter sequence for state RequestingAudioChannel */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PostholdAndAcceptWaitingModeCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall_default()
{
	/* 'default' enter sequence for state PostholdAndAcceptWaitingModeCall */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponseAudioHandling */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponseAudioHandling */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCO */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO_default()
{
	/* 'default' enter sequence for state WaitForSCO */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestWaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode_default()
{
	/* 'default' enter sequence for state RequestWaitingMode */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state PostAcceptWaitingModeCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall_default()
{
	/* 'default' enter sequence for state PostAcceptWaitingModeCall */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForSCORinging */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging_default()
{
	/* 'default' enter sequence for state WaitForSCORinging */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestStreamingRinging */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging_default()
{
	/* 'default' enter sequence for state RequestStreamingRinging */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForAudioChannelForActiveCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall_default()
{
	/* 'default' enter sequence for state WaitForAudioChannelForActiveCall */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestStopStreaming */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming_default()
{
	/* 'default' enter sequence for state RequestStopStreaming */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state SendError */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError_default()
{
	/* 'default' enter sequence for state SendError */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state SwitchToPassive */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive_default()
{
	/* 'default' enter sequence for state SwitchToPassive */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state RequestWaitingModeAccepting */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting_default()
{
	/* 'default' enter sequence for state RequestWaitingModeAccepting */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state ReceivedTimerCallback */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback_default()
{
	/* 'default' enter sequence for state ReceivedTimerCallback */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForWaitModeChannelAfterTimerExpiry */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry_default()
{
	/* 'default' enter sequence for state WaitForWaitModeChannelAfterTimerExpiry */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponseXCallOutgoingOrWaiting */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponseXCallOutgoingOrWaiting */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForStopAudioResponseActiveCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall_default()
{
	/* 'default' enter sequence for state WaitForStopAudioResponseActiveCall */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitingModeChannelDenied */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied_default()
{
	/* 'default' enter sequence for state WaitingModeChannelDenied */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForWaitingmodeChannelResponseToStopWaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode_default()
{
	/* 'default' enter sequence for state WaitForWaitingmodeChannelResponseToStopWaitingMode */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForPhoneChannelResponseToStartWaitingMode */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode_default()
{
	/* 'default' enter sequence for state WaitForPhoneChannelResponseToStartWaitingMode */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Composite_XCallOutgoingOrWaiting */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_default()
{
	/* 'default' enter sequence for state Composite_XCallOutgoingOrWaiting */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_default();
}

/* 'Entry_AcceptWaitingCall' enter sequence for state XCallOutgoingOrWaiting */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_Entry_AcceptWaitingCall()
{
	/* 'Entry_AcceptWaitingCall' enter sequence for state XCallOutgoingOrWaiting */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_AcceptWaitingCall();
}

/* 'Entry_HandlingHangup' enter sequence for state XCallOutgoingOrWaiting */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_Entry_HandlingHangup()
{
	/* 'Entry_HandlingHangup' enter sequence for state XCallOutgoingOrWaiting */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_HandlingHangup();
}

/* 'default' enter sequence for state XCallOutgoingOrWaiting */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_default()
{
	/* 'default' enter sequence for state XCallOutgoingOrWaiting */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_default();
}

/* 'default' enter sequence for state HandlingHangup */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_default()
{
	/* 'default' enter sequence for state HandlingHangup */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_default();
}

/* 'default' enter sequence for state WaitForHangupResponse */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse_default()
{
	/* 'default' enter sequence for state WaitForHangupResponse */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AcceptAfterHangup */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup_default()
{
	/* 'default' enter sequence for state AcceptAfterHangup */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state WaitForAudioEventXCallOutgoingOrWaiting */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting_default()
{
	/* 'default' enter sequence for state WaitForAudioEventXCallOutgoingOrWaiting */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state AcceptWaitingCall */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall_default()
{
	/* 'default' enter sequence for state AcceptWaitingCall */
	enact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for state Idle */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_Idle_default()
{
	/* 'default' enter sequence for state Idle */
	enact_Main_region_CallHandlerSm_CallHandler_region_Idle();
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_Idle);
	}
	stateConfVector[0] = Main_region_CallHandlerSm_CallHandler_region_Idle;
	stateConfVectorPosition = 0;
}

/* 'default' enter sequence for region Main_region */
void PmCallStateHandlerSm::enseq_Main_region_default()
{
	/* 'default' enter sequence for region Main_region */
	react_Main_region__entry_Default();
}

/* 'default' enter sequence for region audiohandling_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_default()
{
	/* 'default' enter sequence for region audiohandling_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__entry_Default();
}

/* 'Entry_WaitForStopAudioResponse' enter sequence for region audiohandling_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForStopAudioResponse()
{
	/* 'Entry_WaitForStopAudioResponse' enter sequence for region audiohandling_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForStopAudioResponse();
}

/* 'Entry_WaitForCallStateEventToStartwaitingMode' enter sequence for region audiohandling_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForCallStateEventToStartwaitingMode()
{
	/* 'Entry_WaitForCallStateEventToStartwaitingMode' enter sequence for region audiohandling_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForCallStateEventToStartwaitingMode();
}

/* 'TransferAudioToHFEntry' enter sequence for region audiohandling_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_TransferAudioToHFEntry()
{
	/* 'TransferAudioToHFEntry' enter sequence for region audiohandling_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_TransferAudioToHFEntry();
}

/* 'Entry_WaitForAudioChannelOutband' enter sequence for region acceptingCall_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelOutband()
{
	/* 'Entry_WaitForAudioChannelOutband' enter sequence for region acceptingCall_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelOutband();
}

/* 'Entry_WaitForAudioChannelInband' enter sequence for region acceptingCall_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelInband()
{
	/* 'Entry_WaitForAudioChannelInband' enter sequence for region acceptingCall_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelInband();
}

/* 'Entry_WaitForActiveCallStatus' enter sequence for region acceptingCall_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForActiveCallStatus()
{
	/* 'Entry_WaitForActiveCallStatus' enter sequence for region acceptingCall_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForActiveCallStatus();
}

/* 'Entry_ReceivedActiveCallStatus' enter sequence for region acceptingCall_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_ReceivedActiveCallStatus()
{
	/* 'Entry_ReceivedActiveCallStatus' enter sequence for region acceptingCall_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_ReceivedActiveCallStatus();
}

/* 'Entry_StartWaitingModeAfterAcceptResponse' enter sequence for region acceptingCall_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_StartWaitingModeAfterAcceptResponse()
{
	/* 'Entry_StartWaitingModeAfterAcceptResponse' enter sequence for region acceptingCall_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_StartWaitingModeAfterAcceptResponse();
}

/* 'default' enter sequence for region inbandacceptcall_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_default()
{
	/* 'default' enter sequence for region inbandacceptcall_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region__entry_Default();
}

/* 'EntryToWaitForChannelAllocation' enter sequence for region inbandacceptcall_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_EntryToWaitForChannelAllocation()
{
	/* 'EntryToWaitForChannelAllocation' enter sequence for region inbandacceptcall_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_EntryToWaitForChannelAllocation();
}

/* 'default' enter sequence for region incoming_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_default()
{
	/* 'default' enter sequence for region incoming_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__entry_Default();
}

/* 'EntryToInbandCall' enter sequence for region incoming_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_EntryToInbandCall()
{
	/* 'EntryToInbandCall' enter sequence for region incoming_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_EntryToInbandCall();
}

/* 'Entry_ActiveCallStatus' enter sequence for region incoming_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Entry_ActiveCallStatus()
{
	/* 'Entry_ActiveCallStatus' enter sequence for region incoming_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Entry_ActiveCallStatus();
}

/* 'default' enter sequence for region outbandringing_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_default()
{
	/* 'default' enter sequence for region outbandringing_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region__entry_Default();
}

/* 'EntryToNoRinging' enter sequence for region outbandringing_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_EntryToNoRinging()
{
	/* 'EntryToNoRinging' enter sequence for region outbandringing_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_EntryToNoRinging();
}

/* 'default' enter sequence for region Inbandringing_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_default()
{
	/* 'default' enter sequence for region Inbandringing_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__entry_Default();
}

/* 'EntryToNoRinging' enter sequence for region Inbandringing_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_EntryToNoRinging()
{
	/* 'EntryToNoRinging' enter sequence for region Inbandringing_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_EntryToNoRinging();
}

/* 'default' enter sequence for region disconnecting_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_default()
{
	/* 'default' enter sequence for region disconnecting_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__entry_Default();
}

/* 'default' enter sequence for region activecall_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_default()
{
	/* 'default' enter sequence for region activecall_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region__entry_Default();
}

/* 'default' enter sequence for region outgoing_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_default()
{
	/* 'default' enter sequence for region outgoing_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__entry_Default();
}

/* 'DialedFromPhone' enter sequence for region outgoing_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_DialedFromPhone()
{
	/* 'DialedFromPhone' enter sequence for region outgoing_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_DialedFromPhone();
}

/* 'Entry_AudioHandling' enter sequence for region inner region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_AudioHandling()
{
	/* 'Entry_AudioHandling' enter sequence for region inner region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_AudioHandling();
}

/* 'Entry_Ringing' enter sequence for region inner region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Ringing()
{
	/* 'Entry_Ringing' enter sequence for region inner region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Ringing();
}

/* 'Entry_ActiveCall' enter sequence for region inner region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_ActiveCall()
{
	/* 'Entry_ActiveCall' enter sequence for region inner region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_ActiveCall();
}

/* 'Entry_XCallOutgoingOrWaiting' enter sequence for region inner region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_XCallOutgoingOrWaiting()
{
	/* 'Entry_XCallOutgoingOrWaiting' enter sequence for region inner region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_XCallOutgoingOrWaiting();
}

/* 'Entry_Accepting' enter sequence for region inner region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Accepting()
{
	/* 'Entry_Accepting' enter sequence for region inner region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Accepting();
}

/* 'EntryFromXCallOutgoingOrWaiting' enter sequence for region waitingmode_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromXCallOutgoingOrWaiting()
{
	/* 'EntryFromXCallOutgoingOrWaiting' enter sequence for region waitingmode_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromXCallOutgoingOrWaiting();
}

/* 'EntryFromRinging' enter sequence for region waitingmode_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromRinging()
{
	/* 'EntryFromRinging' enter sequence for region waitingmode_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromRinging();
}

/* 'EntryFromActiveCall' enter sequence for region waitingmode_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromActiveCall()
{
	/* 'EntryFromActiveCall' enter sequence for region waitingmode_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromActiveCall();
}

/* 'EntryFromAccepting' enter sequence for region waitingmode_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAccepting()
{
	/* 'EntryFromAccepting' enter sequence for region waitingmode_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAccepting();
}

/* 'EntryFromAudioHandling' enter sequence for region waitingmode_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAudioHandling()
{
	/* 'EntryFromAudioHandling' enter sequence for region waitingmode_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAudioHandling();
}

/* 'default' enter sequence for region inner region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_default()
{
	/* 'default' enter sequence for region inner region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region__entry_Default();
}

/* 'default' enter sequence for region waitingordialing_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_default()
{
	/* 'default' enter sequence for region waitingordialing_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region__entry_Default();
}

/* 'Entry_HandlingHangup' enter sequence for region waitingordialing_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_HandlingHangup()
{
	/* 'Entry_HandlingHangup' enter sequence for region waitingordialing_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_HandlingHangup();
}

/* 'Entry_AcceptWaitingCall' enter sequence for region waitingordialing_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_AcceptWaitingCall()
{
	/* 'Entry_AcceptWaitingCall' enter sequence for region waitingordialing_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_AcceptWaitingCall();
}

/* 'default' enter sequence for region HandlingHangup_region */
void PmCallStateHandlerSm::enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_default()
{
	/* 'default' enter sequence for region HandlingHangup_region */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region__entry_Default();
}

/* Default exit sequence for state SingleCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall()
{
	/* Default exit sequence for state SingleCall */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region();
}

/* Default exit sequence for state AudioHandling */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling()
{
	/* Default exit sequence for state AudioHandling */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region();
}

/* Default exit sequence for state RequestPhoneAudio */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio()
{
	/* Default exit sequence for state RequestPhoneAudio */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestStreaming */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming()
{
	/* Default exit sequence for state RequestStreaming */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StreamingStarted */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted()
{
	/* Default exit sequence for state StreamingStarted */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StreamingStopped */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped()
{
	/* Default exit sequence for state StreamingStopped */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForPrepareChannelResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse()
{
	/* Default exit sequence for state WaitForPrepareChannelResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse()
{
	/* Default exit sequence for state WaitForStopAudioResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestPauseAudioStreaming */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming()
{
	/* Default exit sequence for state RequestPauseAudioStreaming */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StreamingPaused */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused()
{
	/* Default exit sequence for state StreamingPaused */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestStopAudioRingtone */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone()
{
	/* Default exit sequence for state RequestStopAudioRingtone */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForCallStateEventToStartwaitingMode */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode()
{
	/* Default exit sequence for state WaitForCallStateEventToStartwaitingMode */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCO */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO()
{
	/* Default exit sequence for state WaitForSCO */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCODisconnection */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection()
{
	/* Default exit sequence for state WaitForSCODisconnection */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStartAudioResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse()
{
	/* Default exit sequence for state WaitForStartAudioResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AcceptingCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall()
{
	/* Default exit sequence for state AcceptingCall */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region();
	exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
}

/* Default exit sequence for state WaitForAudioChannel */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel()
{
	/* Default exit sequence for state WaitForAudioChannel */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state InbandAcceptCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall()
{
	/* Default exit sequence for state InbandAcceptCall */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region();
}

/* Default exit sequence for state WaitForActiveCallStatus */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus()
{
	/* Default exit sequence for state WaitForActiveCallStatus */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ReceivedActiveCallStatus */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus()
{
	/* Default exit sequence for state ReceivedActiveCallStatus */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForChannelAllocation */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation()
{
	/* Default exit sequence for state WaitForChannelAllocation */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse()
{
	/* Default exit sequence for state WaitForStopAudioResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponseToAcceptCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall()
{
	/* Default exit sequence for state WaitForStopAudioResponseToAcceptCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ToStartWaitingMode */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode()
{
	/* Default exit sequence for state ToStartWaitingMode */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForAcceptCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall()
{
	/* Default exit sequence for state WaitForAcceptCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StartWaitingModeAfterAcceptResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse()
{
	/* Default exit sequence for state StartWaitingModeAfterAcceptResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestStreamingAcceptingCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall()
{
	/* Default exit sequence for state RequestStreamingAcceptingCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StartWaitingModeAfterChannelAllocation */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation()
{
	/* Default exit sequence for state StartWaitingModeAfterChannelAllocation */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse()
{
	/* Default exit sequence for state WaitForStopAudioResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponseToAcceptCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall()
{
	/* Default exit sequence for state WaitForStopAudioResponseToAcceptCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StartToWaitingMode */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode()
{
	/* Default exit sequence for state StartToWaitingMode */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForAcceptCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall()
{
	/* Default exit sequence for state WaitForAcceptCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Incoming */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming()
{
	/* Default exit sequence for state Incoming */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region();
}

/* Default exit sequence for state InbandCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall()
{
	/* Default exit sequence for state InbandCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCO */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO()
{
	/* Default exit sequence for state WaitForSCO */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse()
{
	/* Default exit sequence for state WaitForStopAudioResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponseOutband */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband()
{
	/* Default exit sequence for state WaitForStopAudioResponseOutband */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForAudioResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse()
{
	/* Default exit sequence for state WaitForAudioResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state OutbandCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall()
{
	/* Default exit sequence for state OutbandCall */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region();
}

/* Default exit sequence for state OutbandCallNoRinging */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging()
{
	/* Default exit sequence for state OutbandCallNoRinging */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state OutbandRinging */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging()
{
	/* Default exit sequence for state OutbandRinging */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state InbandRinging */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging()
{
	/* Default exit sequence for state InbandRinging */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region();
}

/* Default exit sequence for state RequestPlayHfAudio */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio()
{
	/* Default exit sequence for state RequestPlayHfAudio */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state InbandCallNoRinging */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging()
{
	/* Default exit sequence for state InbandCallNoRinging */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PlayAudioFailure */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure()
{
	/* Default exit sequence for state PlayAudioFailure */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse()
{
	/* Default exit sequence for state WaitForStopAudioResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCO */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO()
{
	/* Default exit sequence for state WaitForSCO */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state InbandRingtoneStreaming */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming()
{
	/* Default exit sequence for state InbandRingtoneStreaming */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCOInSwitchToActive */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive()
{
	/* Default exit sequence for state WaitForSCOInSwitchToActive */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AudioChannelDenied */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied()
{
	/* Default exit sequence for state AudioChannelDenied */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponseOutbandToAcceptCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall()
{
	/* Default exit sequence for state WaitForStopAudioResponseOutbandToAcceptCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponseToAcceptCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall()
{
	/* Default exit sequence for state WaitForStopAudioResponseToAcceptCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForCallStateEvent */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent()
{
	/* Default exit sequence for state WaitForCallStateEvent */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Disconnecting */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting()
{
	/* Default exit sequence for state Disconnecting */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region();
}

/* Default exit sequence for state WaitForStopResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse()
{
	/* Default exit sequence for state WaitForStopResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestStopAudio */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio()
{
	/* Default exit sequence for state RequestStopAudio */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCORelease */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease()
{
	/* Default exit sequence for state WaitForSCORelease */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ActiveCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall()
{
	/* Default exit sequence for state ActiveCall */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region();
}

/* Default exit sequence for state WaitForAudioEventActiveCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall()
{
	/* Default exit sequence for state WaitForAudioEventActiveCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Outgoing */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing()
{
	/* Default exit sequence for state Outgoing */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region();
}

/* Default exit sequence for state WaitForDialResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse()
{
	/* Default exit sequence for state WaitForDialResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCO */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO()
{
	/* Default exit sequence for state WaitForSCO */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state CancelOutgoingCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall()
{
	/* Default exit sequence for state CancelOutgoingCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Composite_WaitingMode */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode()
{
	/* Default exit sequence for state Composite_WaitingMode */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region();
	exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
}

/* Default exit sequence for state WaitingMode */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode()
{
	/* Default exit sequence for state WaitingMode */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region();
}

/* Default exit sequence for state WaitForAudioChannel */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel()
{
	/* Default exit sequence for state WaitForAudioChannel */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestStreaming */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming()
{
	/* Default exit sequence for state RequestStreaming */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state StreamingStarted */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted()
{
	/* Default exit sequence for state StreamingStarted */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestPhoneAudio */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio()
{
	/* Default exit sequence for state RequestPhoneAudio */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestingAudioChannel */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel()
{
	/* Default exit sequence for state RequestingAudioChannel */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PostholdAndAcceptWaitingModeCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall()
{
	/* Default exit sequence for state PostholdAndAcceptWaitingModeCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponseAudioHandling */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling()
{
	/* Default exit sequence for state WaitForStopAudioResponseAudioHandling */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCO */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO()
{
	/* Default exit sequence for state WaitForSCO */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestWaitingMode */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode()
{
	/* Default exit sequence for state RequestWaitingMode */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state PostAcceptWaitingModeCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall()
{
	/* Default exit sequence for state PostAcceptWaitingModeCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForSCORinging */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging()
{
	/* Default exit sequence for state WaitForSCORinging */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestStreamingRinging */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging()
{
	/* Default exit sequence for state RequestStreamingRinging */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForAudioChannelForActiveCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall()
{
	/* Default exit sequence for state WaitForAudioChannelForActiveCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestStopStreaming */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming()
{
	/* Default exit sequence for state RequestStopStreaming */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state SendError */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError()
{
	/* Default exit sequence for state SendError */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state SwitchToPassive */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive()
{
	/* Default exit sequence for state SwitchToPassive */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state RequestWaitingModeAccepting */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting()
{
	/* Default exit sequence for state RequestWaitingModeAccepting */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state ReceivedTimerCallback */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback()
{
	/* Default exit sequence for state ReceivedTimerCallback */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForWaitModeChannelAfterTimerExpiry */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry()
{
	/* Default exit sequence for state WaitForWaitModeChannelAfterTimerExpiry */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponseXCallOutgoingOrWaiting */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting()
{
	/* Default exit sequence for state WaitForStopAudioResponseXCallOutgoingOrWaiting */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForStopAudioResponseActiveCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall()
{
	/* Default exit sequence for state WaitForStopAudioResponseActiveCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitingModeChannelDenied */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied()
{
	/* Default exit sequence for state WaitingModeChannelDenied */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForWaitingmodeChannelResponseToStopWaitingMode */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode()
{
	/* Default exit sequence for state WaitForWaitingmodeChannelResponseToStopWaitingMode */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForPhoneChannelResponseToStartWaitingMode */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode()
{
	/* Default exit sequence for state WaitForPhoneChannelResponseToStartWaitingMode */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Composite_XCallOutgoingOrWaiting */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting()
{
	/* Default exit sequence for state Composite_XCallOutgoingOrWaiting */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region();
}

/* Default exit sequence for state XCallOutgoingOrWaiting */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting()
{
	/* Default exit sequence for state XCallOutgoingOrWaiting */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region();
}

/* Default exit sequence for state HandlingHangup */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup()
{
	/* Default exit sequence for state HandlingHangup */
	exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region();
}

/* Default exit sequence for state WaitForHangupResponse */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse()
{
	/* Default exit sequence for state WaitForHangupResponse */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AcceptAfterHangup */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup()
{
	/* Default exit sequence for state AcceptAfterHangup */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state WaitForAudioEventXCallOutgoingOrWaiting */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting()
{
	/* Default exit sequence for state WaitForAudioEventXCallOutgoingOrWaiting */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state AcceptWaitingCall */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall()
{
	/* Default exit sequence for state AcceptWaitingCall */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for state Idle */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_Idle()
{
	/* Default exit sequence for state Idle */
	stateConfVector[0] = PmCallStateHandlerSm_last_state;
	stateConfVectorPosition = 0;
}

/* Default exit sequence for region Main_region */
void PmCallStateHandlerSm::exseq_Main_region()
{
	/* Default exit sequence for region Main_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_Idle :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region CallHandler_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region()
{
	/* Default exit sequence for region CallHandler_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_Idle :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region SingleCall_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region()
{
	/* Default exit sequence for region SingleCall_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode();
			exact_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region audiohandling_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region()
{
	/* Default exit sequence for region audiohandling_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.AudioHandling.audiohandling_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region acceptingCall_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region()
{
	/* Default exit sequence for region acceptingCall_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.AcceptingCall.acceptingCall_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region inbandacceptcall_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region()
{
	/* Default exit sequence for region inbandacceptcall_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.AcceptingCall.acceptingCall_region.InbandAcceptCall.inbandacceptcall_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region incoming_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region()
{
	/* Default exit sequence for region incoming_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Incoming.incoming_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region outbandringing_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region()
{
	/* Default exit sequence for region outbandringing_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Incoming.incoming_region.OutbandCall.outbandringing_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region Inbandringing_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region()
{
	/* Default exit sequence for region Inbandringing_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Incoming.incoming_region.InbandRinging.Inbandringing_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region disconnecting_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region()
{
	/* Default exit sequence for region disconnecting_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Disconnecting.disconnecting_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region activecall_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region()
{
	/* Default exit sequence for region activecall_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.ActiveCall.activecall_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region outgoing_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region()
{
	/* Default exit sequence for region outgoing_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Outgoing.outgoing_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region inner region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region()
{
	/* Default exit sequence for region inner region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Composite_WaitingMode.inner_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region waitingmode_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region()
{
	/* Default exit sequence for region waitingmode_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Composite_WaitingMode.inner_region.WaitingMode.waitingmode_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region inner region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region()
{
	/* Default exit sequence for region inner region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Composite_XCallOutgoingOrWaiting.inner_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region waitingordialing_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region()
{
	/* Default exit sequence for region waitingordialing_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Composite_XCallOutgoingOrWaiting.inner_region.XCallOutgoingOrWaiting.waitingordialing_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall();
			break;
		}
		default: break;
	}
}

/* Default exit sequence for region HandlingHangup_region */
void PmCallStateHandlerSm::exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region()
{
	/* Default exit sequence for region HandlingHangup_region */
	/* Handle exit of all possible states (of PmCallStateHandlerSm.Main_region.CallHandlerSm.CallHandler_region.SingleCall.SingleCall_region.Composite_XCallOutgoingOrWaiting.inner_region.XCallOutgoingOrWaiting.waitingordialing_region.HandlingHangup.HandlingHangup_region) at position 0... */
	switch(stateConfVector[ 0 ])
	{
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse();
			break;
		}
		case Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup :
		{
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup();
			break;
		}
		default: break;
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr0();
	}  else
	{
		if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr2_tr2())
		{ 
			effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr2();
		}  else
		{
			effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_1_tr1();
		}
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr0();
	}  else
	{
		if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr2_tr2())
		{ 
			effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr2();
		}  else
		{
			effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_2_tr1();
		}
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_3_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_4_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_6_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_7_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr0();
	}  else
	{
		if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr2_tr2())
		{ 
			effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr2();
		}  else
		{
			effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_4_tr1();
		}
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr0();
	}  else
	{
		if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr2_tr2())
		{ 
			effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr2();
		}  else
		{
			effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0_tr1();
		}
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_4_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6_tr1_tr1())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6_tr1();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6_tr0();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8_tr1();
	}
}

/* The reactions of state null. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0()
{
	/* The reactions of state null. */
	if (check_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0_tr0_tr0())
	{ 
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0_tr0();
	}  else
	{
		effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0_tr1();
	}
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_5();
}

/* Default react sequence for initial entry Entry_WaitForStopAudioResponse */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForStopAudioResponse()
{
	/* Default react sequence for initial entry Entry_WaitForStopAudioResponse */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse_default();
}

/* Default react sequence for initial entry Entry_WaitForCallStateEventToStartwaitingMode */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Entry_WaitForCallStateEventToStartwaitingMode()
{
	/* Default react sequence for initial entry Entry_WaitForCallStateEventToStartwaitingMode */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode_default();
}

/* Default react sequence for initial entry TransferAudioToHFEntry */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_TransferAudioToHFEntry()
{
	/* Default react sequence for initial entry TransferAudioToHFEntry */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_default();
}

/* Default react sequence for initial entry Entry_WaitForAudioChannelOutband */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelOutband()
{
	/* Default react sequence for initial entry Entry_WaitForAudioChannelOutband */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel_default();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus_default();
}

/* Default react sequence for initial entry EntryToWaitForChannelAllocation */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_EntryToWaitForChannelAllocation()
{
	/* Default react sequence for initial entry EntryToWaitForChannelAllocation */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation_default();
}

/* Default react sequence for initial entry Entry_WaitForAudioChannelInband */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForAudioChannelInband()
{
	/* Default react sequence for initial entry Entry_WaitForAudioChannelInband */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_EntryToWaitForChannelAllocation();
}

/* Default react sequence for initial entry Entry_WaitForActiveCallStatus */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_WaitForActiveCallStatus()
{
	/* Default react sequence for initial entry Entry_WaitForActiveCallStatus */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_default();
}

/* Default react sequence for initial entry Entry_ReceivedActiveCallStatus */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_ReceivedActiveCallStatus()
{
	/* Default react sequence for initial entry Entry_ReceivedActiveCallStatus */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_default();
}

/* Default react sequence for initial entry Entry_StartWaitingModeAfterAcceptResponse */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Entry_StartWaitingModeAfterAcceptResponse()
{
	/* Default react sequence for initial entry Entry_StartWaitingModeAfterAcceptResponse */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse_default();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_2();
}

/* Default react sequence for initial entry EntryToInbandCall */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_EntryToInbandCall()
{
	/* Default react sequence for initial entry EntryToInbandCall */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_1();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging_default();
}

/* Default react sequence for initial entry EntryToNoRinging */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_EntryToNoRinging()
{
	/* Default react sequence for initial entry EntryToNoRinging */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging_default();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio_default();
}

/* Default react sequence for initial entry EntryToNoRinging */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_EntryToNoRinging()
{
	/* Default react sequence for initial entry EntryToNoRinging */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging_default();
}

/* Default react sequence for initial entry Entry_ActiveCallStatus */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Entry_ActiveCallStatus()
{
	/* Default react sequence for initial entry Entry_ActiveCallStatus */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_5();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_0();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall_default();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse_default();
}

/* Default react sequence for initial entry DialedFromPhone */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_DialedFromPhone()
{
	/* Default react sequence for initial entry DialedFromPhone */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region__choice_0();
}

/* Default react sequence for initial entry EntryFromXCallOutgoingOrWaiting */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromXCallOutgoingOrWaiting()
{
	/* Default react sequence for initial entry EntryFromXCallOutgoingOrWaiting */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_7();
}

/* Default react sequence for initial entry EntryFromRinging */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromRinging()
{
	/* Default react sequence for initial entry EntryFromRinging */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_2();
}

/* Default react sequence for initial entry EntryFromActiveCall */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromActiveCall()
{
	/* Default react sequence for initial entry EntryFromActiveCall */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_8();
}

/* Default react sequence for initial entry EntryFromAccepting */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAccepting()
{
	/* Default react sequence for initial entry EntryFromAccepting */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting_default();
}

/* Default react sequence for initial entry EntryFromAudioHandling */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_EntryFromAudioHandling()
{
	/* Default react sequence for initial entry EntryFromAudioHandling */
	react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_0();
}

/* Default react sequence for initial entry Entry_AudioHandling */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_AudioHandling()
{
	/* Default react sequence for initial entry Entry_AudioHandling */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromAudioHandling();
}

/* Default react sequence for initial entry Entry_Ringing */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Ringing()
{
	/* Default react sequence for initial entry Entry_Ringing */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromRinging();
}

/* Default react sequence for initial entry Entry_ActiveCall */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_ActiveCall()
{
	/* Default react sequence for initial entry Entry_ActiveCall */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromActiveCall();
}

/* Default react sequence for initial entry Entry_XCallOutgoingOrWaiting */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_XCallOutgoingOrWaiting()
{
	/* Default react sequence for initial entry Entry_XCallOutgoingOrWaiting */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromXCallOutgoingOrWaiting();
}

/* Default react sequence for initial entry Entry_Accepting */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Entry_Accepting()
{
	/* Default react sequence for initial entry Entry_Accepting */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_EntryFromAccepting();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse_default();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting_default();
}

/* Default react sequence for initial entry Entry_HandlingHangup */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_HandlingHangup()
{
	/* Default react sequence for initial entry Entry_HandlingHangup */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_default();
}

/* Default react sequence for initial entry Entry_AcceptWaitingCall */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_Entry_AcceptWaitingCall()
{
	/* Default react sequence for initial entry Entry_AcceptWaitingCall */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall_default();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_default();
}

/* Default react sequence for initial entry  */
void PmCallStateHandlerSm::react_Main_region__entry_Default()
{
	/* Default react sequence for initial entry  */
	if(ifaceTraceObserver != sc_null) {
		ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm);
	}
	enseq_Main_region_CallHandlerSm_CallHandler_region_Idle_default();
}

/* The reactions of exit ExitToGenerateCallStateEvent. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent()
{
	/* The reactions of exit ExitToGenerateCallStateEvent. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr0();
}

/* The reactions of exit Exit_ToEntry. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_ToEntry()
{
	/* The reactions of exit Exit_ToEntry. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr3();
}

/* The reactions of exit Exit_WaitingModeFromAudioHandling. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_WaitingModeFromAudioHandling()
{
	/* The reactions of exit Exit_WaitingModeFromAudioHandling. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr4();
}

/* The reactions of exit Exit_WaitingModeFromActive. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_WaitingModeFromActive()
{
	/* The reactions of exit Exit_WaitingModeFromActive. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr5();
}

/* The reactions of exit Exit_WaitingModeFromXCallOutgoingOrWaiting. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_WaitingModeFromXCallOutgoingOrWaiting()
{
	/* The reactions of exit Exit_WaitingModeFromXCallOutgoingOrWaiting. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_tr6();
}

/* The reactions of exit ExitToAudioHandling. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_ExitToAudioHandling()
{
	/* The reactions of exit ExitToAudioHandling. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr0();
}

/* The reactions of exit Exit_ReceivedActiveCallStatus_StartWaitingMode. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_ReceivedActiveCallStatus_StartWaitingMode()
{
	/* The reactions of exit Exit_ReceivedActiveCallStatus_StartWaitingMode. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr2();
}

/* The reactions of exit Exit_StartWaitingModeAfterAcceptResponse. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeAfterAcceptResponse()
{
	/* The reactions of exit Exit_StartWaitingModeAfterAcceptResponse. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr3();
}

/* The reactions of exit Exit_StartWaitingModeFromRinging. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeFromRinging()
{
	/* The reactions of exit Exit_StartWaitingModeFromRinging. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_tr4();
}

/* The reactions of exit ExitToAudioHandling. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_ExitToAudioHandling()
{
	/* The reactions of exit ExitToAudioHandling. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr2();
}

/* The reactions of exit Exit_WaitForAudioChannelInband. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelInband()
{
	/* The reactions of exit Exit_WaitForAudioChannelInband. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr5();
}

/* The reactions of exit Exit_WaitForActiveCallStatus. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForActiveCallStatus()
{
	/* The reactions of exit Exit_WaitForActiveCallStatus. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr4();
}

/* The reactions of exit Exit_ReceivedActiveCallStatus. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_ReceivedActiveCallStatus()
{
	/* The reactions of exit Exit_ReceivedActiveCallStatus. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr6();
}

/* The reactions of exit Exit_WaitForAudioChannelOutband. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelOutband()
{
	/* The reactions of exit Exit_WaitForAudioChannelOutband. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_tr3();
}

/* The reactions of exit ExitToXCallWaitingOrOutgoing. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToXCallWaitingOrOutgoing()
{
	/* The reactions of exit ExitToXCallWaitingOrOutgoing. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr0();
}

/* The reactions of exit MoveToIdle. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_MoveToIdle()
{
	/* The reactions of exit MoveToIdle. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr2();
}

/* The reactions of exit ExitToWaitingModeFromActive. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromActive()
{
	/* The reactions of exit ExitToWaitingModeFromActive. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr5();
}

/* The reactions of exit ExitToWaitingModeFromAudioHandling. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromAudioHandling()
{
	/* The reactions of exit ExitToWaitingModeFromAudioHandling. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr3();
}

/* The reactions of exit ExitToWaitingModeFromXCallOutgoingOrWaiting. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromXCallOutgoingOrWaiting()
{
	/* The reactions of exit ExitToWaitingModeFromXCallOutgoingOrWaiting. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr6();
}

/* The reactions of exit ExitToWaitingModeFromAccepting. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromAccepting()
{
	/* The reactions of exit ExitToWaitingModeFromAccepting. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr7();
}

/* The reactions of exit Exit_Idle. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_Exit_Idle()
{
	/* The reactions of exit Exit_Idle. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_tr0();
}

/* The reactions of exit ExitToAudioHandling. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_ExitToAudioHandling()
{
	/* The reactions of exit ExitToAudioHandling. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_tr1();
}

/* The reactions of exit ExitToWaitingModeFromRinging. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromRinging()
{
	/* The reactions of exit ExitToWaitingModeFromRinging. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr4();
}

/* The reactions of exit ExitToAudioHandling. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_ExitToAudioHandling()
{
	/* The reactions of exit ExitToAudioHandling. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_tr2();
}

/* The reactions of exit ExitToIdle. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_ExitToIdle()
{
	/* The reactions of exit ExitToIdle. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_tr4();
}

/* The reactions of exit Exit_AudioHandling. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Exit_AudioHandling()
{
	/* The reactions of exit Exit_AudioHandling. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_tr0();
}

/* The reactions of exit ExitToAudioHandling. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_ExitToAudioHandling()
{
	/* The reactions of exit ExitToAudioHandling. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_tr2();
}

/* The reactions of exit ExitToIdleFromOutgoingCall. */
void PmCallStateHandlerSm::react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToIdleFromOutgoingCall()
{
	/* The reactions of exit ExitToIdleFromOutgoingCall. */
	effect_Main_region_CallHandlerSm_CallHandler_region_SingleCall_tr8();
}

sc_boolean PmCallStateHandlerSm::react() {
	/* State machine reactions. */
	return false;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_react(const sc_boolean try_transition) {
	/* The reactions of state CallHandlerSm. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_CONNECTED_value);
			ifaceSmHandler_OCB->stopSCOTimer();
		} 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_DISCONNECTED_value);
		} 
		if (ifaceAgAudioUpdate.SCO_PAUSED_raised)
		{ 
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_PAUSED_value);
		} 
		did_transition = react();
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(const sc_boolean try_transition) {
	/* The reactions of state SingleCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAgCallStateUpdate.IDLE_raised) && ((ifaceAgCallStateUpdate.callCount) < (2)))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall();
			if(ifaceTraceObserver != sc_null) {
				ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
			}
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_default();
			Main_region_CallHandlerSm_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if ((ifaceAgAudioUpdate.SCO_PAUSED_raised) && ((ifaceSmHandler.isActiveDevice) == (true)))
		{ 
			ifaceAudioManagerRequest_OCB->pauseHfAudio();
			ifaceSmHandler_OCB->startSCOTimer();
		} 
		if ((ifaceAgAudioUpdate.SCO_PAUSED_raised) && ((ifaceSmHandler.isActiveDevice) == (false)))
		{ 
			ifaceSmHandler_OCB->handleSCODisconnection();
		} 
		if (ifaceUserAction.DIAL_CALL_raised)
		{ 
			ifaceUserAction_OCB->dial(ifaceUserAction.DIAL_CALL_value);
		} 
		if (ifaceUserAction.SPEED_DIAL_raised)
		{ 
			ifaceUserAction_OCB->speedDial(ifaceUserAction.SPEED_DIAL_value);
		} 
		if (ifaceUserAction.HANGUP_CALLS_raised)
		{ 
			ifaceUserAction_OCB->hangupCalls(ifaceUserAction.HANGUP_CALLS_value);
		} 
		if (ifaceUserAction.HANGUP_ALL_CALLS_raised)
		{ 
			ifaceUserAction_OCB->hangupAllCalls(ifaceUserAction.HANGUP_ALL_CALLS_value);
		} 
		if (ifaceUserAction.TRANSFER_AUDIO_TO_AG_raised)
		{ 
			ifaceUserAction_OCB->transferAudio(ifaceUserAction.TRANSFER_AUDIO_TO_AG_value);
		} 
		if (ifaceUserAction.SWAP_CALLS_raised)
		{ 
			ifaceUserAction_OCB->swapCalls(ifaceUserAction.SWAP_CALLS_value);
		} 
		if (((ifaceAgCallStateUpdate.DIALING_raised) || (ifaceAgCallStateUpdate.ACTIVE_raised)) || (ifaceAgCallStateUpdate.HELD_raised))
		{ 
			ifaceSmHandler_OCB->updateCallStatus();
		} 
		if ((((ifaceAgCallStateUpdate.CALLS_CONFERENCE_raised) || (ifaceAgCallStateUpdate.CALLS_SWAPPABLE_raised)) || (ifaceAgCallStateUpdate.CALL_DISCONNECTED_raised)) || (ifaceAgCallStateUpdate.IDLE_raised))
		{ 
			ifaceSmHandler_OCB->updateCallStatus();
		} 
		if (ifaceUserAction.CONFERENCE_CALL_raised)
		{ 
			ifaceUserAction_OCB->conference(ifaceUserAction.CONFERENCE_CALL_value);
		} 
		if (ifaceUserAction.SPLIT_CALLS_raised)
		{ 
			ifaceUserAction_OCB->splitCalls(ifaceUserAction.SPLIT_CALLS_value);
		} 
		if ((ifaceSmHandler.SWITCH_TO_PASSIVE_raised) && ((ifaceAgAudioUpdate.scoStatus) != (0)))
		{ 
			ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
			ifaceSmHandler.isActiveDevice = false;
			ifaceSmHandler_OCB->postSwitchToPassiveResponse((sc_string) "INPROGRESS");
		} 
		if ((ifaceSmHandler.SWITCH_TO_PASSIVE_raised) && ((ifaceAgAudioUpdate.scoStatus) == (0)))
		{ 
			ifaceSmHandler_OCB->postSwitchToPassiveResponse((sc_string) "OK");
		} 
		if ((ifaceSmHandler.SWITCH_TO_ACTIVE_raised) && ((ifaceAgAudioUpdate.scoStatus) == (0)))
		{ 
			ifaceAudioManagerRequest.phoneAudioState = PHONE_AUDIO_CHANNEL_IDLE;
			ifaceSmHandler_OCB->traceMessage((sc_string) "SWITCH_TO_ACTIVE Handled in Super State");
		} 
		if ((((ifaceAudioManagerResponse.PHONE_CHANNEL_RELEASED_raised) || (ifaceAudioManagerResponse.RINGTONE_CHANNEL_RELEASED_raised))) && ((ifaceAgAudioUpdate.scoStatus) != (0)))
		{ 
			ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
		} 
		if (ifaceAgResponse.DIAL_ERROR_raised)
		{ 
			ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.DIAL_ERROR_value, DIAL_CALL_ERROR);
		} 
		if (ifaceAgResponse.SPEED_DIAL_ERROR_raised)
		{ 
			ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.SPEED_DIAL_ERROR_value, SPEED_DIAL_ERROR);
		} 
		if (ifaceAgResponse.HOLD_AND_ACCEPT_ERROR_raised)
		{ 
			ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.HOLD_AND_ACCEPT_ERROR_value, HOLD_AND_ACCEPT_ERROR);
		} 
		if (ifaceAgResponse.RELEASE_AND_ACCEPT_ERROR_raised)
		{ 
			ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.RELEASE_AND_ACCEPT_ERROR_value, ACCEPT_CALL_ERROR);
		} 
		if (ifaceAgResponse.RELEASE_AND_SWAP_ERROR_raised)
		{ 
			ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.RELEASE_AND_SWAP_ERROR_value, RELEASE_AND_SWAP_ERROR);
		} 
		if (((ifaceAgResponse.TRANSFER_ERROR_raised)) && (((true) == (ifaceSmHandler.isActiveDevice))))
		{ 
			ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.TRANSFER_ERROR_value, TRANSFER_CALL_ERROR);
		} 
		if (((ifaceAgResponse.TRANSFER_ERROR_raised)) && (((false) == (ifaceSmHandler.isActiveDevice))))
		{ 
			ifaceSmHandler_OCB->postSwitchToPassiveResponse((sc_string) "Error in Audio Transfer in Active Device");
			ifaceSmHandler.isActiveDevice = true;
		} 
		if (ifaceUserAction.START_WAITING_MODE_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(START_WAITINGMODE_FAILED_ERROR);
		} 
		if (ifaceUserAction.STOP_WAITING_MODE_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(STOP_WAITINGMODE_FAILED_ERROR);
		} 
		did_transition = Main_region_CallHandlerSm_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(const sc_boolean try_transition) {
	/* The reactions of state AudioHandling. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAgAudioUpdate.SCO_DISCONNECTED_raised) && ((ifaceAudioManagerRequest.phoneAudioState) != (PHONE_STOP_STREAMING_SUCCESS)))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling();
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_DISCONNECTED_value);
			ifaceAudioManagerRequest_OCB->stopAudio();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_Entry_WaitForStopAudioResponse();
		}  else
		{
			if (ifaceUserAction.START_WAITING_MODE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_Entry_WaitForCallStateEventToStartwaitingMode();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_react(const sc_boolean try_transition) {
	/* The reactions of state RequestPhoneAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_9();
		}  else
		{
			if (ifaceInternalSCI.GENERATE_CALL_STATE_EVENT_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
				ifaceAudioManagerRequest.phoneAudioState = PHONE_AUDIO_CHANNEL_IDLE;
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_8();
			}  else
			{
				if (ifaceUserAction.TRANSFER_AUDIO_TO_AG_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10();
				}  else
				{
					if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio();
						enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_default();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_DENIED_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(PHONE_CHANNEL_DENIED_FOR_TRANSFER_AUDIO_ERROR);
			internalEventQueue.push_back(new SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT(InternalSCI_GENERATE_CALL_STATE_EVENT));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state RequestStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(false);
		}  else
		{
			if (ifaceInternalSCI.GENERATE_CALL_STATE_EVENT_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent();
			}  else
			{
				if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming();
					ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_DISCONNECTED_value);
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_ToEntry();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(ECNR_FAILED_FOR_TRANSFER_AUDIO_ERROR);
			ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
		} 
		if (ifaceAudioManagerResponse.PAUSE_AUDIO_SUCCESS_raised)
		{ 
			internalEventQueue.push_back(new SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT(InternalSCI_GENERATE_CALL_STATE_EVENT));
		} 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			ifaceAudioManagerRequest_OCB->playHfAudio(ifaceAgAudioUpdate.scoStatus);
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingStarted. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceInternalSCI.GENERATE_CALL_STATE_EVENT_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingStopped. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceInternalSCI.GENERATE_CALL_STATE_EVENT_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStopped();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPrepareChannelResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(false);
		}  else
		{
			if (ifaceInternalSCI.GENERATE_CALL_STATE_EVENT_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForPrepareChannelResponse();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_DENIED_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(PHONE_CHANNEL_DENIED_FOR_TRANSFER_AUDIO_ERROR);
			ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
			internalEventQueue.push_back(new SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT(InternalSCI_GENERATE_CALL_STATE_EVENT));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_0();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state RequestPauseAudioStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PAUSE_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(false);
		}  else
		{
			if (ifaceInternalSCI.MOVE_TO_NEXT_STATE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPauseAudioStreaming();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStopAudioResponse_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.PAUSE_AUDIO_FAILURE_raised)
		{ 
			ifaceSmHandler_OCB->postSwitchToPassiveResponse((sc_string) "Error in Audio Channel Pause Handling in Active Device");
			ifaceSmHandler.isActiveDevice = true;
			ifaceAudioManagerRequest_OCB->stopAudio();
			internalEventQueue.push_back(new SctEvent_InternalSCI_MOVE_TO_NEXT_STATE(InternalSCI_MOVE_TO_NEXT_STATE));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingPaused. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceInternalSCI.GENERATE_CALL_STATE_EVENT_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone_react(const sc_boolean try_transition) {
	/* The reactions of state RequestStopAudioRingtone. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStopAudioRingtone();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingPaused_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForCallStateEventToStartwaitingMode. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAgCallStateUpdate.INCOMING_raised) || (ifaceAgCallStateUpdate.INCOMING_INBAND_raised))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_WaitingModeFromAudioHandling();
		}  else
		{
			if ((((ifaceAgCallStateUpdate.ACTIVE_raised) || (ifaceAgCallStateUpdate.HELD_raised)) || (ifaceAgCallStateUpdate.CALLS_CONFERENCE_raised)) || (ifaceAgCallStateUpdate.CALLS_SWAPPABLE_raised))
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_WaitingModeFromActive();
			}  else
			{
				if (ifaceAgCallStateUpdate.CALL_X_WAITING_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForCallStateEventToStartwaitingMode();
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_WaitingModeFromXCallOutgoingOrWaiting();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCO. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_CONNECTED_value);
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestStreaming_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(false);
		}  else
		{
			if (ifaceAgResponse.TRANSFER_ERROR_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_ToEntry();
			}  else
			{
				if (ifaceUserAction.TRANSFER_AUDIO_TO_AG_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCO();
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region__choice_10();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCODisconnection. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection();
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_DISCONNECTED_value);
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_Exit_ToEntry();
		}  else
		{
			if (ifaceUserAction.TRANSFER_AUDIO_TO_HF_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection();
				ifaceUserAction_OCB->setTransferAudioToHfToSuccess(ifaceUserAction.TRANSFER_AUDIO_TO_HF_value);
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(false);
			}  else
			{
				if (ifaceAgResponse.TRANSFER_ERROR_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForSCODisconnection();
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_RequestPhoneAudio_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStartAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_StreamingStarted_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(false);
		}  else
		{
			if (ifaceInternalSCI.GENERATE_CALL_STATE_EVENT_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_WaitForStartAudioResponse();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_audiohandling_region_ExitToGenerateCallStateEvent();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(PHONE_CHANNEL_DENIED_FOR_TRANSFER_AUDIO_ERROR);
			ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
			internalEventQueue.push_back(new SctEvent_InternalSCI_GENERATE_CALL_STATE_EVENT(InternalSCI_GENERATE_CALL_STATE_EVENT));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(const sc_boolean try_transition) {
	/* The reactions of state AcceptingCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.START_WAITING_MODE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_Entry_StartWaitingModeAfterAcceptResponse();
		}  else
		{
			if (ifaceInternalSCI.GENERATE_CALL_STATE_EVENT_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgCallStateUpdate.ACTIVE_raised)
		{ 
			ifaceSmHandler_OCB->updateCallStatus();
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAudioChannel. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgCallStateUpdate.ACTIVE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_ExitToAudioHandling();
		}  else
		{
			if ((ifaceAgAudioUpdate.SCO_CONNECTED_raised) && ((ifaceAudioManagerRequest.phoneAudioState) == (PHONE_CHANNEL_ALLOCATED)))
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(false);
			}  else
			{
				if (ifaceAgResponse.ACCEPT_ERROR_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
					ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.ACCEPT_ERROR_value, ACCEPT_CALL_ERROR);
					ifaceSmHandler_OCB->acceptCallFinished();
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(false);
				}  else
				{
					if (ifaceUserAction.ACCEPT_CALL_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
						ifaceUserAction_OCB->acquirePhoneAudio(ifaceUserAction.ACCEPT_CALL_value);
						enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel_default();
					}  else
					{
						if (ifaceUserAction.START_WAITING_MODE_raised)
						{ 
							exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel();
							react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0();
						}  else
						{
							did_transition = false;
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised)
		{ 
			ifaceUserAction_OCB->postAcceptCall();
		} 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_DENIED_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(PHONE_CHANNEL_DENIED_FOR_ACCEPT_ERROR);
			ifaceSmHandler_OCB->acceptCallFinished();
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(const sc_boolean try_transition) {
	/* The reactions of state InbandAcceptCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceTimerUpdate.TIMER_CALLBACK_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_ExitToAudioHandling();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForActiveCallStatus. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgCallStateUpdate.ACTIVE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
		}  else
		{
			if (ifaceAgResponse.ACCEPT_ERROR_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForActiveCallStatus();
				ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.ACCEPT_ERROR_value, ACCEPT_CALL_ERROR);
				ifaceSmHandler_OCB->acceptCallFinished();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_react(const sc_boolean try_transition) {
	/* The reactions of state ReceivedActiveCallStatus. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.START_WAITING_MODE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_ReceivedActiveCallStatus_StartWaitingMode();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceUserAction.TRANSFER_AUDIO_TO_AG_raised)
		{ 
			ifaceUserAction_OCB->transferAudio(ifaceUserAction.TRANSFER_AUDIO_TO_AG_value);
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForChannelAllocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgCallStateUpdate.ACTIVE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
		}  else
		{
			if (ifaceUserAction.START_WAITING_MODE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region__choice_0();
			}  else
			{
				if (ifaceAgResponse.ACCEPT_ERROR_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation();
					ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.ACCEPT_ERROR_value, ACCEPT_CALL_ERROR);
					ifaceSmHandler_OCB->acceptCallFinished();
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
				}  else
				{
					if (ifaceUserAction.ACCEPT_CALL_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation();
						ifaceUserAction_OCB->acquirePhoneAudio(ifaceUserAction.ACCEPT_CALL_value);
						enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation_default();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised)
		{ 
			ifaceUserAction_OCB->postAcceptCall();
		} 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_DENIED_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(PHONE_CHANNEL_DENIED_FOR_ACCEPT_ERROR);
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
		}  else
		{
			if (ifaceUserAction.ACCEPT_CALL_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
				ifaceSmHandler_OCB->setAcceptCallParam(ifaceUserAction.ACCEPT_CALL_value);
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
			}  else
			{
				if (ifaceUserAction.START_WAITING_MODE_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
				}  else
				{
					if (ifaceAgCallStateUpdate.ACTIVE_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponse();
						enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_default();
						Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponseToAcceptCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.ACCEPT_CALL_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
			ifaceSmHandler_OCB->setAcceptCallParam(ifaceUserAction.ACCEPT_CALL_value);
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall_default();
		}  else
		{
			if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
				ifaceUserAction_OCB->acquirePhoneAudio(ifaceSmHandler_OCB->getAcceptCallParam());
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
			}  else
			{
				if (ifaceUserAction.START_WAITING_MODE_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
				}  else
				{
					if (ifaceAgCallStateUpdate.ACTIVE_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForStopAudioResponseToAcceptCall();
						enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_default();
						Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode_react(const sc_boolean try_transition) {
	/* The reactions of state ToStartWaitingMode. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceInternalSCI.TO_START_WAITING_MODE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeFromRinging();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAcceptCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgCallStateUpdate.ACTIVE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ReceivedActiveCallStatus_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
		}  else
		{
			if (ifaceUserAction.START_WAITING_MODE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_ToStartWaitingMode_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
			}  else
			{
				if (ifaceUserAction.ACCEPT_CALL_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForAcceptCall();
					ifaceUserAction_OCB->acquirePhoneAudio(ifaceUserAction.ACCEPT_CALL_value);
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_inbandacceptcall_region_WaitForChannelAllocation_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_InbandAcceptCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse_react(const sc_boolean try_transition) {
	/* The reactions of state StartWaitingModeAfterAcceptResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAgResponse.ACCEPT_OK_raised) || (ifaceAgCallStateUpdate.ACTIVE_raised))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterAcceptResponse();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeAfterAcceptResponse();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall_react(const sc_boolean try_transition) {
	/* The reactions of state RequestStreamingAcceptingCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgCallStateUpdate.ACTIVE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_RequestStreamingAcceptingCall();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_ExitToAudioHandling();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation_react(const sc_boolean try_transition) {
	/* The reactions of state StartWaitingModeAfterChannelAllocation. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_DENIED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation();
			ifaceSmHandler_OCB->updateErrorStatus(PHONE_CHANNEL_DENIED_FOR_ACCEPT_ERROR);
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeFromRinging();
		}  else
		{
			if (ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartWaitingModeAfterChannelAllocation();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeFromRinging();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(false);
		}  else
		{
			if (ifaceUserAction.ACCEPT_CALL_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
				ifaceSmHandler_OCB->setAcceptCallParam(ifaceUserAction.ACCEPT_CALL_value);
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(false);
			}  else
			{
				if (ifaceAgCallStateUpdate.ACTIVE_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_ExitToAudioHandling();
				}  else
				{
					if (ifaceUserAction.START_WAITING_MODE_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponse();
						enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode_default();
						Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponseToAcceptCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.ACCEPT_CALL_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall();
			ifaceSmHandler_OCB->setAcceptCallParam(ifaceUserAction.ACCEPT_CALL_value);
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall_default();
		}  else
		{
			if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall();
				ifaceUserAction_OCB->acquirePhoneAudio(ifaceSmHandler_OCB->getAcceptCallParam());
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(false);
			}  else
			{
				if (ifaceAgCallStateUpdate.ACTIVE_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall();
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_ExitToAudioHandling();
				}  else
				{
					if (ifaceUserAction.START_WAITING_MODE_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForStopAudioResponseToAcceptCall();
						enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode_default();
						Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode_react(const sc_boolean try_transition) {
	/* The reactions of state StartToWaitingMode. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceInternalSCI.TO_START_WAITING_MODE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_Exit_StartWaitingModeFromRinging();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAcceptCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.ACCEPT_CALL_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall();
			ifaceUserAction_OCB->acquirePhoneAudio(ifaceUserAction.ACCEPT_CALL_value);
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAudioChannel_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(false);
		}  else
		{
			if (ifaceAgCallStateUpdate.ACTIVE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_ExitToAudioHandling();
			}  else
			{
				if (ifaceUserAction.START_WAITING_MODE_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_WaitForAcceptCall();
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_acceptingCall_region_StartToWaitingMode_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AcceptingCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(const sc_boolean try_transition) {
	/* The reactions of state Incoming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.START_WAITING_MODE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromRinging();
		}  else
		{
			if (ifaceAgCallStateUpdate.ACTIVE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_Entry_ActiveCallStatus();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceUserAction.ACCEPT_CALL_BY_ACQUIRING_CH_raised)
		{ 
			ifaceAudioManagerRequest.phoneAudioState = PHONE_AUDIO_CHANNEL_IDLE;
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_react(const sc_boolean try_transition) {
	/* The reactions of state InbandCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_0();
		}  else
		{
			if (ifaceUserAction.ACCEPT_CALL_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelInband();
			}  else
			{
				if (ifaceAudioManagerResponse.PHONE_CHANNEL_DENIED_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall();
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_6();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCO. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
		}  else
		{
			if ((ifaceSmHandler.SWITCH_TO_ACTIVE_raised) && ((false) == (ifaceSmHandler_OCB->isRingtoneSuppressed())))
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
			}  else
			{
				if (ifaceUserAction.ACCEPT_CALL_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO();
					ifaceUserAction_OCB->postAcceptCall();
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForActiveCallStatus();
				}  else
				{
					if (ifaceUserAction.ACCEPT_CALL_BY_ACQUIRING_CH_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO();
						ifaceUserAction_OCB->acquirePhoneAudio(ifaceUserAction.ACCEPT_CALL_BY_ACQUIRING_CH_value);
						react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelInband();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
		}  else
		{
			if (ifaceAgCallStateUpdate.ACTIVE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
			}  else
			{
				if (ifaceUserAction.ACCEPT_CALL_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponse();
					ifaceSmHandler_OCB->setAcceptCallParam(ifaceUserAction.ACCEPT_CALL_value);
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponseOutband. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region__choice_3();
		}  else
		{
			if (ifaceAgCallStateUpdate.ACTIVE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
			}  else
			{
				if (ifaceUserAction.ACCEPT_CALL_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutband();
					ifaceSmHandler_OCB->setAcceptCallParam(ifaceUserAction.ACCEPT_CALL_value);
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForAudioResponse();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_ExitToAudioHandling();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_react(const sc_boolean try_transition) {
	/* The reactions of state OutbandCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.ACCEPT_CALL_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall();
			ifaceUserAction_OCB->acquirePhoneAudio(ifaceUserAction.ACCEPT_CALL_value);
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelOutband();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandCallNoRinging_react(const sc_boolean try_transition) {
	/* The reactions of state OutbandCallNoRinging. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_outbandringing_region_OutbandRinging_react(const sc_boolean try_transition) {
	/* The reactions of state OutbandRinging. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceSmHandler.SWITCH_TO_ACTIVE_raised)
		{ 
			ifaceSmHandler_OCB->handleSwitchToActiveInOutbandRinging();
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_OutbandCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(const sc_boolean try_transition) {
	/* The reactions of state InbandRinging. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgCallStateUpdate.ACTIVE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_ReceivedActiveCallStatus();
		}  else
		{
			if (ifaceUserAction.ACCEPT_CALL_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging();
				ifaceUserAction_OCB->postAcceptCall();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForActiveCallStatus();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio_react(const sc_boolean try_transition) {
	/* The reactions of state RequestPlayHfAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(false);
		}  else
		{
			if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
				ifaceAudioManagerRequest_OCB->stopAudio();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(false);
			}  else
			{
				if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_RequestPlayHfAudio();
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming_default();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandCallNoRinging_react(const sc_boolean try_transition) {
	/* The reactions of state InbandCallNoRinging. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_PlayAudioFailure_react(const sc_boolean try_transition) {
	/* The reactions of state PlayAudioFailure. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.ACCEPT_CALL_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging();
			ifaceUserAction_OCB->acquirePhoneAudio(ifaceUserAction.ACCEPT_CALL_value);
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelInband();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region__choice_0();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForSCO_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCO. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state InbandRingtoneStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_InbandRingtoneStreaming();
			ifaceAudioManagerRequest_OCB->stopAudio();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_Inbandringing_region_WaitForStopAudioResponse_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandRinging_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCOInSwitchToActive. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceSmHandler.SWITCH_TO_PASSIVE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCO_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
		}  else
		{
			if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_InbandCall_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(false);
			}  else
			{
				if (ifaceUserAction.ACCEPT_CALL_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForSCOInSwitchToActive();
					ifaceUserAction_OCB->acquirePhoneAudio(ifaceUserAction.ACCEPT_CALL_value);
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelInband();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied_react(const sc_boolean try_transition) {
	/* The reactions of state AudioChannelDenied. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.ACCEPT_CALL_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_AudioChannelDenied();
			ifaceAudioManagerRequest_OCB->requestPhoneAudio();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelInband();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponseOutbandToAcceptCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall();
			ifaceUserAction_OCB->acquirePhoneAudio(ifaceSmHandler_OCB->getAcceptCallParam());
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelOutband();
		}  else
		{
			if (ifaceUserAction.ACCEPT_CALL_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall();
				ifaceSmHandler_OCB->setAcceptCallParam(ifaceUserAction.ACCEPT_CALL_value);
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseOutbandToAcceptCall_default();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponseToAcceptCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.ACCEPT_CALL_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall();
			ifaceSmHandler_OCB->setAcceptCallParam(ifaceUserAction.ACCEPT_CALL_value);
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall_default();
		}  else
		{
			if (ifaceUserAction.ACCEPT_CALL_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_WaitForStopAudioResponseToAcceptCall();
				ifaceAudioManagerRequest_OCB->requestPhoneAudio();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_incoming_region_Exit_WaitForAudioChannelInband();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForCallStateEvent. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((((ifaceAgCallStateUpdate.DIALING_raised) || (ifaceAgCallStateUpdate.ACTIVE_raised)) || (ifaceAgCallStateUpdate.HELD_raised)) || (ifaceAgCallStateUpdate.CALLS_CONFERENCE_raised)) || (ifaceAgCallStateUpdate.CALLS_SWAPPABLE_raised))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
		}  else
		{
			if ((ifaceAgCallStateUpdate.CALL_X_DIALING_raised) || (ifaceAgCallStateUpdate.CALL_X_WAITING_raised))
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
			}  else
			{
				if (ifaceAgCallStateUpdate.INCOMING_INBAND_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_EntryToInbandCall();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
				}  else
				{
					if (ifaceAgCallStateUpdate.INCOMING_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_WaitForCallStateEvent();
						react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region__choice_0();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_react(const sc_boolean try_transition) {
	/* The reactions of state Disconnecting. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForStopResponse();
			ifaceSmHandler_OCB->updatePhoneCallAudioActive(false);
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio_react(const sc_boolean try_transition) {
	/* The reactions of state RequestStopAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_RequestStopAudio();
			ifaceSmHandler_OCB->updatePhoneCallAudioActive(false);
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region__choice_1();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCORelease. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_WaitForSCORelease();
			ifaceAgAudioUpdate.scoStatus = 0;
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_disconnecting_region_Exit_Idle();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Disconnecting_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_react(const sc_boolean try_transition) {
	/* The reactions of state ActiveCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAgCallStateUpdate.CALL_X_DIALING_raised) || (ifaceAgCallStateUpdate.CALL_X_WAITING_raised))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
		}  else
		{
			if (ifaceUserAction.START_WAITING_MODE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromActive();
			}  else
			{
				if (ifaceUserAction.TRANSFER_AUDIO_TO_HF_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall();
					ifaceUserAction_OCB->setTransferAudioToHfToSuccess(ifaceUserAction.TRANSFER_AUDIO_TO_HF_value);
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_TransferAudioToHFEntry();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAudioEventActiveCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAgAudioUpdate.SCO_CONNECTED_raised) || (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_WaitForAudioEventActiveCall();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_activecall_region_ExitToAudioHandling();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ActiveCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_react(const sc_boolean try_transition) {
	/* The reactions of state Outgoing. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgCallStateUpdate.ACTIVE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
		}  else
		{
			if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
			}  else
			{
				if (ifaceUserAction.TRANSFER_AUDIO_TO_HF_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing();
					ifaceUserAction_OCB->setTransferAudioToHfToSuccess(ifaceUserAction.TRANSFER_AUDIO_TO_HF_value);
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_TransferAudioToHFEntry();
					Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceUserAction.DIAL_CALL_raised)
		{ 
			ifaceUserAction_OCB->dial(ifaceUserAction.DIAL_CALL_value);
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForDialResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgCallStateUpdate.DIALING_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse();
			ifaceSmHandler_OCB->updateCallStatus();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_react(false);
		}  else
		{
			if (ifaceUserAction.HANGUP_CALLS_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_react(false);
			}  else
			{
				if (ifaceAgResponse.DIAL_ERROR_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse();
					ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.DIAL_ERROR_value, DIAL_CALL_ERROR);
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_ExitToIdle();
				}  else
				{
					if (ifaceAgResponse.SPEED_DIAL_ERROR_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForDialResponse();
						ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.SPEED_DIAL_ERROR_value, SPEED_DIAL_ERROR);
						react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_ExitToIdle();
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_WaitForSCO_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCO. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall_react(const sc_boolean try_transition) {
	/* The reactions of state CancelOutgoingCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgResponse.DIAL_ERROR_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall();
			ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.DIAL_ERROR_value, DIAL_CALL_ERROR);
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_ExitToIdle();
		}  else
		{
			if (ifaceAgResponse.SPEED_DIAL_ERROR_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_CancelOutgoingCall();
				ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.SPEED_DIAL_ERROR_value, SPEED_DIAL_ERROR);
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_outgoing_region_ExitToIdle();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgCallStateUpdate.DIALING_raised)
		{ 
			ifaceUserAction_OCB->postCancelOutgoing();
		} 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			ifaceAgAudioUpdate.scoStatus = (ifaceAgAudioUpdate.SCO_CONNECTED_value);
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_react(const sc_boolean try_transition) {
	/* The reactions of state Composite_WaitingMode. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if ((ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_RELEASED_raised) && ((ifaceAgAudioUpdate.scoStatus) != (0)))
		{ 
			ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingMode. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.STOP_WAITING_MODE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode();
			if(ifaceTraceObserver != sc_null) {
				ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode);
			}
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_react(false);
		}  else
		{
			if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode();
				if(ifaceTraceObserver != sc_null) {
					ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode);
				}
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_5();
			}  else
			{
				if (ifaceInternalSCI.CHECK_AUDIO_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode();
					react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_Exit_AudioHandling();
				}  else
				{
					if (ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_DENIED_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode();
						if(ifaceTraceObserver != sc_null) {
							ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode);
						}
						enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied_default();
						Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_react(false);
					}  else
					{
						did_transition = false;
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAudioChannel. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgResponse.ACCEPT_OK_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_1();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_GRANTED_raised)
		{ 
			ifaceSmHandler_OCB->acceptWaitingModeCall();
		} 
		if (ifaceAgResponse.ACCEPT_ERROR_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(ACCEPT_CALL_FAILED_TO_START_WAITINGMODE_ERROR);
			internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state RequestStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted_react(const sc_boolean try_transition) {
	/* The reactions of state StreamingStarted. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceUserAction.TRANSFER_AUDIO_TO_AG_raised)
		{ 
			ifaceUserAction_OCB->transferAudio(ifaceUserAction.TRANSFER_AUDIO_TO_AG_value);
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio_react(const sc_boolean try_transition) {
	/* The reactions of state RequestPhoneAudio. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.START_WAITING_MODE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised)
		{ 
			internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
		} 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_DENIED_raised)
		{ 
			ifaceUserAction_OCB->postTransferAudio((sc_string) "AG");
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel_react(const sc_boolean try_transition) {
	/* The reactions of state RequestingAudioChannel. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_GRANTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall_react(const sc_boolean try_transition) {
	/* The reactions of state PostholdAndAcceptWaitingModeCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			if (((ifaceAgResponse.HOLD_AND_ACCEPT_OK_raised)) && (((true) == (ifaceSmHandler_OCB->isInbandRinging()))))
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostholdAndAcceptWaitingModeCall();
				react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgResponse.HOLD_AND_ACCEPT_ERROR_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(ACCEPT_CALL_FAILED_TO_START_WAITINGMODE_ERROR);
			internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponseAudioHandling. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannel_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			if (ifaceUserAction.STOP_WAITING_MODE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling();
				internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseAudioHandling_default();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCO. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCO();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode_react(const sc_boolean try_transition) {
	/* The reactions of state RequestWaitingMode. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_GRANTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingMode();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall_react(const sc_boolean try_transition) {
	/* The reactions of state PostAcceptWaitingModeCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgResponse.ACCEPT_OK_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_PostAcceptWaitingModeCall();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgResponse.ACCEPT_ERROR_raised)
		{ 
			ifaceSmHandler_OCB->updateErrorStatus(ACCEPT_CALL_FAILED_TO_START_WAITINGMODE_ERROR);
			ifaceAudioManagerRequest_OCB->stopAudio();
			internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForSCORinging. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			if (ifaceTimerUpdate.TIMER_CALLBACK_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForSCORinging();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging_react(const sc_boolean try_transition) {
	/* The reactions of state RequestStreamingRinging. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging_default();
		}  else
		{
			if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreamingRinging();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceTimerUpdate.TIMER_CALLBACK_raised)
		{ 
			ifaceAudioManagerRequest_OCB->playWaitingModeTone(ifaceAgAudioUpdate.scoStatus);
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAudioChannelForActiveCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_GRANTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStreaming_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			if (ifaceUserAction.STOP_WAITING_MODE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestStopStreaming_react(const sc_boolean try_transition) {
	/* The reactions of state RequestStopStreaming. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SendError_react(const sc_boolean try_transition) {
	/* The reactions of state SendError. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_SwitchToPassive_react(const sc_boolean try_transition) {
	/* The reactions of state SwitchToPassive. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised)
		{ 
			ifaceSmHandler_OCB->postSwitchToPassiveResponse((sc_string) "OK");
			ifaceSmHandler.isActiveDevice = true;
			internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting_react(const sc_boolean try_transition) {
	/* The reactions of state RequestWaitingModeAccepting. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_GRANTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_3();
		}  else
		{
			if (ifaceTimerUpdate.TIMER_CALLBACK_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestWaitingModeAccepting();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback_react(const sc_boolean try_transition) {
	/* The reactions of state ReceivedTimerCallback. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.PLAY_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_ReceivedTimerCallback();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_StreamingStarted_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgAudioUpdate.SCO_CONNECTED_raised)
		{ 
			ifaceAudioManagerRequest_OCB->playWaitingModeTone(ifaceAgAudioUpdate.scoStatus);
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForWaitModeChannelAfterTimerExpiry. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_GRANTED_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitModeChannelAfterTimerExpiry();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region__choice_6();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponseXCallOutgoingOrWaiting. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestingAudioChannel_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			if (ifaceUserAction.STOP_WAITING_MODE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting();
				internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseXCallOutgoingOrWaiting_default();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForStopAudioResponseActiveCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAudioManagerResponse.STOP_AUDIO_SUCCESS_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			if (ifaceUserAction.STOP_WAITING_MODE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall();
				internalEventQueue.push_back(new SctEvent_InternalSCI_CHECK_AUDIO(InternalSCI_CHECK_AUDIO));
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForStopAudioResponseActiveCall_default();
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitingModeChannelDenied_react(const sc_boolean try_transition) {
	/* The reactions of state WaitingModeChannelDenied. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForWaitingmodeChannelResponseToStopWaitingMode. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_GRANTED_raised) || (ifaceAudioManagerResponse.WAITINGMODE_CHANNEL_DENIED_raised))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			if (ifaceUserAction.START_WAITING_MODE_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForWaitingmodeChannelResponseToStopWaitingMode();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForPhoneChannelResponseToStartWaitingMode. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.STOP_WAITING_MODE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_RequestPhoneAudio_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
		}  else
		{
			if ((ifaceAudioManagerResponse.PHONE_CHANNEL_DENIED_raised) || (ifaceAudioManagerResponse.PHONE_CHANNEL_GRANTED_raised))
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForPhoneChannelResponseToStartWaitingMode();
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_waitingmode_region_WaitForAudioChannelForActiveCall_default();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_WaitingMode_inner_region_WaitingMode_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_react(const sc_boolean try_transition) {
	/* The reactions of state Composite_XCallOutgoingOrWaiting. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.START_WAITING_MODE_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToWaitingModeFromXCallOutgoingOrWaiting();
		}  else
		{
			if (ifaceUserAction.TRANSFER_AUDIO_TO_HF_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting();
				ifaceUserAction_OCB->setTransferAudioToHfToSuccess(ifaceUserAction.TRANSFER_AUDIO_TO_HF_value);
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_TransferAudioToHFEntry();
				Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
			}  else
			{
				did_transition = false;
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_react(const sc_boolean try_transition) {
	/* The reactions of state XCallOutgoingOrWaiting. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (((((ifaceAgCallStateUpdate.INCOMING_raised) || (ifaceAgCallStateUpdate.INCOMING_INBAND_raised)) || (ifaceAgCallStateUpdate.ACTIVE_raised)) || (ifaceAgCallStateUpdate.HELD_raised)) || (ifaceAgCallStateUpdate.CALLS_SWAPPABLE_raised))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_react(false);
		}  else
		{
			if (ifaceUserAction.HANGUP_CALLS_raised)
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting();
				ifaceUserAction_OCB->hangupCalls(ifaceUserAction.HANGUP_CALLS_value);
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_Entry_HandlingHangup();
			}  else
			{
				if (ifaceUserAction.ACCEPT_CALL_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting();
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_Entry_AcceptWaitingCall();
				}  else
				{
					did_transition = false;
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_react(const sc_boolean try_transition) {
	/* The reactions of state HandlingHangup. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAgAudioUpdate.SCO_CONNECTED_raised) || (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_ExitToAudioHandling();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised)
		{ 
			ifaceAudioManagerRequest_OCB->pauseHfAudio();
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForHangupResponse. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceUserAction.ACCEPT_CALL_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_WaitForHangupResponse();
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup_default();
			Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_react(false);
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_HandlingHangup_region_AcceptAfterHangup_react(const sc_boolean try_transition) {
	/* The reactions of state AcceptAfterHangup. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		did_transition = false;
	} 
	if ((did_transition) == (false))
	{ 
		if (ifaceAgCallStateUpdate.IDLE_raised)
		{ 
			ifaceUserAction_OCB->postAcceptCall();
			ifaceSmHandler_OCB->updateCallStatus();
		} 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_HandlingHangup_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting_react(const sc_boolean try_transition) {
	/* The reactions of state WaitForAudioEventXCallOutgoingOrWaiting. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if ((ifaceAgAudioUpdate.SCO_CONNECTED_raised) || (ifaceAgAudioUpdate.SCO_DISCONNECTED_raised))
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_WaitForAudioEventXCallOutgoingOrWaiting();
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_ExitToAudioHandling();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall_react(const sc_boolean try_transition) {
	/* The reactions of state AcceptWaitingCall. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgResponse.HOLD_AND_ACCEPT_ERROR_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_AcceptWaitingCall();
			ifaceSmHandler_OCB->updateCallErrorStatus(ifaceAgResponse.HOLD_AND_ACCEPT_ERROR_value, HOLD_AND_ACCEPT_ERROR);
			react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_waitingordialing_region_ExitToAudioHandling();
		}  else
		{
			did_transition = false;
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Composite_XCallOutgoingOrWaiting_inner_region_XCallOutgoingOrWaiting_react(try_transition);
	} 
	return did_transition;
}

sc_boolean PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_Idle_react(const sc_boolean try_transition) {
	/* The reactions of state Idle. */
	sc_boolean did_transition = try_transition;
	if (try_transition)
	{ 
		if (ifaceAgCallStateUpdate.DIALING_raised)
		{ 
			exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
			ifaceSmHandler_OCB->updateCallStatus();
			if(ifaceTraceObserver != sc_null) {
				ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
			}
			enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_DialedFromPhone();
			Main_region_CallHandlerSm_react(false);
		}  else
		{
			if ((((ifaceAgCallStateUpdate.ACTIVE_raised) || (ifaceAgCallStateUpdate.HELD_raised)) || (ifaceAgCallStateUpdate.CALLS_SWAPPABLE_raised)) || (ifaceAgCallStateUpdate.CALLS_CONFERENCE_raised))
			{ 
				exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
				if(ifaceTraceObserver != sc_null) {
					ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
				}
				enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_AudioHandling_default();
				Main_region_CallHandlerSm_react(false);
			}  else
			{
				if (ifaceAgCallStateUpdate.INCOMING_INBAND_raised)
				{ 
					exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
					if(ifaceTraceObserver != sc_null) {
						ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
					}
					enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_EntryToInbandCall();
					Main_region_CallHandlerSm_react(false);
				}  else
				{
					if (ifaceAgCallStateUpdate.INCOMING_raised)
					{ 
						exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
						if(ifaceTraceObserver != sc_null) {
							ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
						}
						enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Incoming_default();
						Main_region_CallHandlerSm_react(false);
					}  else
					{
						if (ifaceUserAction.DIAL_CALL_raised)
						{ 
							exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
							ifaceUserAction_OCB->dial(ifaceUserAction.DIAL_CALL_value);
							if(ifaceTraceObserver != sc_null) {
								ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
							}
							enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_default();
							Main_region_CallHandlerSm_react(false);
						}  else
						{
							if ((ifaceAgCallStateUpdate.CALL_X_DIALING_raised) || (ifaceAgCallStateUpdate.CALL_X_WAITING_raised))
							{ 
								exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
								if(ifaceTraceObserver != sc_null) {
									ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
								}
								react_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_ExitToXCallWaitingOrOutgoing();
								Main_region_CallHandlerSm_react(false);
							}  else
							{
								if (ifaceUserAction.SPEED_DIAL_raised)
								{ 
									exseq_Main_region_CallHandlerSm_CallHandler_region_Idle();
									ifaceUserAction_OCB->speedDial(ifaceUserAction.SPEED_DIAL_value);
									if(ifaceTraceObserver != sc_null) {
										ifaceTraceObserver->stateEntered(PmCallStateHandlerSm::Main_region_CallHandlerSm_CallHandler_region_SingleCall);
									}
									enseq_Main_region_CallHandlerSm_CallHandler_region_SingleCall_SingleCall_region_Outgoing_default();
									Main_region_CallHandlerSm_react(false);
								}  else
								{
									did_transition = false;
								}
							}
						}
					}
				}
			}
		}
	} 
	if ((did_transition) == (false))
	{ 
		did_transition = Main_region_CallHandlerSm_react(try_transition);
	} 
	return did_transition;
}



