/**
 * @file ObjectPathInfo.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the definition of the ObjectPathInfo class
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "ObjectPathInfo.h"

namespace evobtstackwrapper {

   ObjectPathInfo::ObjectPathInfo() :
      _handsfreeObjectPath(),
      _voiceCallObjectPath(),
      _networkOperatorObjectPath()
   {
   }

   ObjectPathInfo::~ObjectPathInfo()
   {
      _voiceCallObjectPath.clear();
      _networkOperatorObjectPath.clear();
   }

   void ObjectPathInfo::setHandsfreeObjectPath(const ObjectPath& objPath)
   {
      _handsfreeObjectPath = objPath;
   }

   const ObjectPath& ObjectPathInfo::getHandsfreeObjectPath(void) const
   {
      return _handsfreeObjectPath;
   }

   void ObjectPathInfo::removeHandsfreeObjectPath(void)
   {
      _handsfreeObjectPath = "";
   }

   void ObjectPathInfo::setVoiceCallObjectPath(const CallInstance callInstance, const ObjectPath& objPath)
   {
      std::map<CallInstance, ObjectPath>::iterator it = _voiceCallObjectPath.find(callInstance);
      if(it == _voiceCallObjectPath.end())
      {
         _voiceCallObjectPath.insert(std::pair<CallInstance, ObjectPath>(callInstance, objPath));
      }
   }

   void ObjectPathInfo::getVoiceCallObjectPath(const CallInstance callInstance, ObjectPath& objPath)
   {
      std::map<CallInstance, ObjectPath>::iterator it = _voiceCallObjectPath.find(callInstance);
      if(it != _voiceCallObjectPath.end())
      {
         objPath = it->second;
      }
   }

   bool ObjectPathInfo::getCallInstance(const ObjectPath& objPath, CallInstance& callInstance)
   {
      bool retValue = false;

      std::map<CallInstance, ObjectPath>::iterator it;
      for(it = _voiceCallObjectPath.begin(); (it != _voiceCallObjectPath.end()); it++)
      {
         if(objPath == it->second)
         {
            callInstance = it->first;
            retValue = true;
            break;
         }
      }

      return retValue;
   }

   void ObjectPathInfo::removeVoiceCallObjectPath(const CallInstance callInstance)
   {
      std::map<CallInstance, ObjectPath>::iterator it = _voiceCallObjectPath.find(callInstance);
      if(it != _voiceCallObjectPath.end())
      {
         _voiceCallObjectPath.erase(it);
      }
   }

   void ObjectPathInfo::setNetworkOperatorObjectPath(const NetworkOperatorInstance networkOperatorInstance,
         const ObjectPath& objPath)
   {
      std::map<CallInstance, ObjectPath>::iterator it = _networkOperatorObjectPath.find(networkOperatorInstance);
      if(it == _networkOperatorObjectPath.end())
      {
         _networkOperatorObjectPath.insert(std::pair<NetworkOperatorInstance, ObjectPath>(networkOperatorInstance,
               objPath));
      }
   }

   void ObjectPathInfo::getNetworkOperatorObjectPath(const NetworkOperatorInstance networkOperatorInstance,
         ObjectPath& objPath)
   {
      std::map<NetworkOperatorInstance, ObjectPath>::iterator it =
            _networkOperatorObjectPath.find(networkOperatorInstance);
      if(it != _networkOperatorObjectPath.end())
      {
         objPath = it->second;
      }
   }

   bool ObjectPathInfo::getNetworkOperatorInstance(const ObjectPath& objPath,
         NetworkOperatorInstance& networkOperatorInstance)
   {
      bool retValue = false;

      std::map<NetworkOperatorInstance, ObjectPath>::iterator it;
      for(it = _networkOperatorObjectPath.begin(); (it != _networkOperatorObjectPath.end()); it++)
      {
         if(objPath == it->second)
         {
            networkOperatorInstance = it->first;
            retValue = true;
            break;
         }
      }

      return retValue;
   }

   void ObjectPathInfo::removeNetworkOperatorObjectPath(const NetworkOperatorInstance networkOperatorInstance)
   {
      std::map<NetworkOperatorInstance, ObjectPath>::iterator it =
            _networkOperatorObjectPath.find(networkOperatorInstance);
      if(it != _networkOperatorObjectPath.end())
      {
         _networkOperatorObjectPath.erase(it);
      }
   }

} //evobtstackwrapper
