/**
 * @file BtStackTypesTypesInternal.h
 *
 * @swcomponent PhoneCallManager
 *
 * @brief This file contains the internal type definitions of BtStackWrapper
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details BtStackWrapper type definitions are defined here.
 *
 * @ingroup BtStackWrapper
 */

#ifndef BtStackWrapperTypesInternal_h
#define BtStackWrapperTypesInternal_h

#include "EvolutionGeniviDbusTypes.h"
#include "CcDbusIfTypes.h"
#include <string>
#include <vector>

namespace evobtstackwrapper
{
   #define HANDSFREE_OBJECT_PATH_HFP         "/hfp/"

   #define HANDSFREE_OBJECT_PATH_UNDERSCORE  "_"

   #define OUTPROPERTY_LIST_SIZE             1

   #define VOICECALL_OBJECTPATH_LENGTH       40 // length considered for /hfp/xxxxxxxxxxxx_xxxxxxxxxxxx/voicecall

   #define NETWORKOPERATOR_OBJECTPATH_LENGTH 40 // length considered for /hfp/xxxxxxxxxxxx_xxxxxxxxxxxx/operator/

   #define INSTANCE_COUNT_LENGTH             3

   #define DEFAULT_INSTANCE_VALUE            0xFF

   typedef std::string   ObjectPath;

   typedef std::string   ErrorName;

   typedef std::string   ErrorMessage;

   typedef unsigned char CallInstance;

   typedef unsigned char NetworkOperatorInstance;

   /**
    * Type definition for DBUS interface list.
    */
   typedef ::std::vector< ::ccdbusif::evolution::Interface > BTSDbusInterfaceList;

   /**
    * Type definition for DBUS property list.
    */
   typedef ::std::vector< ::ccdbusif::DbusVariantProperty > BTSDbusPropertyList;

   typedef struct
   {
      ::ccdbusif::evolution::Interface _interface;
      bool                             _serviceAvailability;
   } ProxyServiceAvailability;

}

#endif // BtStackWrapperTypesInternal_h
