/**
 * @file EvolutionGeniviDbusHfpVoiceCallProperties.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpVoiceCall
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpVoiceCallProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusHfpVoiceCallProperties::EvolutionGeniviDbusHfpVoiceCallProperties() : DbusProperties("VoiceCall"),
   // properties
   _propertyLineIdentification("LineIdentification"),
   _propertyName("Name"),
   _propertyMultiparty("Multiparty"),
   _propertyState("State"),
   _propertyEmergency("Emergency"),
   _propertyDirection("Direction"),
   _propertyMode("Mode"),
   _propertyType("Type")
{
   _string2EnumList[_propertyLineIdentification] = (int)HFP_VOICE_CALL_LINEIDENTIFICATION;
   _string2EnumList[_propertyName] = (int)HFP_VOICE_CALL_NAME;
   _string2EnumList[_propertyMultiparty] = (int)HFP_VOICE_CALL_MULTIPARTY;
   _string2EnumList[_propertyState] = (int)HFP_VOICE_CALL_STATE;
   _string2EnumList[_propertyEmergency] = (int)HFP_VOICE_CALL_EMERGENCY;
   _string2EnumList[_propertyDirection] = (int)HFP_VOICE_CALL_DIRECTION;
   _string2EnumList[_propertyMode] = (int)HFP_VOICE_CALL_MODE;
   _string2EnumList[_propertyType] = (int)HFP_VOICE_CALL_TYPE;

   _enum2StringList[(int)HFP_VOICE_CALL_LINEIDENTIFICATION] = &_propertyLineIdentification;
   _enum2StringList[(int)HFP_VOICE_CALL_NAME] = &_propertyName;
   _enum2StringList[(int)HFP_VOICE_CALL_MULTIPARTY] = &_propertyMultiparty;
   _enum2StringList[(int)HFP_VOICE_CALL_STATE] = &_propertyState;
   _enum2StringList[(int)HFP_VOICE_CALL_EMERGENCY] = &_propertyEmergency;
   _enum2StringList[(int)HFP_VOICE_CALL_DIRECTION] = &_propertyDirection;
   _enum2StringList[(int)HFP_VOICE_CALL_MODE] = &_propertyMode;
   _enum2StringList[(int)HFP_VOICE_CALL_TYPE] = &_propertyType;
}

EvolutionGeniviDbusHfpVoiceCallProperties::~EvolutionGeniviDbusHfpVoiceCallProperties()
{
}

HfpVoiceCallProperty EvolutionGeniviDbusHfpVoiceCallProperties::getProperty2Enum(const ::std::string& value) const
{
   return (HfpVoiceCallProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusHfpVoiceCallProperties::getProperty2String(
      const HfpVoiceCallProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusHfpVoiceCallProperties::getProperty2StringTrace(
      const HfpVoiceCallProperty value) const
{
   if(HFP_VOICE_CALL_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
