/**
 * @file EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS callback for HfpVoiceCallManager
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf.h"
#include "IBtStackWrapper.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::VoiceCallManager;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf()
{
   _btStackWrapper = nullptr;
}

EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf(
      IBtStackWrapper* btStackWrapper)
{
   _btStackWrapper = btStackWrapper;
}

EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::~EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf()
{
   _btStackWrapper = nullptr;
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onProxyAvailable(const ServiceState previousState,
      const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onProxyUnavailable(const ServiceState previousState,
      const ServiceState currentState, const ::std::string& objPath)
{
   (void)(previousState);
   (void)(currentState);
   (void)(objPath);

   //TODO: implement
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onGetPropertiesError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< GetPropertiesError >& error)
{
   ETG_TRACE_USR4(("onGetPropertiesError(): VoiceCallManager"));

   (void)(proxy);
   (void)(error);

   //TODO: implement
   //const std::string& objPath = proxy->getDBusObjectPath();
   //const std::string& errorName = error->getName();
   //const std::string& errorMessage = error->getMessage();
   //const act_t act = error->getAct();
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onGetPropertiesResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< GetPropertiesResponse >& response)
{
   ETG_TRACE_USR4(("onGetPropertiesResponse(): VoiceCallManager"));

   //check received properties for EmergencyNumbers
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   BTSDbusPropertyList outPropertyList;

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("VoiceCallManager: ObjPath: %s", objPath.c_str()));

   if(true == parser.findAndParseProperty(outPropertyList, response->getPropertiesMutable(),
         parser.getHfpVoiceCallManagerProperty2String(::ccdbusif::evolution::HFP_VOICE_CALL_MANAGER_EMERGENCYNUMBERS),
         (int)::ccdbusif::evolution::IF_VOICE_CALL_MANAGER))
   {
      onEmergencyNumbersChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onGetCallsError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< GetCallsError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onGetCallsError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onGetCallsResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< GetCallsResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& getCallsResponse =
         response->getCalls_with_propertiesMutable();
   const act_t act = response->getAct();

   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);

   std::map<ObjectPath, BTSDbusPropertyList> callsList;
   BTSDbusPropertyList propertiesList;
   ::std::vector<int> matchingInterfaces;
   matchingInterfaces.push_back((int)::ccdbusif::evolution::IF_VOICE_CALL);

   ETG_TRACE_USR4(("onGetCallsResponse: VoiceCallManager: ObjPath: %s", objPath.c_str()));

   for(auto it = getCallsResponse.begin(); it != getCallsResponse.end(); it++)
   {
      ETG_TRACE_USR4(("onGetCallsResponse: VoiceCall: ObjPath: %s", it->getElem1().c_str()));

      parser.parseProperties(propertiesList, matchingInterfaces, it->getElem2Mutable(), ::ccdbusif::BUS_TYPE_SYSTEM,
            proxy->getDBusBusName(), proxy->getDBusObjectPath(), proxy->getInterfaceName());

      callsList.insert(std::pair<ObjectPath, BTSDbusPropertyList>(it->getElem1(), propertiesList));
   }

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onGetCallsResponse(objPath, callsList, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onDialError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< DialError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onDialError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onDialResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< DialResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& path = response->getPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onDialResponse(objPath, path, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onMemDialError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< MemDialError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onMemDialError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onMemDialResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< MemDialResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& path = response->getPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onMemDialResponse(objPath, path, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onRedialError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onRedialError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onRedialResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< RedialResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& path = response->getPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onRedialResponse(objPath, path, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onSwapCallsError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< SwapCallsError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onSwapCallsError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onSwapCallsResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< SwapCallsResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onSwapCallsResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onReleaseAndAnswerError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< ReleaseAndAnswerError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onReleaseAndAnswerError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onReleaseAndAnswerResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< ReleaseAndAnswerResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onReleaseAndAnswerResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onReleaseAndSwapError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< ReleaseAndSwapError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onReleaseAndSwapError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onReleaseAndSwapResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< ReleaseAndSwapResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onReleaseAndSwapResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onHoldAndAnswerError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< HoldAndAnswerError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHoldAndAnswerError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onHoldAndAnswerResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< HoldAndAnswerResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHoldAndAnswerResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onHangupAllError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< HangupAllError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHangupAllError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onHangupAllResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< HangupAllResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHangupAllResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onPrivateChatError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< PrivateChatError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onPrivateChatError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onPrivateChatResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< PrivateChatResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const ::std::vector< ::std::string >& calls = response->getCalls();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onPrivateChatResponse(objPath, calls, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onCreateMultipartyError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< CreateMultipartyError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onCreateMultipartyError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onCreateMultipartyResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< CreateMultipartyResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const ::std::vector< ::std::string >& calls = response->getCalls();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onCreateMultipartyResponse(objPath, calls, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onHangupMultipartyError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< HangupMultipartyError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHangupMultipartyError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onHangupMultipartyResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< HangupMultipartyResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onHangupMultipartyResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onSendTonesError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< SendTonesError >& error)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const std::string& errorName = error->getName();
   const std::string& errorMessage = error->getMessage();
   const act_t act = error->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onSendTonesError(objPath, errorName, errorMessage, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onSendTonesResponse(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< SendTonesResponse >& response)
{
   const std::string& objPath = proxy->getDBusObjectPath();
   const act_t act = response->getAct();

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->onSendTonesResponse(objPath, act);
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onCallAddedError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallAddedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onCallAddedError"));
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onCallAddedSignal(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallAddedSignal >& signal)
{
   ETG_TRACE_USR4(("onCallAddedSignal received"));

   handleCallAdded(signal->getCall(), signal->getPropertiesMutable(),
         ::ccdbusif::BUS_TYPE_SYSTEM, proxy->getDBusBusName(), proxy->getDBusObjectPath(), proxy->getInterfaceName());
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onCallRemovedError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy, const ::boost::shared_ptr< CallRemovedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onCallRemovedError"));
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onCallRemovedSignal(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< CallRemovedSignal >& signal)
{
   ETG_TRACE_USR4(("onCallRemovedSignal received"));

   (void)(proxy);

   if(nullptr != _btStackWrapper)
   {
      _btStackWrapper->voiceCallRemoved(signal->getPath());
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onPropertyChangedError(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< PropertyChangedError >& error)
{
   (void)(proxy);
   (void)(error);
   // is never triggered
   ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onPropertyChangedError"));
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onPropertyChangedSignal(
      const ::boost::shared_ptr< VoiceCallManagerProxy >& proxy,
      const ::boost::shared_ptr< PropertyChangedSignal >& signal)
{
   ETG_TRACE_USR4(("onPropertyChangedSignal(): VoiceCallManager"));

   //check received properties for EmergencyNumbers
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);
   ::ccdbusif::evolution::HfpVoiceCallManagerProperty propEnum =
         parser.getHfpVoiceCallManagerProperty2Enum(signal->getName());

   BTSDbusPropertyList outPropertyList;
   parser.parseProperty(outPropertyList, signal->getValueMutable(), signal->getName(),
         (int)::ccdbusif::evolution::IF_VOICE_CALL_MANAGER);

   const std::string& objPath = proxy->getDBusObjectPath();

   ETG_TRACE_USR4(("VoiceCallManager: ObjPath: %s", objPath.c_str()));

   if(::ccdbusif::evolution::HFP_VOICE_CALL_MANAGER_EMERGENCYNUMBERS == propEnum)
   {
      onEmergencyNumbersChanged(objPath, outPropertyList);
   }

   outPropertyList.clear();
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onEmergencyNumbersChanged(const std::string& objPath,
      const BTSDbusPropertyList outPropertyList)
{
   ETG_TRACE_USR4(("VoiceCallManager: Property: EmergencyNumbers"));

   if(OUTPROPERTY_LIST_SIZE == outPropertyList.size())
   {
      const ::ccdbusif::DbusVariantProperty& outProperty = outPropertyList[0];

      const std::vector<std::string>& emergencyNumbers = outProperty.propData.getStringArray();

      if(nullptr != _btStackWrapper)
      {
         _btStackWrapper->onEmergencyNumbersChanged(objPath, emergencyNumbers);
      }
   }
   else
   {
      ETG_TRACE_ERR(("EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::onEmergencyNumbersChanged:Property list size exceeds max limit"));
   }
}

void EvolutionGeniviDbusHfpVoiceCallManagerCallBackIf::handleCallAdded(const ObjectPath& voiceCallObjPath,
      ::std::map< ::std::string, ::asf::dbus::DBusVariant >& inProperties, const ::ccdbusif::DbusBusType busType,
      const ::ccdbusif::DbusBusName& busName, const ObjectPath& objPath, const ::std::string& interfaceName)
{
   ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
   parser.setTraces(true);

   BTSDbusPropertyList ifProperties;
   ::std::vector<int> matchingInterfaces;
   matchingInterfaces.push_back((int)::ccdbusif::evolution::IF_VOICE_CALL);

   parser.parseProperties(ifProperties, matchingInterfaces, inProperties, busType, busName, objPath, interfaceName);

   if(nullptr != _btStackWrapper)
   {
      // create voice call proxy
      _btStackWrapper->voiceCallCreated(objPath, voiceCallObjPath, ifProperties);
   }
}

} //evobtstackwrapper
