/**
 * @file EvolutionGeniviDbusHfpSiriProperties.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief EvolutionGenivi DBUS properties for HfpSiri
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpSiriProperties.h"

namespace ccdbusif {
namespace evolution {

EvolutionGeniviDbusHfpSiriProperties::EvolutionGeniviDbusHfpSiriProperties() : DbusProperties("Siri"),
   // properties
   _propertyStatus("Status"),
   _propertyNR("NR"),
   _propertyEyesFreeMode("EyesFreeMode"),
   _propertySupportedType("SupportedType")
{
   _string2EnumList[_propertyStatus] = (int)HFP_SIRI_STATUS;
   _string2EnumList[_propertyNR] = (int)HFP_SIRI_NR;
   _string2EnumList[_propertyEyesFreeMode] = (int)HFP_SIRI_EYESFREEMODE;
   _string2EnumList[_propertySupportedType] = (int)HFP_SIRI_SUPPORTEDTYPE;

   _enum2StringList[(int)HFP_SIRI_STATUS] = &_propertyStatus;
   _enum2StringList[(int)HFP_SIRI_NR] = &_propertyNR;
   _enum2StringList[(int)HFP_SIRI_EYESFREEMODE] = &_propertyEyesFreeMode;
   _enum2StringList[(int)HFP_SIRI_SUPPORTEDTYPE] = &_propertySupportedType;
}

EvolutionGeniviDbusHfpSiriProperties::~EvolutionGeniviDbusHfpSiriProperties()
{
}

HfpSiriProperty EvolutionGeniviDbusHfpSiriProperties::getProperty2Enum(const ::std::string& value) const
{
   return (HfpSiriProperty)convertString2Enum(value);
}

const ::std::string& EvolutionGeniviDbusHfpSiriProperties::getProperty2String(const HfpSiriProperty value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& EvolutionGeniviDbusHfpSiriProperties::getProperty2StringTrace(const HfpSiriProperty value) const
{
   if(HFP_SIRI_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_dummyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //evolution
} //ccdbusif
