/**
 * @file EvolutionGeniviDbusHfpNetworkRegistrationRequestIf.cpp
 *
 * @swcomponent PhoneCallManager
 *
 * @brief Interface definition for EvolutionGenivi DBUS Proxy for HfpNetworkRegistration
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details
 *
 * @ingroup BtStackWrapper
 */

#include "EvolutionGeniviDbusHfpNetworkRegistrationRequestIf.h"
#include "IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf.h"
#include "CcDbusIfTypes.h"
#include "CcDbusIfUtils.h"
#include "EvolutionGeniviDbusParser.h"
#include "PmAppTrace.h"

using namespace ::org::ofono::NetworkRegistration;
using namespace ::asf::core;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/EvolutionGeniviDbusHfpNetworkRegistrationRequestIf.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BT_STACK_WRAPPER
#endif
#endif

namespace evobtstackwrapper {

EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::EvolutionGeniviDbusHfpNetworkRegistrationRequestIf()
{
   // _hfpNetworkRegistrationProxy is set later
   _callbackIf = nullptr;
}

EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::~EvolutionGeniviDbusHfpNetworkRegistrationRequestIf()
{
   _callbackIf = nullptr;
}

void EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::createProxy(void)
{
   // these proxies have to be created during runtime
}

void EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::destroyProxy(void)
{
   ETG_TRACE_USR3(("destroyProxy(): NetworkRegistration"));

   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _hfpNetworkRegistrationProxy.resetAllProxiesAndClear();
}

void EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::createRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3(("createRuntimeProxy(): NetworkRegistration: ObjPath: %s", objPath.c_str()));

   if(nullptr != _callbackIf)
   {
      if(false == _hfpNetworkRegistrationProxy.isInstanceAvailable(objPath))
      {
         ::ccdbusif::evolution::EvolutionGeniviDbusParser parser;
         ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
         ::ccdbusif::convertBusType2ConnectorOption(connectorOptions,
               parser.getInterface2BusType(::ccdbusif::evolution::IF_NETWORK_REGISTRATION));

         ::boost::shared_ptr< NetworkRegistrationProxy > hfpNetworkRegistrationProxy =
               NetworkRegistrationProxy::createProxy("pmAppEvoHfpNetworkRegistrationPort",
               parser.getInterface2BusName(::ccdbusif::evolution::IF_NETWORK_REGISTRATION),
               objPath,
               connectorOptions,
               *this);

         _hfpNetworkRegistrationProxy.addProxyInstance(objPath, hfpNetworkRegistrationProxy);
      }
      else
      {
         ETG_TRACE_ERR(("NetworkRegistration Proxy already existing for requested ObjPath"));
      }
   }
}

void EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::destroyRuntimeProxy(const ::std::string& objPath)
{
   ETG_TRACE_USR3(("destroyRuntimeProxy(): NetworkRegistration: ObjPath: %s", objPath.c_str()));

   // HINT: destroying runtime proxy is not possible because ASF is storing a proxy "reference" internally;
   //       therefore reset() call will not causing destruction of proxy
   // HINT: due to this we explicitly have to call sendDeregisterAll() to force removing of signal registration
   //       (DBUS: member=RemoveMatch)
   // HINT: sendDeregisterAll() is automatically called during destruction of proxy

   ::boost::shared_ptr< NetworkRegistrationProxy > hfpNetworkRegistrationProxy;
   if(true == _hfpNetworkRegistrationProxy.isProxyAvailable(hfpNetworkRegistrationProxy, objPath))
   {
      hfpNetworkRegistrationProxy->sendDeregisterAll();
   }
   else
   {
      ETG_TRACE_ERR(("NetworkRegistration Proxy not exist for requested ObjPath"));
   }

   _hfpNetworkRegistrationProxy.removeProxyInstance(objPath);
}

void EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::setCallbackIf(
      IEvolutionGeniviDbusHfpNetworkRegistrationCallBackIf* callbackIf)
{
   _callbackIf = callbackIf;

   // callback interface is now available => but proxy will be created later
}

void EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::deviceCreated(const ::std::string& objPath)
{
   // create runtime proxy
   if(nullptr != _callbackIf)
   {
      createRuntimeProxy(objPath);
   }
}

void EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::deviceRemoved(const ::std::string& objPath)
{
   // destroy runtime proxy
   if(nullptr != _callbackIf)
   {
      destroyRuntimeProxy(objPath);
   }
}

void EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::onAvailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onAvailable(): NetworkRegistration"));

   for(unsigned int i = 0; i < _hfpNetworkRegistrationProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< NetworkRegistrationProxy >& hfpNetworkRegistrationProxy = _hfpNetworkRegistrationProxy[i];
      if((nullptr != hfpNetworkRegistrationProxy.get()) && (proxy == hfpNetworkRegistrationProxy))
      {
         if(nullptr != _callbackIf)
         {
            hfpNetworkRegistrationProxy->sendPropertyChangedRegister(*_callbackIf);

            _callbackIf->onProxyAvailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
                  hfpNetworkRegistrationProxy->getDBusObjectPath());

            //GetProperties
            sendGetPropertiesRequest(hfpNetworkRegistrationProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

void EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::onUnavailable(const boost::shared_ptr<Proxy>& proxy,
      const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("onUnavailable(): NetworkRegistration"));

   for(unsigned int i = 0; i < _hfpNetworkRegistrationProxy.getNumberOfProxyInstances(); i++)
   {
      ::boost::shared_ptr< NetworkRegistrationProxy >& hfpNetworkRegistrationProxy = _hfpNetworkRegistrationProxy[i];
      if((nullptr != hfpNetworkRegistrationProxy.get()) && (proxy == hfpNetworkRegistrationProxy))
      {
         hfpNetworkRegistrationProxy->sendDeregisterAll();

         if(nullptr != _callbackIf)
         {
            _callbackIf->onProxyUnavailable(stateChange.getPreviousState(), stateChange.getCurrentState(),
                  hfpNetworkRegistrationProxy->getDBusObjectPath());
         }
         break;
      }
   }
}

act_t EvolutionGeniviDbusHfpNetworkRegistrationRequestIf::sendGetPropertiesRequest(const ::std::string& objPath)
{
   act_t act = ::ccdbusif::DEFAULT_ACT;
   ::boost::shared_ptr< NetworkRegistrationProxy > proxy;

   if(true == _hfpNetworkRegistrationProxy.isInstanceAvailable(proxy, objPath))
   {
      if((nullptr != _callbackIf) && (nullptr != proxy.get()))
      {
         act = proxy->sendGetPropertiesRequest(*_callbackIf);
      }
   }

   return act;
}

} //evobtstackwrapper
